/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.manifestwriter;

import com.springsource.bundlor.ManifestWriter;
import com.springsource.bundlor.util.BundleManifestUtils;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.parser.manifest.ManifestContents;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import org.springframework.util.FileCopyUtils;

final class JarFileManifestWriter
implements ManifestWriter {
    private final File inputFile;
    private final File outputFile;

    public JarFileManifestWriter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    public void write(ManifestContents manifest) {
        DeflaterOutputStream out = null;
        InputStream in = null;
        try {
            try {
                JarFile inputJar;
                if (this.inputFile.equals(this.outputFile)) {
                    File tempFile = File.createTempFile("com.springsource.bundlor", ".tmp");
                    FileCopyUtils.copy(new FileInputStream(this.inputFile), (OutputStream)new FileOutputStream(tempFile));
                    inputJar = new JarFile(tempFile);
                } else {
                    inputJar = new JarFile(this.inputFile);
                }
                out = new JarOutputStream(new FileOutputStream(this.outputFile));
                this.writeManifest((JarOutputStream)out, BundleManifestUtils.createBundleManifest(manifest));
                Enumeration<JarEntry> entries = inputJar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().equals("META-INF/") || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    if (entry.isDirectory()) {
                        ((JarOutputStream)out).putNextEntry(entry);
                        out.write(new byte[0]);
                        out.flush();
                        ((ZipOutputStream)out).closeEntry();
                        continue;
                    }
                    ((JarOutputStream)out).putNextEntry(new JarEntry(entry.getName()));
                    in = inputJar.getInputStream(entry);
                    this.copy(in, out);
                    out.flush();
                    ((ZipOutputStream)out).closeEntry();
                }
                System.out.printf("Transformed bundle written to '%s'%n", this.outputFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (out != null) {
                    out.flush();
                    ((ZipOutputStream)out).closeEntry();
                    out.flush();
                    ((ZipOutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (out != null) {
                out.flush();
                ((ZipOutputStream)out).closeEntry();
                out.flush();
                ((ZipOutputStream)out).close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void close() {
    }

    private void writeManifest(JarOutputStream out, BundleManifest manifest) throws IOException {
        out.putNextEntry(new JarEntry("META-INF/"));
        out.write(new byte[0]);
        out.flush();
        out.closeEntry();
        out.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        NonClosingOuptutStreamWriter writer = new NonClosingOuptutStreamWriter(out);
        manifest.write(writer);
        ((Writer)writer).flush();
        out.flush();
        out.closeEntry();
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int bytesRead = -1;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    private static class NonClosingOuptutStreamWriter
    extends OutputStreamWriter {
        public NonClosingOuptutStreamWriter(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
        }
    }
}

