/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.deployer.repository.ProtectedStream;
import aQute.bnd.deployer.repository.api.CheckResult;
import aQute.bnd.deployer.repository.api.Decision;
import aQute.bnd.deployer.repository.api.IRepositoryContentProvider;
import aQute.bnd.deployer.repository.api.IRepositoryIndexProcessor;
import aQute.bnd.version.VersionRange;
import aQute.lib.io.IO;
import aQute.libg.generics.Create;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.service.log.LogService;

public final class RepoResourceUtils {
    private static final int READ_AHEAD_MAX = 0x500000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readIndex(String name, URI baseUri, InputStream stream, Collection<IRepositoryContentProvider> contentProviders, IRepositoryIndexProcessor listener, LogService log) throws Exception {
        InputStream bufferedStream = stream.markSupported() ? stream : new BufferedInputStream(stream);
        IRepositoryContentProvider selectedProvider = null;
        IRepositoryContentProvider maybeSelectedProvider = null;
        for (IRepositoryContentProvider provider : contentProviders) {
            CheckResult checkResult;
            try {
                bufferedStream.mark(0x500000);
                checkResult = provider.checkStream(name, new ProtectedStream(bufferedStream));
            }
            finally {
                bufferedStream.reset();
            }
            if (checkResult.getDecision() == Decision.accept) {
                selectedProvider = provider;
                break;
            }
            if (checkResult.getDecision() != Decision.undecided) continue;
            log.log(2, String.format("Content provider '%s' was unable to determine compatibility with index at URL '%s': %s", provider.getName(), baseUri, checkResult.getMessage()));
            if (maybeSelectedProvider != null) continue;
            maybeSelectedProvider = provider;
        }
        if (selectedProvider == null) {
            if (maybeSelectedProvider != null) {
                selectedProvider = maybeSelectedProvider;
                log.log(2, String.format("No content provider matches the specified index unambiguously. Selected '%s' arbitrarily.", selectedProvider.getName()));
            } else {
                throw new IOException("Invalid repository index: no configured content provider understands the specified index.");
            }
        }
        try {
            selectedProvider.parseIndex(bufferedStream, baseUri, listener, log);
        }
        finally {
            IO.close(bufferedStream);
        }
    }

    public static Capability getIdentityCapability(Resource resource) {
        List<Capability> identityCaps = resource.getCapabilities("osgi.identity");
        if (identityCaps == null || identityCaps.isEmpty()) {
            throw new IllegalArgumentException("Resource has no identity capability.");
        }
        return identityCaps.iterator().next();
    }

    public static String getResourceIdentity(Resource resource) {
        return (String)RepoResourceUtils.getIdentityCapability(resource).getAttributes().get("osgi.identity");
    }

    public static aQute.bnd.version.Version getResourceVersion(Resource resource) {
        aQute.bnd.version.Version result;
        Object versionObj = RepoResourceUtils.getIdentityCapability(resource).getAttributes().get("version");
        if (versionObj == null) {
            result = aQute.bnd.version.Version.emptyVersion;
        } else if (versionObj instanceof Version) {
            Version v = (Version)versionObj;
            result = new aQute.bnd.version.Version(v.toString());
        } else {
            throw new IllegalArgumentException("Cannot convert to Version from type: " + versionObj.getClass());
        }
        return result;
    }

    public static URI getContentUrl(Resource resource) {
        List<Capability> caps = resource.getCapabilities("osgi.content");
        if (caps == null || caps.isEmpty()) {
            throw new IllegalArgumentException("Resource has no content capability");
        }
        Object uri = caps.iterator().next().getAttributes().get("url");
        if (uri == null) {
            throw new IllegalArgumentException("Resource content has no 'uri' attribute.");
        }
        if (uri instanceof URI) {
            return (URI)uri;
        }
        try {
            if (uri instanceof URL) {
                return ((URL)uri).toURI();
            }
            if (uri instanceof String) {
                return new URI((String)uri);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert resource content location to a valid URI.", e);
        }
        throw new IllegalArgumentException("Failed to convert resource content location to a valid URI.");
    }

    public static String getContentSha(Resource resource) {
        List<Capability> caps = resource.getCapabilities("osgi.content");
        if (caps == null || caps.isEmpty()) {
            return null;
        }
        Object contentObj = caps.iterator().next().getAttributes().get("osgi.content");
        if (contentObj == null) {
            return null;
        }
        if (contentObj instanceof String) {
            return (String)contentObj;
        }
        throw new IllegalArgumentException("Content attribute is wrong type: " + contentObj.getClass().toString() + " (expected String).");
    }

    public static List<Resource> narrowVersionsByVersionRange(SortedMap<aQute.bnd.version.Version, Resource> versionMap, String rangeStr) {
        ArrayList<Resource> result;
        if ("latest".equals(rangeStr)) {
            aQute.bnd.version.Version highest = versionMap.lastKey();
            result = Create.list(new Resource[]{(Resource)versionMap.get(highest)});
        } else {
            VersionRange range;
            VersionRange versionRange = range = rangeStr != null ? new VersionRange(rangeStr) : null;
            if (range != null && range.getLow() != null) {
                versionMap = versionMap.tailMap(range.getLow());
            }
            result = new ArrayList(versionMap.size());
            for (Map.Entry<aQute.bnd.version.Version, Resource> entry : versionMap.entrySet()) {
                aQute.bnd.version.Version version = entry.getKey();
                if (range == null || range.includes(version)) {
                    result.add(entry.getValue());
                }
                if (range == null || !range.isRange() || version.compareTo(range.getHigh()) < 0) continue;
                break;
            }
        }
        return result;
    }
}

