/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.Utils;

public final class FilesDelta {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.fs.FilesDelta");
    private final ReentrantLock myDataLock = new ReentrantLock();
    private final Set<String> myDeletedPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
    private final Map<BuildRootDescriptor, Set<File>> myFilesToRecompile = new HashMap<BuildRootDescriptor, Set<File>>();

    public void lockData() {
        this.myDataLock.lock();
    }

    public void unlockData() {
        this.myDataLock.unlock();
    }

    public FilesDelta() {
    }

    FilesDelta(Collection<FilesDelta> deltas) {
        for (FilesDelta delta : deltas) {
            this.addAll(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(FilesDelta other) {
        other.lockData();
        try {
            this.myDeletedPaths.addAll(other.myDeletedPaths);
            for (Map.Entry<BuildRootDescriptor, Set<File>> entry : other.myFilesToRecompile.entrySet()) {
                this._addToRecompiled(entry.getKey(), (Collection<File>)entry.getValue());
            }
        }
        finally {
            other.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(DataOutput out) throws IOException {
        this.lockData();
        try {
            out.writeInt(this.myDeletedPaths.size());
            for (String string : this.myDeletedPaths) {
                IOUtil.writeString((String)string, (DataOutput)out);
            }
            out.writeInt(this.myFilesToRecompile.size());
            for (Map.Entry entry : this.myFilesToRecompile.entrySet()) {
                IOUtil.writeString((String)((BuildRootDescriptor)entry.getKey()).getRootId(), (DataOutput)out);
                Set files = (Set)entry.getValue();
                out.writeInt(files.size());
                for (File file : files) {
                    IOUtil.writeString((String)FileUtil.toSystemIndependentName((String)file.getPath()), (DataOutput)out);
                }
            }
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(DataInput in, @NotNull BuildTarget<?> target, BuildRootIndex buildRootIndex) throws IOException {
        if (target == null) {
            FilesDelta.$$$reportNull$$$0(0);
        }
        this.lockData();
        try {
            this.myDeletedPaths.clear();
            int deletedCount = in.readInt();
            while (deletedCount-- > 0) {
                this.myDeletedPaths.add(IOUtil.readString((DataInput)in));
            }
            this.myFilesToRecompile.clear();
            int recompileCount = in.readInt();
            while (recompileCount-- > 0) {
                THashSet files;
                String rootId = IOUtil.readString((DataInput)in);
                Object descriptor = target.findRootDescriptor(rootId, buildRootIndex);
                if (descriptor != null) {
                    files = this.myFilesToRecompile.get(descriptor);
                    if (files == null) {
                        files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                        this.myFilesToRecompile.put((BuildRootDescriptor)descriptor, (Set<File>)files);
                    }
                } else {
                    LOG.debug("Cannot find root by " + rootId + ", delta will be skipped");
                    files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                }
                int filesCount = in.readInt();
                while (filesCount-- > 0) {
                    File file = new File(IOUtil.readString((DataInput)in));
                    if (Utils.IS_TEST_MODE) {
                        LOG.info("Loaded " + file.getPath());
                    }
                    files.add(file);
                }
            }
        }
        finally {
            this.unlockData();
        }
    }

    public static void skip(DataInput in) throws IOException {
        int deletedCount = in.readInt();
        while (deletedCount-- > 0) {
            IOUtil.readString((DataInput)in);
        }
        int recompiledCount = in.readInt();
        while (recompiledCount-- > 0) {
            IOUtil.readString((DataInput)in);
            int filesCount = in.readInt();
            while (filesCount-- > 0) {
                IOUtil.readString((DataInput)in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanges() {
        this.lockData();
        try {
            if (!this.myDeletedPaths.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (!this.myFilesToRecompile.isEmpty()) {
                for (Set<File> files : this.myFilesToRecompile.values()) {
                    if (files.isEmpty()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompile(BuildRootDescriptor root, File file) {
        this.lockData();
        try {
            boolean added = this._addToRecompiled(root, file);
            if (added && !this.myDeletedPaths.isEmpty()) {
                this.myDeletedPaths.remove(FileUtil.toCanonicalPath((String)file.getPath()));
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompileIfNotDeleted(BuildRootDescriptor root, File file) {
        this.lockData();
        try {
            boolean isMarkedDeleted;
            boolean bl = isMarkedDeleted = !this.myDeletedPaths.isEmpty() && this.myDeletedPaths.contains(FileUtil.toCanonicalPath((String)file.getPath()));
            if (!isMarkedDeleted) {
                this._addToRecompiled(root, file);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.unlockData();
        }
    }

    private boolean _addToRecompiled(BuildRootDescriptor root, File file) {
        if (Utils.IS_TEST_MODE) {
            LOG.info("Marking dirty: " + file.getPath());
        }
        return this._addToRecompiled(root, Collections.singleton(file));
    }

    private boolean _addToRecompiled(BuildRootDescriptor root, Collection<File> filesToAdd) {
        THashSet files = this.myFilesToRecompile.get(root);
        if (files == null) {
            files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            this.myFilesToRecompile.put(root, (Set<File>)files);
        }
        return files.addAll(filesToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleted(File file) {
        String path = FileUtil.toCanonicalPath((String)file.getPath());
        this.lockData();
        try {
            for (Set<File> files : this.myFilesToRecompile.values()) {
                files.remove(file);
            }
            this.myDeletedPaths.add(path);
            if (Utils.IS_TEST_MODE) {
                LOG.info("Marking deleted: " + path);
            }
        }
        finally {
            this.unlockData();
        }
    }

    public void clearDeletedPaths() {
        this.lockData();
        try {
            this.myDeletedPaths.clear();
        }
        finally {
            this.unlockData();
        }
    }

    public Set<String> getAndClearDeletedPaths() {
        this.lockData();
        try {
            try {
                THashSet _paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                _paths.addAll(this.myDeletedPaths);
                THashSet tHashSet = _paths;
                this.myDeletedPaths.clear();
                return tHashSet;
            }
            catch (Throwable throwable) {
                this.myDeletedPaths.clear();
                throw throwable;
            }
        }
        finally {
            this.unlockData();
        }
    }

    @NotNull
    public Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile() {
        LOG.assertTrue(this.myDataLock.isHeldByCurrentThread(), (Object)"FilesDelta data must be locked by querying thread");
        Map<BuildRootDescriptor, Set<File>> map = this.myFilesToRecompile;
        if (map == null) {
            FilesDelta.$$$reportNull$$$0(1);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedRecompile(BuildRootDescriptor rd, File file) {
        this.lockData();
        try {
            Set<File> files = this.myFilesToRecompile.get(rd);
            boolean bl = files != null && files.contains(file);
            return bl;
        }
        finally {
            this.unlockData();
        }
    }

    @Nullable
    public Set<File> clearRecompile(BuildRootDescriptor root) {
        this.lockData();
        try {
            Set<File> set = this.myFilesToRecompile.remove(root);
            return set;
        }
        finally {
            this.unlockData();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/fs/FilesDelta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/fs/FilesDelta";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesToRecompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

