/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gant;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;

public class Log4jFileLoggerFactory
implements Logger.Factory {
    private final RollingFileAppender myAppender;
    private final List<String> myCategoriesWithDebugLevel;

    public Log4jFileLoggerFactory(File logFile, String categoriesWithDebugLevel) throws IOException {
        this.myCategoriesWithDebugLevel = categoriesWithDebugLevel.isEmpty() ? Collections.emptyList() : Arrays.asList(categoriesWithDebugLevel.split(","));
        PatternLayout pattern = new PatternLayout("%d [%7r] %6p - %30.30c - %m\n");
        this.myAppender = new RollingFileAppender((Layout)pattern, logFile.getAbsolutePath());
        this.myAppender.setMaxFileSize("20MB");
        this.myAppender.setMaxBackupIndex(10);
    }

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
        if (category == null) {
            Log4jFileLoggerFactory.$$$reportNull$$$0(0);
        }
        Logger logger = Logger.getLogger((String)category);
        logger.addAppender((Appender)this.myAppender);
        logger.setLevel(this.isDebugLevel(category) ? Level.DEBUG : Level.INFO);
        Log4jBasedLogger log4jBasedLogger = new Log4jBasedLogger(logger);
        if (log4jBasedLogger == null) {
            Log4jFileLoggerFactory.$$$reportNull$$$0(1);
        }
        return log4jBasedLogger;
    }

    private boolean isDebugLevel(String category) {
        for (String debug : this.myCategoriesWithDebugLevel) {
            if (!category.startsWith(debug)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gant/Log4jFileLoggerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gant/Log4jFileLoggerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

