/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl.sdk;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsSdkImpl<P extends JpsElement>
extends JpsCompositeElementBase<JpsSdkImpl<P>>
implements JpsSdk<P> {
    private final JpsSdkType<P> mySdkType;
    private String myHomePath;
    private String myVersionString;

    public JpsSdkImpl(String homePath, String versionString, JpsSdkType<P> type, P properties) {
        this.myHomePath = homePath;
        this.myVersionString = versionString;
        this.mySdkType = type;
        this.myContainer.setChild(type.getSdkPropertiesRole(), properties);
    }

    private JpsSdkImpl(JpsSdkImpl<P> original) {
        super(original);
        this.mySdkType = original.mySdkType;
        this.myHomePath = original.myHomePath;
        this.myVersionString = original.myVersionString;
    }

    @Override
    @NotNull
    public JpsSdkImpl<P> createCopy() {
        JpsSdkImpl<P> jpsSdkImpl = new JpsSdkImpl<P>(this);
        if (jpsSdkImpl == null) {
            JpsSdkImpl.$$$reportNull$$$0(0);
        }
        return jpsSdkImpl;
    }

    @Override
    public P getSdkProperties() {
        return this.myContainer.getChild(this.mySdkType.getSdkPropertiesRole());
    }

    @Override
    public JpsSdkReference<P> createReference() {
        return JpsElementFactory.getInstance().createSdkReference(((JpsNamedCompositeElementBase)this.getParent()).getName(), this.mySdkType);
    }

    @Override
    public JpsSdkType<P> getSdkType() {
        return this.mySdkType;
    }

    @Override
    @NotNull
    public JpsLibraryImpl<JpsSdk<P>> getParent() {
        JpsLibraryImpl jpsLibraryImpl = (JpsLibraryImpl)super.getParent();
        if (jpsLibraryImpl == null) {
            JpsSdkImpl.$$$reportNull$$$0(1);
        }
        return jpsLibraryImpl;
    }

    @Override
    public void applyChanges(@NotNull JpsSdkImpl<P> modified) {
        if (modified == null) {
            JpsSdkImpl.$$$reportNull$$$0(2);
        }
        super.applyChanges(modified);
        this.setHomePath(modified.getHomePath());
        this.setVersionString(modified.getVersionString());
    }

    @Override
    public String getHomePath() {
        return this.myHomePath;
    }

    @Override
    public void setHomePath(String homePath) {
        if (!Comparing.equal((String)this.myHomePath, (String)homePath)) {
            this.myHomePath = homePath;
            this.fireElementChanged();
        }
    }

    @Override
    public String getVersionString() {
        return this.myVersionString;
    }

    @Override
    public void setVersionString(String versionString) {
        if (!Comparing.equal((String)this.myVersionString, (String)versionString)) {
            this.myVersionString = versionString;
            this.fireElementChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/library/impl/sdk/JpsSdkImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/library/impl/sdk/JpsSdkImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

