/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingBundleInfoProvider {
    private static final Map<String, Pair<Long, Manifest>> ourCache = new WeakHashMap<String, Pair<Long, Manifest>>();

    public static boolean isBundle(@NotNull String path) {
        if (path == null) {
            CachingBundleInfoProvider.$$$reportNull$$$0(0);
        }
        return CachingBundleInfoProvider.getBundleAttribute(path, "Bundle-SymbolicName") != null;
    }

    public static boolean canBeBundlified(@NotNull String path) {
        if (path == null) {
            CachingBundleInfoProvider.$$$reportNull$$$0(1);
        }
        return path.endsWith(".jar") && new File(path).isFile() && !CachingBundleInfoProvider.isBundle(path);
    }

    @Nullable
    public static String getBundleSymbolicName(@NotNull String path) {
        int p;
        String symbolicName;
        if (path == null) {
            CachingBundleInfoProvider.$$$reportNull$$$0(2);
        }
        if ((symbolicName = CachingBundleInfoProvider.getBundleAttribute(path, "Bundle-SymbolicName")) != null && (p = symbolicName.indexOf(59)) > 0) {
            symbolicName = symbolicName.substring(0, p);
        }
        return symbolicName;
    }

    @Nullable
    public static String getBundleVersion(@NotNull String path) {
        if (path == null) {
            CachingBundleInfoProvider.$$$reportNull$$$0(3);
        }
        return CachingBundleInfoProvider.getBundleAttribute(path, "Bundle-Version");
    }

    public static boolean isFragmentBundle(@NotNull String path) {
        if (path == null) {
            CachingBundleInfoProvider.$$$reportNull$$$0(4);
        }
        return CachingBundleInfoProvider.getBundleAttribute(path, "Fragment-Host") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized String getBundleAttribute(@NotNull String path, @NotNull String attribute) {
        Pair pair;
        block13: {
            if (path == null) {
                CachingBundleInfoProvider.$$$reportNull$$$0(5);
            }
            if (attribute == null) {
                CachingBundleInfoProvider.$$$reportNull$$$0(6);
            }
            pair = ourCache.remove(path);
            try {
                File bundleFile = new File(path);
                if (bundleFile.isDirectory()) {
                    File manifestFile = new File(bundleFile, "META-INF/MANIFEST.MF");
                    if (pair != null && ((Long)pair.first).longValue() == manifestFile.lastModified()) break block13;
                    pair = null;
                    try (FileInputStream stream = new FileInputStream(manifestFile);){
                        Manifest manifest = new Manifest(stream);
                        pair = Pair.create((Object)manifestFile.lastModified(), (Object)manifest);
                        break block13;
                    }
                }
                if (!bundleFile.isFile() || pair != null && ((Long)pair.first).longValue() == bundleFile.lastModified()) break block13;
                pair = null;
                try (JarFile jar = new JarFile(bundleFile);){
                    Manifest manifest = jar.getManifest();
                    if (manifest != null) {
                        pair = Pair.create((Object)bundleFile.lastModified(), (Object)manifest);
                    }
                }
            }
            catch (IOException e) {
                Logger.getInstance(CachingBundleInfoProvider.class).debug((Throwable)e);
            }
        }
        if (pair != null) {
            ourCache.put(path, pair);
            return ((Manifest)pair.second).getMainAttributes().getValue(attribute);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBundle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeBundlified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleSymbolicName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFragmentBundle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

