/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.build.GwtBuildTargetType;
import org.jetbrains.jps.gwt.build.JpsGwtCompilerPaths;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtBuildTarget
extends BuildTarget<BuildRootDescriptor> {
    private final JpsGwtModuleExtension myExtension;

    public GwtBuildTarget(JpsGwtModuleExtension extension) {
        super((BuildTargetType)GwtBuildTargetType.INSTANCE);
        this.myExtension = extension;
    }

    public String getId() {
        return this.myExtension.getModule().getName();
    }

    public JpsGwtModuleExtension getExtension() {
        return this.myExtension;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.unmodifiableCollection(targetRegistry.getModuleBasedTargets(this.myExtension.getModule(), BuildTargetRegistry.ModuleTargetSelector.PRODUCTION));
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<BuildRootDescriptor> roots = new ArrayList<BuildRootDescriptor>();
        this.processGwtExtensionFromDependencies((Consumer<JpsGwtModuleExtension>)((Consumer)extension -> {
            for (JpsModuleSourceRoot sourceRoot : extension.getModule().getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
                File root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
                roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, root, true));
            }
        }));
        ArrayList<BuildRootDescriptor> arrayList = roots;
        if (arrayList == null) {
            GwtBuildTarget.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public void processGwtExtensionFromDependencies(Consumer<JpsGwtModuleExtension> processor) {
        JpsJavaExtensionService.dependencies((JpsModule)this.myExtension.getModule()).recursively().productionOnly().processModules(module -> {
            JpsGwtModuleExtension extension = JpsGwtExtensionService.getInstance().getExtension((JpsModule)module);
            if (extension != null) {
                processor.consume((Object)extension);
            }
        });
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = "GWT in module '" + this.myExtension.getModule().getName() + "'";
        if (string == null) {
            GwtBuildTarget.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        File root = JpsGwtCompilerPaths.getCompilerOutputRoot(this, context.getProjectDescriptor().dataManager.getDataPaths());
        Set<File> set = Collections.singleton(root);
        if (set == null) {
            GwtBuildTarget.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GwtBuildTarget target = (GwtBuildTarget)((Object)o);
        return this.myExtension.equals(target.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/gwt/build/GwtBuildTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

