/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ant;

import com.intellij.ant.ClassFilterAnnotationRegexp;
import com.intellij.ant.PrefixedPath;
import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.InstrumenterClassWriter;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.regexp.Regexp;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Type;

public class Javac2
extends Javac {
    public static final String PROPERTY_INSTRUMENTATION_INCLUDE_JAVA_RUNTIME = "javac2.instrumentation.includeJavaRuntime";
    private ArrayList<File> myFormFiles;
    private List<PrefixedPath> myNestedFormPathList;
    private boolean instrumentNotNull = true;
    private String myNotNullAnnotations = "org.jetbrains.annotations.NotNull";
    private final List<Regexp> myClassFilterAnnotationRegexpList = new ArrayList<Regexp>(0);

    protected boolean areJavaClassesCompiled() {
        return true;
    }

    private void unsupportedOptionMessage(String optionName) {
        if (!this.areJavaClassesCompiled()) {
            this.log("The option " + optionName + " is not supported by InstrumentIdeaExtensions task", 0);
        }
    }

    public boolean getInstrumentNotNull() {
        return this.instrumentNotNull;
    }

    public void setInstrumentNotNull(boolean instrumentNotNull) {
        this.instrumentNotNull = instrumentNotNull;
    }

    public String getNotNullAnnotations() {
        return this.myNotNullAnnotations;
    }

    public void setNotNullAnnotations(String notNullAnnotations) {
        this.myNotNullAnnotations = notNullAnnotations;
    }

    public void add(ClassFilterAnnotationRegexp regexp) {
        this.myClassFilterAnnotationRegexpList.add(regexp.getRegexp(this.getProject()));
    }

    public void setDebugLevel(String v) {
        this.unsupportedOptionMessage("debugLevel");
        super.setDebugLevel(v);
    }

    public void setListfiles(boolean list) {
        this.unsupportedOptionMessage("listFiles");
        super.setListfiles(list);
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.unsupportedOptionMessage("memoryInitialSize");
        super.setMemoryInitialSize(memoryInitialSize);
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.unsupportedOptionMessage("memoryMaximumSize");
        super.setMemoryMaximumSize(memoryMaximumSize);
    }

    public void setEncoding(String encoding) {
        this.unsupportedOptionMessage("encoding");
        super.setEncoding(encoding);
    }

    public void setOptimize(boolean optimize) {
        this.unsupportedOptionMessage("optimize");
        super.setOptimize(optimize);
    }

    public void setDepend(boolean depend) {
        this.unsupportedOptionMessage("depend");
        super.setDepend(depend);
    }

    public void setFork(boolean f) {
        this.unsupportedOptionMessage("fork");
        super.setFork(f);
    }

    public void setExecutable(String forkExec) {
        this.unsupportedOptionMessage("executable");
        super.setExecutable(forkExec);
    }

    public void setCompiler(String compiler) {
        this.unsupportedOptionMessage("compiler");
        super.setCompiler(compiler);
    }

    public void setNestedformdirs(List nestedformdirs) {
        this.myNestedFormPathList = nestedformdirs;
    }

    public List getNestedformdirs() {
        return this.myNestedFormPathList;
    }

    public PrefixedPath createNestedformdirs() {
        PrefixedPath p = new PrefixedPath(this.getProject());
        if (this.myNestedFormPathList == null) {
            this.myNestedFormPathList = new ArrayList<PrefixedPath>();
        }
        this.myNestedFormPathList.add(p);
        return p;
    }

    protected void compile() {
        InstrumentationClassFinder finder;
        if (this.areJavaClassesCompiled()) {
            super.compile();
        }
        if ((finder = this.buildClasspathClassLoader()) == null) {
            return;
        }
        try {
            this.instrumentForms(finder);
            if (this.getInstrumentNotNull()) {
                int instrumented = this.instrumentNotNull(this.getDestdir(), finder);
                this.log("Added @NotNull assertions to " + instrumented + " files", 2);
            }
        }
        finally {
            finder.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentForms(InstrumentationClassFinder finder) {
        ArrayList<File> formsToInstrument = this.myFormFiles;
        if (formsToInstrument.isEmpty()) {
            this.log("No forms to instrument found", 3);
            return;
        }
        HashMap<String, File> class2form = new HashMap<String, File>();
        for (File formFile : formsToInstrument) {
            LwRootContainer rootContainer;
            this.log("compiling form " + formFile.getAbsolutePath(), 3);
            try {
                rootContainer = Utils.getRootContainer((URL)formFile.toURI().toURL(), (PropertiesProvider)new CompiledClassPropertiesProvider(finder.getLoader()));
            }
            catch (AlienFormFileException e) {
                continue;
            }
            catch (Exception e) {
                this.fireError("Cannot process form file " + formFile.getAbsolutePath() + ". Reason: " + e);
                continue;
            }
            String classToBind = rootContainer.getClassToBind();
            if (classToBind == null) continue;
            String name = classToBind.replace('.', '/');
            File classFile = this.getClassFile(name);
            if (classFile == null) {
                this.log(formFile.getAbsolutePath() + ": Class to bind does not exist: " + classToBind, 1);
                continue;
            }
            File alreadyProcessedForm = (File)class2form.get(classToBind);
            if (alreadyProcessedForm != null) {
                this.fireError(formFile.getAbsolutePath() + ": The form is bound to the class " + classToBind + ".\nAnother form " + alreadyProcessedForm.getAbsolutePath() + " is also bound to this class.");
                continue;
            }
            class2form.put(classToBind, formFile);
            try {
                FormErrorInfo[] warnings;
                int version;
                try (FileInputStream stream = new FileInputStream(classFile);){
                    version = InstrumenterClassWriter.getClassFileVersion((ClassReader)new ClassReader((InputStream)stream));
                }
                AntNestedFormLoader formLoader = new AntNestedFormLoader(finder.getLoader(), this.myNestedFormPathList);
                InstrumenterClassWriter classWriter = new InstrumenterClassWriter(InstrumenterClassWriter.getAsmClassWriterFlags((int)version), finder);
                AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, finder, (NestedFormLoader)formLoader, false, (ClassWriter)classWriter);
                codeGenerator.patchFile(classFile);
                for (FormErrorInfo warning : warnings = codeGenerator.getWarnings()) {
                    this.log(formFile.getAbsolutePath() + ": " + warning.getErrorMessage(), 1);
                }
                FormErrorInfo[] errors = codeGenerator.getErrors();
                if (errors.length <= 0) continue;
                StringBuilder message = new StringBuilder();
                for (FormErrorInfo error : errors) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(formFile.getAbsolutePath()).append(": ").append(error.getErrorMessage());
                }
                this.fireError(message.toString());
            }
            catch (Exception e) {
                this.fireError("Forms instrumentation failed for " + formFile.getAbsolutePath() + ": " + e.toString());
            }
        }
    }

    private InstrumentationClassFinder buildClasspathClassLoader() {
        String[] pathElements;
        boolean shouldIncludeJavaRuntime;
        StringBuilder classPathBuffer = new StringBuilder();
        Project project = this.getProject();
        Path cp = new Path(project);
        Javac2.appendPath(cp, this.getBootclasspath());
        cp.setLocation(this.getDestdir().getAbsoluteFile());
        Javac2.appendPath(cp, this.getClasspath());
        Javac2.appendPath(cp, this.getSourcepath());
        Javac2.appendPath(cp, this.getSrcdir());
        if (this.getIncludeantruntime()) {
            cp.addExisting(cp.concatSystemClasspath("last"));
        }
        if (!(shouldIncludeJavaRuntime = this.getIncludejavaruntime())) {
            String propValue;
            shouldIncludeJavaRuntime = project != null ? !"false".equalsIgnoreCase(propValue = project.getProperty(PROPERTY_INSTRUMENTATION_INCLUDE_JAVA_RUNTIME)) && !"no".equalsIgnoreCase(propValue) : true;
        }
        if (shouldIncludeJavaRuntime) {
            cp.addJavaRuntime();
        }
        cp.addExtdirs(this.getExtdirs());
        for (String pathElement : pathElements = cp.list()) {
            classPathBuffer.append(File.pathSeparator);
            classPathBuffer.append(pathElement);
        }
        String classPath = classPathBuffer.toString();
        this.log("classpath=" + classPath, 3);
        try {
            return Javac2.createInstrumentationClassFinder(classPath, shouldIncludeJavaRuntime);
        }
        catch (MalformedURLException e) {
            this.fireError(e.getMessage());
            return null;
        }
    }

    private static URL tryGetJrtURL() {
        String home = System.getProperty("java.home");
        if (new File(home, "lib/jrt-fs.jar").isFile()) {
            try {
                return InstrumentationClassFinder.createJDKPlatformUrl((String)home);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void appendPath(Path cp, Path p) {
        if (p != null && p.size() > 0) {
            cp.append(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int instrumentNotNull(File dir, InstrumentationClassFinder finder) {
        File[] files;
        int instrumented = 0;
        for (File file : files = dir.listFiles()) {
            String name = file.getName();
            if (name.endsWith(".class")) {
                String path = file.getPath();
                this.log("Adding @NotNull assertions to " + path, 3);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    InstrumenterClassWriter writer;
                    FailSafeClassReader reader = new FailSafeClassReader((InputStream)inputStream);
                    int version = InstrumenterClassWriter.getClassFileVersion((ClassReader)reader);
                    if ((version & 0xFFFF) < 49 || this.shouldBeSkippedByAnnotationPattern((ClassReader)reader) || !NotNullVerifyingInstrumenter.processClassFile((FailSafeClassReader)reader, (ClassVisitor)(writer = new InstrumenterClassWriter((ClassReader)reader, InstrumenterClassWriter.getAsmClassWriterFlags((int)version), finder)), (String[])this.myNotNullAnnotations.split(";"))) continue;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(path);){
                        fileOutputStream.write(writer.toByteArray());
                        ++instrumented;
                    }
                }
                catch (IOException e) {
                    this.log("Failed to instrument @NotNull assertion for " + path + ": " + e.getMessage(), 1);
                }
                catch (Exception e) {
                    this.fireError("@NotNull instrumentation failed for " + path + ": " + e.toString());
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            instrumented += this.instrumentNotNull(file, finder);
        }
        return instrumented;
    }

    private boolean shouldBeSkippedByAnnotationPattern(ClassReader reader) {
        if (this.myClassFilterAnnotationRegexpList.isEmpty()) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        reader.accept(new ClassVisitor(589824){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (!result[0]) {
                    String internalName = Type.getType((String)desc).getInternalName();
                    for (Regexp regexp : Javac2.this.myClassFilterAnnotationRegexpList) {
                        if (!regexp.matches(internalName)) continue;
                        result[0] = true;
                        break;
                    }
                }
                return null;
            }
        }, 7);
        return result[0];
    }

    private void fireError(String message) {
        if (this.failOnError) {
            throw new BuildException(message, this.getLocation());
        }
        this.log(message, 0);
    }

    private File getClassFile(String className) {
        String classOrInnerName = this.getClassOrInnerName(className);
        if (classOrInnerName == null) {
            return null;
        }
        return new File(this.getDestdir().getAbsolutePath(), classOrInnerName + ".class");
    }

    private String getClassOrInnerName(String className) {
        File classFile = new File(this.getDestdir().getAbsolutePath(), className + ".class");
        if (classFile.exists()) {
            return className;
        }
        int position = className.lastIndexOf(47);
        if (position == -1) {
            return null;
        }
        return this.getClassOrInnerName(className.substring(0, position) + '$' + className.substring(position + 1));
    }

    protected void resetFileLists() {
        super.resetFileLists();
        this.myFormFiles = new ArrayList();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        super.scanDir(srcDir, destDir, files);
        for (String file : files) {
            if (!file.endsWith(".form")) continue;
            this.log("Found form file " + file, 3);
            this.myFormFiles.add(new File(srcDir, file));
        }
    }

    private static InstrumentationClassFinder createInstrumentationClassFinder(String classPath, boolean shouldIncludeJavaRuntime) throws MalformedURLException {
        URL jrt;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (shouldIncludeJavaRuntime && (jrt = Javac2.tryGetJrtURL()) != null) {
            urls.add(jrt);
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            urls.add(new File(s).toURI().toURL());
        }
        URL[] urlsArr = urls.toArray(new URL[0]);
        return new InstrumentationClassFinder(urlsArr);
    }

    private class AntNestedFormLoader
    implements NestedFormLoader {
        private final ClassLoader myLoader;
        private final List<PrefixedPath> myNestedFormPathList;
        private final HashMap<String, LwRootContainer> myFormCache = new HashMap();

        AntNestedFormLoader(ClassLoader loader, List nestedFormPathList) {
            this.myLoader = loader;
            this.myNestedFormPathList = nestedFormPathList;
        }

        public LwRootContainer loadForm(String formFilePath) throws Exception {
            InputStream resourceStream;
            if (this.myFormCache.containsKey(formFilePath)) {
                return this.myFormCache.get(formFilePath);
            }
            String lowerFormFilePath = formFilePath.toLowerCase(Locale.ENGLISH);
            Javac2.this.log("Searching for form " + lowerFormFilePath, 3);
            for (File file : Javac2.this.myFormFiles) {
                String name = file.getAbsolutePath().replace(File.separatorChar, '/').toLowerCase(Locale.ENGLISH);
                Javac2.this.log("Comparing with " + name, 3);
                if (!name.endsWith(lowerFormFilePath)) continue;
                return this.loadForm(formFilePath, new FileInputStream(file));
            }
            if (this.myNestedFormPathList != null) {
                for (PrefixedPath path : this.myNestedFormPathList) {
                    File formFile = path.findFile(formFilePath);
                    if (formFile == null) continue;
                    return this.loadForm(formFilePath, new FileInputStream(formFile));
                }
            }
            if ((resourceStream = this.myLoader.getResourceAsStream(formFilePath)) != null) {
                return this.loadForm(formFilePath, resourceStream);
            }
            throw new Exception("Cannot find nested form file " + formFilePath);
        }

        private LwRootContainer loadForm(String formFileName, InputStream resourceStream) throws Exception {
            LwRootContainer container = Utils.getRootContainer((InputStream)resourceStream, null);
            this.myFormCache.put(formFileName, container);
            return container;
        }

        public String getClassToBindName(LwRootContainer container) {
            String className = container.getClassToBind();
            String result = Javac2.this.getClassOrInnerName(className.replace('.', '/'));
            if (result != null) {
                return result.replace('/', '.');
            }
            return className;
        }
    }
}

