// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.UIFormXmlConstants;
import org.jdom.Element;

import java.lang.reflect.Method;

public class LwIntroEnumProperty extends LwIntrospectedProperty {
  private final Class myEnumClass;

  public LwIntroEnumProperty(final String name, final Class enumClass) {
    super(name, enumClass.getName());
    myEnumClass = enumClass;
  }

  @Override
  public Object read(Element element) throws Exception {
    String value = element.getAttributeValue(UIFormXmlConstants.ATTRIBUTE_VALUE);
    final Method method = myEnumClass.getMethod("valueOf", String.class);
    return method.invoke(null, value);
  }

  @Override
  public String getCodeGenPropertyClassName() {
    return "java.lang.Enum";
  }
}
