/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.diagnostics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.diagnostics.DiagnosticEvent;
import com.intellij.ml.diagnostics.DiagnosticsEventListener;
import com.intellij.ml.diagnostics.listeners.IdeaLogListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0006\u0010\u0012\u001a\u00020\u0013R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/diagnostics/DiagnosticEventBus;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/diagnostics/DiagnosticsEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "attach", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "fire", "producer", "Lkotlin/Function0;", "Lcom/intellij/ml/diagnostics/DiagnosticEvent;", "hasListeners", "", "Companion", "intellij.ml.diagnostics"})
@ApiStatus.Internal
public final class DiagnosticEventBus
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventDispatcher<DiagnosticsEventListener> dispatcher;

    public DiagnosticEventBus() {
        EventDispatcher eventDispatcher = EventDispatcher.create(DiagnosticsEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
        this.attach(new IdeaLogListener());
    }

    public final void attach(@NotNull Disposable disposable, @NotNull DiagnosticsEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener, disposable);
    }

    public static /* synthetic */ void attach$default(DiagnosticEventBus diagnosticEventBus, Disposable disposable, DiagnosticsEventListener diagnosticsEventListener, int n, Object object) {
        if ((n & 1) != 0) {
            disposable = (Disposable)diagnosticEventBus;
        }
        diagnosticEventBus.attach(disposable, diagnosticsEventListener);
    }

    public final void attach(@NotNull DiagnosticsEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.attach((Disposable)this, listener);
    }

    public final void fire(@NotNull Function0<? extends DiagnosticEvent> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        if (!this.hasListeners()) {
            return;
        }
        DiagnosticEvent event = (DiagnosticEvent)producer.invoke();
        ((DiagnosticsEventListener)this.dispatcher.getMulticaster()).on(event);
    }

    public final boolean hasListeners() {
        return this.dispatcher.hasListeners();
    }

    @JvmStatic
    @NotNull
    public static final DiagnosticEventBus getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/diagnostics/DiagnosticEventBus$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/diagnostics/DiagnosticEventBus;", "intellij.ml.diagnostics"})
    @SourceDebugExtension(value={"SMAP\nDiagnosticEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticEventBus.kt\ncom/intellij/ml/diagnostics/DiagnosticEventBus$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n42#2,3:50\n*S KotlinDebug\n*F\n+ 1 DiagnosticEventBus.kt\ncom/intellij/ml/diagnostics/DiagnosticEventBus$Companion\n*L\n38#1:50,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DiagnosticEventBus getInstance() {
            boolean $i$f$service = false;
            Class<DiagnosticEventBus> serviceClass$iv = DiagnosticEventBus.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DiagnosticEventBus)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

