/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.ImmutableCharSequence;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CompletionAssertions {
    @ApiStatus.Internal
    public static void checkEditorValid(Editor editor) {
        if (!CompletionAssertions.isEditorValid(editor)) {
            throw new AssertionError();
        }
    }

    @ApiStatus.Internal
    public static boolean isEditorValid(Editor editor) {
        EditorWindow editorWindow;
        return !(editor instanceof EditorWindow) || (editorWindow = (EditorWindow)editor).isValid();
    }

    private static Attachment createAstAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath() + " syntactic tree.txt", DebugUtil.psiToString((PsiElement)fileCopy, (boolean)true, (boolean)true));
    }

    private static Attachment createFileTextAttachment(PsiFile fileCopy, PsiFile originalFile) {
        return new Attachment(originalFile.getViewProvider().getVirtualFile().getPath(), fileCopy.getText());
    }

    static void assertInjectedOffsets(int hostStartOffset, PsiFile injected, DocumentWindow documentWindow) {
        assert (documentWindow != null) : "no DocumentWindow for an injected fragment";
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)injected.getProject());
        TextRange injectedRange = injected.getTextRange();
        int hostMinOffset = injectedLanguageManager.injectedToHost((PsiElement)injected, injectedRange.getStartOffset(), true);
        int hostMaxOffset = injectedLanguageManager.injectedToHost((PsiElement)injected, injectedRange.getEndOffset(), false);
        assert (hostStartOffset >= hostMinOffset) : "startOffset before injected";
        assert (hostStartOffset <= hostMaxOffset) : "startOffset after injected";
    }

    static void assertHostInfo(PsiFile hostCopy, OffsetMap hostMap) {
        PsiUtilCore.ensureValid((PsiElement)hostCopy);
        if (hostMap.getOffset(CompletionInitializationContext.START_OFFSET) > hostCopy.getTextLength()) {
            throw new AssertionError((Object)("startOffset outside the host file: " + hostMap.getOffset(CompletionInitializationContext.START_OFFSET) + "; " + String.valueOf(hostCopy)));
        }
    }

    @Contract(value="_,_,_,null->fail")
    static void assertCompletionPositionPsiConsistent(OffsetsInFile offsets, int offset, PsiFile originalFile, PsiElement insertedElement) {
        PsiFile fileCopy = offsets.getFile();
        if (insertedElement == null) {
            throw new RuntimeExceptionWithAttachments("No element at insertion offset", "offset=" + offset, new Attachment[]{CompletionAssertions.createFileTextAttachment(fileCopy, originalFile), CompletionAssertions.createAstAttachment(fileCopy, originalFile)});
        }
        TextRange range = insertedElement.getTextRange();
        CharSequence fileCopyText = fileCopy.getViewProvider().getContents();
        if (range.getEndOffset() > fileCopyText.length() || !CompletionAssertions.isEquals(fileCopyText.subSequence(range.getStartOffset(), range.getEndOffset()), insertedElement.getNode().getChars())) {
            throw new RuntimeExceptionWithAttachments("Inconsistent completion tree", "range=" + String.valueOf(range) + "; fileLength=" + fileCopyText.length(), new Attachment[]{CompletionAssertions.createFileTextAttachment(fileCopy, originalFile), CompletionAssertions.createAstAttachment(fileCopy, originalFile), new Attachment("Element at caret.txt", insertedElement.getText())});
        }
    }

    private static boolean isEquals(CharSequence left, CharSequence right) {
        if (left == right) {
            return true;
        }
        if (left instanceof ImmutableCharSequence && right instanceof ImmutableCharSequence) {
            return left.equals(right);
        }
        return left.toString().equals(right.toString());
    }

    static void assertCorrectOriginalFile(@NonNls String prefix, PsiFile file, PsiFile copy) {
        if (copy.getOriginalFile() != file) {
            throw new AssertionError((Object)(prefix + " copied file doesn't have correct original: noOriginal=" + (copy.getOriginalFile() == copy) + "\n file " + CompletionAssertions.fileInfo(file) + "\n copy " + CompletionAssertions.fileInfo(copy)));
        }
    }

    @NonNls
    private static String fileInfo(PsiFile file) {
        return String.valueOf(file) + " of " + String.valueOf(file.getClass()) + " in " + String.valueOf(file.getViewProvider()) + ", languages=" + String.valueOf(file.getViewProvider().getLanguages()) + ", physical=" + file.isPhysical();
    }

    private static class RangeMarkerSpy
    implements DocumentListener {
        private final WeakReference<WatchingInsertionContext> myContextRef;
        private final RangeMarker myMarker;

        RangeMarkerSpy(@NotNull WatchingInsertionContext context, @NotNull RangeMarker marker) {
            if (context == null) {
                RangeMarkerSpy.$$$reportNull$$$0(0);
            }
            if (marker == null) {
                RangeMarkerSpy.$$$reportNull$$$0(1);
            }
            this.myContextRef = new WeakReference<WatchingInsertionContext>(context);
            this.myMarker = marker;
            assert (this.myMarker.isValid());
        }

        protected void invalidated(@NotNull DocumentEvent e) {
            WatchingInsertionContext context;
            if (e == null) {
                RangeMarkerSpy.$$$reportNull$$$0(2);
            }
            if ((context = (WatchingInsertionContext)((Object)this.myContextRef.get())) != null && context.invalidateTrace == null) {
                context.invalidateTrace = new Throwable();
                context.killer = e;
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                RangeMarkerSpy.$$$reportNull$$$0(3);
            }
            if (!this.myMarker.isValid()) {
                this.invalidated(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/completion/CompletionAssertions$RangeMarkerSpy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invalidated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static final class WatchingInsertionContext
    extends InsertionContext
    implements Disposable {
        private RangeMarkerEx tailWatcher;
        Throwable invalidateTrace;
        DocumentEvent killer;
        private RangeMarkerSpy spy;

        WatchingInsertionContext(@NotNull OffsetMap offsetMap, @NotNull PsiFile file, char completionChar, @NotNull List<LookupElement> items, @NotNull Editor editor) {
            if (offsetMap == null) {
                WatchingInsertionContext.$$$reportNull$$$0(0);
            }
            if (file == null) {
                WatchingInsertionContext.$$$reportNull$$$0(1);
            }
            if (items == null) {
                WatchingInsertionContext.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                WatchingInsertionContext.$$$reportNull$$$0(3);
            }
            super(offsetMap, completionChar, items.toArray(LookupElement.EMPTY_ARRAY), file, editor, WatchingInsertionContext.shouldAddCompletionChar((char)completionChar));
        }

        @ApiStatus.Internal
        public Throwable getInvalidateTrace() {
            return this.invalidateTrace;
        }

        public void setTailOffset(int offset) {
            super.setTailOffset(offset);
            this.watchTail(offset);
        }

        private void watchTail(int offset) {
            this.stopWatching();
            this.tailWatcher = (RangeMarkerEx)this.getDocument().createRangeMarker(offset, offset);
            if (!this.tailWatcher.isValid()) {
                throw new AssertionError((Object)(String.valueOf(this.getDocument()) + "; offset=" + offset));
            }
            this.tailWatcher.setGreedyToRight(true);
            this.spy = new RangeMarkerSpy(this, (RangeMarker)this.tailWatcher);
            this.getDocument().addDocumentListener((DocumentListener)this.spy);
        }

        @ApiStatus.Internal
        public void stopWatching() {
            if (this.tailWatcher != null) {
                if (this.spy != null) {
                    this.getDocument().removeDocumentListener((DocumentListener)this.spy);
                    this.spy = null;
                }
                this.tailWatcher.dispose();
            }
        }

        public int getTailOffset() {
            if (!this.getOffsetMap().containsOffset(TAIL_OFFSET) && this.invalidateTrace != null) {
                throw new RuntimeExceptionWithAttachments("Tail offset invalid", new Attachment[]{new Attachment("invalidated", this.invalidateTrace)});
            }
            int offset = super.getTailOffset();
            if (this.tailWatcher.getStartOffset() != this.tailWatcher.getEndOffset() && offset > 0) {
                this.watchTail(offset);
            }
            return offset;
        }

        public void dispose() {
            this.stopWatching();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "offsetMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "items";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/CompletionAssertions$WatchingInsertionContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

