/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AnnotatorStatisticsCollector {
    private final Map<Class<? extends Annotator>, DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics> myAnnotatorStats = new ConcurrentHashMap<Class<? extends Annotator>, DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics>();

    public void reportAnnotationProduced(@NotNull Annotator annotator, @NotNull Annotation annotation) {
        if (annotator == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(1);
        }
        DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat = this.createStatistics(annotator);
        if (stat.firstAnnotation == null) {
            stat.firstAnnotation = annotation;
            stat.firstAnnotationStamp = System.nanoTime();
        }
        stat.lastAnnotation = annotation;
        stat.lastAnnotationStamp = System.nanoTime();
    }

    public void reportAnalysisFinished(@NotNull Project project, @NotNull AnnotationSession session, @NotNull PsiFile file) {
        if (project == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (session == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(3);
        }
        if (file == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(4);
        }
        for (DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat : this.myAnnotatorStats.values()) {
            stat.annotatorFinishStamp = System.nanoTime();
        }
        ((DaemonCodeAnalyzer.DaemonListener)project.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonAnnotatorStatisticsGenerated(session, this.myAnnotatorStats.values(), file);
        this.myAnnotatorStats.clear();
    }

    public void reportNewAnnotatorCreated(@NotNull Annotator annotator) {
        if (annotator == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(5);
        }
        this.createStatistics(annotator);
    }

    @NotNull
    private DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics createStatistics(@NotNull Annotator annotator) {
        if (annotator == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(6);
        }
        DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics annotatorStatistics = this.myAnnotatorStats.computeIfAbsent(annotator.getClass(), __ -> new DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics(annotator));
        if (annotatorStatistics == null) {
            AnnotatorStatisticsCollector.$$$reportNull$$$0(7);
        }
        return annotatorStatistics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/AnnotatorStatisticsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/AnnotatorStatisticsCollector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reportAnnotationProduced";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportAnalysisFinished";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportNewAnnotatorCreated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStatistics";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

