/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.ResultSink;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.PassRunningAssert;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightVisitorRunner {
    @NotNull
    private final @NotNull Supplier<? extends @NotNull HighlightVisitor @NotNull []> myHighlightVisitorProducer;
    private static final PassRunningAssert HIGHLIGHTING_PERFORMANCE_ASSERT = new PassRunningAssert("the expensive method should not be called inside the highlighting pass");
    private static final PsiElement ANALYZE_BEFORE_RUN_VISITOR_FAKE_PSI_ELEMENT = HighlightInfoUpdaterImpl.createFakePsiElement();
    private static final PsiElement ANALYZE_AFTER_RUN_VISITOR_FAKE_PSI_ELEMENT = HighlightInfoUpdaterImpl.createFakePsiElement();

    HighlightVisitorRunner(@NotNull PsiFile psiFile, @Nullable TextAttributesScheme scheme, boolean runVisitors, boolean highlightErrorElements) {
        if (psiFile == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(0);
        }
        this.myHighlightVisitorProducer = runVisitors ? () -> HighlightVisitorRunner.cloneAndFilterHighlightVisitors(psiFile, scheme) : () -> new HighlightVisitor[]{new DefaultHighlightVisitor(psiFile.getProject(), highlightErrorElements, false)};
    }

    static void assertHighlightingPassNotRunning() {
        HIGHLIGHTING_PERFORMANCE_ASSERT.assertPassNotRunning();
    }

    @NotNull
    private static @NotNull HighlightVisitor @NotNull [] cloneAndFilterHighlightVisitors(@NotNull PsiFile psiFile, @Nullable TextAttributesScheme colorsScheme) {
        if (psiFile == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(1);
        }
        Project project = psiFile.getProject();
        Object[] visitors = (HighlightVisitor[])HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensions((AreaInstance)project);
        DumbService dumbService = DumbService.getInstance((Project)project);
        int o = 0;
        Object[] clones = new HighlightVisitor[visitors.length];
        for (HighlightVisitor highlightVisitor : visitors) {
            int index;
            if (!dumbService.isUsableInCurrentContext((Object)highlightVisitor) || highlightVisitor instanceof RainbowVisitor && !RainbowHighlighter.isRainbowEnabledWithInheritance(colorsScheme, psiFile.getLanguage()) || !highlightVisitor.suitableForFile(psiFile)) continue;
            HighlightVisitor cloned = highlightVisitor.clone();
            assert (cloned.getClass() == highlightVisitor.getClass()) : String.valueOf(highlightVisitor.getClass()) + ".clone() must return a copy of " + String.valueOf(highlightVisitor.getClass()) + "; but got: " + String.valueOf(cloned) + " (" + String.valueOf(cloned.getClass()) + ")";
            if (cloned.supersedesDefaultHighlighter() && (index = ContainerUtil.indexOf((Object[])clones, e -> e instanceof DefaultHighlightVisitor)) >= 0) {
                clones[index] = cloned;
                continue;
            }
            clones[o++] = cloned;
        }
        if (o == 0) {
            GeneralHighlightingPass.LOG.error("No visitors registered. all visitors:" + Arrays.toString(visitors));
        }
        HighlightVisitor[] highlightVisitorArray = (HighlightVisitor[])ArrayUtil.realloc((Object[])clones, (int)o, HighlightVisitor.ARRAY_FACTORY);
        if (highlightVisitorArray == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(2);
        }
        return highlightVisitorArray;
    }

    void createHighlightVisitorsFor(@NotNull Consumer<? super HighlightVisitor[]> consumer) {
        if (consumer == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(3);
        }
        HighlightVisitor[] filtered = this.myHighlightVisitorProducer.get();
        consumer.consume((Object)filtered);
    }

    boolean runVisitors(@NotNull PsiFile psiFile, @NotNull List<? extends PsiElement> elements1, @NotNull List<? extends PsiElement> elements2, HighlightVisitor @NotNull [] visitors, boolean forceHighlightParents, int chunkSize, boolean myUpdateAll, @NotNull Supplier<? extends HighlightInfoHolder> infoHolderProducer, @NotNull ResultSink resultSink) {
        if (psiFile == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(4);
        }
        if (elements1 == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(5);
        }
        if (elements2 == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(6);
        }
        if (infoHolderProducer == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(7);
        }
        if (resultSink == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(8);
        }
        if (visitors == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(9);
        }
        List visitorInfos = ContainerUtil.map((Object[])visitors, v -> new VisitorInfo((HighlightVisitor)v, (Set<PsiElement>)new HashSet<PsiElement>(), (HighlightInfoHolder)infoHolderProducer.get()));
        if (GeneralHighlightingPass.LOG.isDebugEnabled()) {
            GeneralHighlightingPass.LOG.debug("HighlightVisitorRunner: visitors: " + Arrays.toString(visitors) + "; psiFile=" + String.valueOf(psiFile));
        }
        boolean res = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(visitorInfos, ProgressIndicatorProvider.getGlobalProgressIndicator(), visitorInfo -> {
            HighlightVisitor visitor = visitorInfo.visitor();
            if (GeneralHighlightingPass.LOG.isDebugEnabled()) {
                GeneralHighlightingPass.LOG.debug("HighlightVisitorRunner: running visitor: " + String.valueOf(visitor) + "(" + String.valueOf(visitor.getClass()) + "); psiFile=" + String.valueOf(psiFile) + "; " + String.valueOf(Thread.currentThread()));
            }
            try {
                int[] sizeAfterRunVisitor = new int[1];
                HighlightInfoHolder holder = visitorInfo.holder();
                boolean result = visitor.analyze(psiFile, myUpdateAll, holder, () -> {
                    HighlightVisitorRunner.reportOutOfRunVisitorInfos(0, ANALYZE_BEFORE_RUN_VISITOR_FAKE_PSI_ELEMENT, holder, visitor, resultSink);
                    HighlightVisitorRunner.runVisitor(psiFile, elements1, chunkSize, visitorInfo.skipParentsSet(), holder, forceHighlightParents, visitor, resultSink);
                    HighlightVisitorRunner.runVisitor(psiFile, elements2, chunkSize, visitorInfo.skipParentsSet(), holder, forceHighlightParents, visitor, resultSink);
                    sizeAfterRunVisitor[0] = holder.size();
                });
                HighlightVisitorRunner.reportOutOfRunVisitorInfos(sizeAfterRunVisitor[0], ANALYZE_AFTER_RUN_VISITOR_FAKE_PSI_ELEMENT, holder, visitor, resultSink);
                if (GeneralHighlightingPass.LOG.isDebugEnabled()) {
                    GeneralHighlightingPass.LOG.debug("HighlightVisitorRunner: visitor finished " + String.valueOf(visitor) + "(" + String.valueOf(visitor.getClass()) + ")" + (result ? "" : " returned false") + "; holder: " + holder.size() + " results; " + String.valueOf(Thread.currentThread()));
                }
                return result;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (GeneralHighlightingPass.LOG.isDebugEnabled()) {
                    GeneralHighlightingPass.LOG.debug("GHP: visitor " + String.valueOf(visitor) + "(" + String.valueOf(visitor.getClass()) + ") threw " + ExceptionUtil.getThrowableText((Throwable)e) + "; " + String.valueOf(Thread.currentThread()));
                }
                throw e;
            }
        });
        if (GeneralHighlightingPass.LOG.isDebugEnabled()) {
            GeneralHighlightingPass.LOG.debug("HighlightVisitorRunner: all visitors ran; result=" + res + " visitorInfos=" + String.valueOf(visitorInfos) + "; " + String.valueOf(Thread.currentThread()));
        }
        return res;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void reportOutOfRunVisitorInfos(int fromIndex, @NotNull PsiElement fakePsiElement, @NotNull HighlightInfoHolder holder, @NotNull HighlightVisitor visitor, @NotNull ResultSink resultSink) {
        List<HighlightInfo> newInfos;
        if (fakePsiElement == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(11);
        }
        if (visitor == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(12);
        }
        if (resultSink == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(13);
        }
        if (holder.size() > fromIndex) {
            newInfos = new ArrayList(holder.size() - fromIndex);
            Class<@NotNull ?> toolId = visitor.getClass();
            for (int i = fromIndex; i < holder.size(); ++i) {
                HighlightInfo info = holder.get(i);
                newInfos.add(info);
                info.toolId = toolId;
                info.setGroup(-6);
            }
        } else {
            newInfos = List.of();
        }
        resultSink.accept(visitor.getClass(), fakePsiElement, newInfos);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void runVisitor(@NotNull PsiFile psiFile, @NotNull List<? extends PsiElement> elements, int chunkSize, @NotNull Set<? super PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder, boolean forceHighlightParents, @NotNull HighlightVisitor visitor, @NotNull ResultSink resultSink) {
        if (psiFile == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(15);
        }
        if (skipParentsSet == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(17);
        }
        if (visitor == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(18);
        }
        if (resultSink == null) {
            HighlightVisitorRunner.$$$reportNull$$$0(19);
        }
        boolean failed = false;
        int nextLimit = chunkSize;
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        Class<@NotNull ?> toolId = visitor.getClass();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement psiElement = elements.get(i);
            ProgressManager.checkCanceled();
            PsiElement parent = psiElement.getParent();
            if (psiElement != psiFile && !skipParentsSet.isEmpty() && psiElement.getFirstChild() != null && skipParentsSet.contains(psiElement) && parent != null) {
                skipParentsSet.add((PsiElement)parent);
            } else {
                int oldSize = holder.size();
                try {
                    visitor.visit(psiElement);
                }
                catch (IndexNotReadyException e) {
                    break;
                }
                catch (Exception e) {
                    if (Logger.shouldRethrow((Throwable)e)) {
                        throw e;
                    }
                    if (!failed) {
                        GeneralHighlightingPass.LOG.error("In file: " + String.valueOf(psiFile.getViewProvider().getVirtualFile()), (Throwable)e);
                    }
                    failed = true;
                }
                for (int j = oldSize; j < holder.size(); ++j) {
                    boolean isError;
                    HighlightInfo info = holder.get(j);
                    boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                    if (isError && !forceHighlightParents && parent != null) {
                        skipParentsSet.add((PsiElement)parent);
                    }
                    info.toolId = toolId;
                    info.setGroup(-6);
                    infos.add(info);
                }
            }
            resultSink.accept(toolId, psiElement, infos);
            if (!infos.isEmpty()) {
                infos.clear();
            }
            if (i != nextLimit) continue;
            nextLimit = i + chunkSize;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorRunner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoHolderProducer";
                break;
            }
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakePsiElement";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipParentsSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneAndFilterHighlightVisitors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cloneAndFilterHighlightVisitors";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightVisitorsFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runVisitors";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportOutOfRunVisitorInfos";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private record VisitorInfo(@NotNull HighlightVisitor visitor, @NotNull Set<PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder) {
        @NotNull
        private final HighlightVisitor visitor;
        @NotNull
        private final Set<PsiElement> skipParentsSet;
        @NotNull
        private final HighlightInfoHolder holder;

        private VisitorInfo(@NotNull HighlightVisitor visitor, @NotNull Set<PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder) {
            if (visitor == null) {
                VisitorInfo.$$$reportNull$$$0(0);
            }
            if (skipParentsSet == null) {
                VisitorInfo.$$$reportNull$$$0(1);
            }
            if (holder == null) {
                VisitorInfo.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public HighlightVisitor visitor() {
            HighlightVisitor highlightVisitor = this.visitor;
            if (highlightVisitor == null) {
                VisitorInfo.$$$reportNull$$$0(3);
            }
            return highlightVisitor;
        }

        @NotNull
        public Set<PsiElement> skipParentsSet() {
            Set<PsiElement> set = this.skipParentsSet;
            if (set == null) {
                VisitorInfo.$$$reportNull$$$0(4);
            }
            return set;
        }

        @NotNull
        public HighlightInfoHolder holder() {
            HighlightInfoHolder highlightInfoHolder = this.holder;
            if (highlightInfoHolder == null) {
                VisitorInfo.$$$reportNull$$$0(5);
            }
            return highlightInfoHolder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "skipParentsSet";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorRunner$VisitorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorRunner$VisitorInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "skipParentsSet";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "holder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

