/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DfaCondition
permits Exact, DfaRelation {
    @NotNull
    @Contract(pure=true)
    public DfaCondition negate();

    default public DfaCondition correctForRelationResult(boolean result) {
        return this;
    }

    @Contract(pure=true)
    public static DfaCondition getTrue() {
        return Exact.TRUE;
    }

    @Contract(pure=true)
    public static DfaCondition getFalse() {
        return Exact.FALSE;
    }

    @Contract(pure=true)
    public static DfaCondition getUnknown() {
        return Exact.UNKNOWN;
    }

    public boolean isUnknown();

    @NotNull
    public static DfaCondition createCondition(@NotNull DfaValue left, @NotNull RelationType relationType, @NotNull DfaValue right) {
        Exact value;
        if (left == null) {
            DfaCondition.$$$reportNull$$$0(0);
        }
        if (relationType == null) {
            DfaCondition.$$$reportNull$$$0(1);
        }
        if (right == null) {
            DfaCondition.$$$reportNull$$$0(2);
        }
        if ((value = Exact.tryEvaluate(left, relationType, right)) != null) {
            Exact exact = value;
            if (exact == null) {
                DfaCondition.$$$reportNull$$$0(3);
            }
            return exact;
        }
        DfaRelation relation = DfaRelation.createRelation(left, relationType, right);
        if (relation != null) {
            DfaRelation dfaRelation = relation;
            if (dfaRelation == null) {
                DfaCondition.$$$reportNull$$$0(4);
            }
            return dfaRelation;
        }
        Exact exact = Exact.UNKNOWN;
        if (exact == null) {
            DfaCondition.$$$reportNull$$$0(5);
        }
        return exact;
    }

    @Nullable
    public static Exact tryEvaluate(@NotNull DfType leftType, @NotNull RelationType relationType, @NotNull DfType rightType) {
        if (leftType == null) {
            DfaCondition.$$$reportNull$$$0(6);
        }
        if (relationType == null) {
            DfaCondition.$$$reportNull$$$0(7);
        }
        if (rightType == null) {
            DfaCondition.$$$reportNull$$$0(8);
        }
        if (relationType == RelationType.IS || relationType == RelationType.IS_NOT) {
            boolean isDistinct;
            boolean isSuperState = rightType.isSuperType(leftType);
            if (isSuperState) {
                return Exact.fromBoolean(relationType == RelationType.IS);
            }
            boolean bl = isDistinct = rightType.meet(leftType) == DfType.BOTTOM;
            if (isDistinct) {
                return Exact.fromBoolean(relationType == RelationType.IS_NOT);
            }
        } else {
            DfType meetRelation = leftType.meetRelation(relationType, rightType);
            DfType meetNegatedRelation = leftType.meetRelation(relationType.getNegated(), rightType);
            if (meetRelation == DfType.BOTTOM) {
                return meetNegatedRelation == DfType.BOTTOM ? null : Exact.FALSE;
            }
            if (meetNegatedRelation == DfType.BOTTOM) {
                return Exact.TRUE;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaCondition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaCondition";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCondition";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryEvaluate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static enum Exact implements DfaCondition
    {
        TRUE("TRUE"),
        FALSE("FALSE"),
        UNKNOWN("UNKNOWN");

        private final String myName;

        private Exact(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        @Override
        @NotNull
        public DfaCondition negate() {
            if (this == TRUE) {
                Exact exact = FALSE;
                if (exact == null) {
                    Exact.$$$reportNull$$$0(0);
                }
                return exact;
            }
            if (this == FALSE) {
                Exact exact = TRUE;
                if (exact == null) {
                    Exact.$$$reportNull$$$0(1);
                }
                return exact;
            }
            Exact exact = UNKNOWN;
            if (exact == null) {
                Exact.$$$reportNull$$$0(2);
            }
            return exact;
        }

        @Override
        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        private static Exact fromBoolean(boolean value) {
            return value ? TRUE : FALSE;
        }

        @Nullable
        private static Exact tryEvaluate(DfaValue dfaLeft, RelationType relationType, DfaValue dfaRight) {
            DfaValue sentinel = dfaLeft.getFactory().getSentinel();
            if (dfaLeft == sentinel || dfaRight == sentinel) {
                return Exact.fromBoolean((dfaLeft == sentinel && dfaRight == sentinel) == (relationType == RelationType.EQ));
            }
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaBinOpValue) {
                return Exact.fromBoolean(relationType.isSubRelation(RelationType.EQ));
            }
            DfType leftType = dfaLeft.getDfType();
            DfType rightType = dfaRight.getDfType();
            return DfaCondition.tryEvaluate(leftType, relationType, rightType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaCondition$Exact", "negate"));
        }
    }
}

