/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.file.FileLookupInfoProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class FileInfoManager {
    public static FileInfoManager getFileInfoManager() {
        return (FileInfoManager)ApplicationManager.getApplication().getService(FileInfoManager.class);
    }

    public static Object getFileLookupItem(PsiElement psiElement) {
        PsiFile psiFile;
        block3: {
            block2: {
                if (!(psiElement instanceof PsiFile)) break block2;
                psiFile = (PsiFile)psiElement;
                if (psiElement.isPhysical()) break block3;
            }
            return psiElement;
        }
        return FileInfoManager._getLookupItem(psiFile, psiFile.getName(), psiFile.getIcon(0));
    }

    @Nullable
    public static String getFileAdditionalInfo(PsiElement psiElement) {
        return FileInfoManager._getInfo(psiElement);
    }

    @Nullable
    private static String _getInfo(PsiElement psiElement) {
        VirtualFile virtualFile;
        PsiFile psiFile;
        block5: {
            block4: {
                if (!(psiElement instanceof PsiFile)) break block4;
                psiFile = (PsiFile)psiElement;
                if (psiElement.isPhysical()) break block5;
            }
            return null;
        }
        FileLookupInfoProvider provider = (FileLookupInfoProvider)ContainerUtil.find((Iterable)FileLookupInfoProvider.EP_NAME.getExtensionList(), p -> ArrayUtil.find((Object[])p.getFileTypes(), (Object)psiFile.getFileType()) != -1);
        if (provider != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            Pair info = provider.getLookupInfo(virtualFile, psiElement.getProject());
            return (String)Pair.getSecond((Pair)info);
        }
        return null;
    }

    public static LookupElementBuilder getFileLookupItem(PsiElement psiElement, String encoded, Icon icon) {
        PsiFile psiFile;
        block3: {
            block2: {
                if (!(psiElement instanceof PsiFile)) break block2;
                psiFile = (PsiFile)psiElement;
                if (psiElement.isPhysical()) break block3;
            }
            return LookupElementBuilder.create((Object)psiElement, (String)encoded).withIcon(icon);
        }
        return FileInfoManager._getLookupItem(psiFile, encoded, icon);
    }

    public static LookupElementBuilder _getLookupItem(@NotNull PsiFile file, String name, Icon icon) {
        if (file == null) {
            FileInfoManager.$$$reportNull$$$0(0);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)file, (String)name).withIcon(icon);
        String info = FileInfoManager._getInfo((PsiElement)file);
        if (info != null) {
            return builder.withTailText(String.format(" (%s)", info), true);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileInfoManager", "_getLookupItem"));
    }
}

