/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class FileTargetContext {
    @NotNull
    private final PsiFileSystemItem myContext;
    private final String @NotNull [] myPathToCreate;

    public FileTargetContext(@NotNull PsiFileSystemItem context, String @NotNull [] pathToCreate) {
        if (context == null) {
            FileTargetContext.$$$reportNull$$$0(0);
        }
        if (pathToCreate == null) {
            FileTargetContext.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myPathToCreate = pathToCreate;
    }

    public FileTargetContext(@NotNull PsiFileSystemItem context) {
        if (context == null) {
            FileTargetContext.$$$reportNull$$$0(2);
        }
        this(context, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public PsiFileSystemItem getFileSystemItem() {
        return this.myContext;
    }

    public String @NotNull [] getPathToCreate() {
        if (this.myPathToCreate == null) {
            FileTargetContext.$$$reportNull$$$0(3);
        }
        return this.myPathToCreate;
    }

    public static @Unmodifiable Collection<FileTargetContext> toTargetContexts(Collection<? extends PsiFileSystemItem> items) {
        return ContainerUtil.map(items, FileTargetContext::new);
    }

    public static Collection<FileTargetContext> toTargetContexts(PsiFileSystemItem item) {
        return Collections.singletonList(new FileTargetContext(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTargetContext context = (FileTargetContext)o;
        return this.myContext.equals((Object)context.myContext) && Arrays.equals(this.myPathToCreate, context.myPathToCreate);
    }

    public int hashCode() {
        int result = Objects.hash(this.myContext);
        result = 31 * result + Arrays.hashCode(this.myPathToCreate);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToCreate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileTargetContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileTargetContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

