/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.InjectedEditorWindowTracker;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class InjectedLanguageUtil
extends InjectedLanguageUtilBase {
    @ApiStatus.Internal
    public static final Key<Editor> FORCE_INJECTED_EDITOR_KEY = Key.create((String)"FORCE_INJECTED_EDITOR_KEY");
    @ApiStatus.Internal
    public static final Key<PsiElement> FORCE_INJECTED_COPY_ELEMENT_KEY = Key.create((String)"FORCE_INJECTED_COPY_ELEMENT_KEY");
    @Deprecated(forRemoval=true)
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = InjectedLanguageManager.FRANKENSTEIN_INJECTION;
    private static final Comparator<PsiFile> LONGEST_INJECTION_HOST_RANGE_COMPARATOR = Comparator.comparing(psiFile -> InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile), Comparator.nullsLast(Comparator.comparingInt(PsiElement::getTextLength)));

    public static void enumerate(@NotNull DocumentWindow documentWindow, @NotNull PsiFile hostPsiFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement element;
        Segment[] ranges;
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(0);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(1);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(2);
        }
        Segment rangeMarker = (ranges = documentWindow.getHostRanges()).length > 0 ? ranges[0] : null;
        PsiElement psiElement = element = rangeMarker == null ? null : hostPsiFile.findElementAt(rangeMarker.getStartOffset());
        if (element != null) {
            InjectedLanguageUtil.enumerate(element, hostPsiFile, true, visitor);
        }
    }

    @Contract(value="null,_->null;!null,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file) {
        if (editor == null || file == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file, offset);
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable Caret caret, @Nullable PsiFile file) {
        if (editor == null || file == null || editor instanceof EditorWindow || caret == null) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file, caret.getOffset());
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, caret, injectedFile);
    }

    public static Caret getCaretForInjectedLanguageNoCommit(@Nullable Caret caret, @Nullable PsiFile file) {
        if (caret == null || file == null || caret instanceof InjectedCaret) {
            return caret;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file, caret.getOffset());
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(caret.getEditor(), injectedFile);
        if (!(injectedEditor instanceof EditorWindow)) {
            return caret;
        }
        for (Caret injectedCaret : injectedEditor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)injectedCaret).getDelegate() != caret) continue;
            return injectedCaret;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiFileBase> T findInjectedFile(@NotNull PsiElement expression, @NotNull Class<T> classToFind) {
        List files;
        if (expression == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(3);
        }
        if (classToFind == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(4);
        }
        if ((files = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null) {
            return null;
        }
        for (Pair fileInfo : files) {
            PsiElement injectedFile = (PsiElement)fileInfo.first;
            if (!classToFind.isAssignableFrom(injectedFile.getClass())) continue;
            return (T)((PsiFileBase)injectedFile);
        }
        return null;
    }

    @Contract(value="null,_,_->null;!null,_,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file, int offset) {
        if (editor == null || file == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(5);
        }
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable Caret hostCaret, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(6);
        }
        if (injectedFile == null || hostEditor.isDisposed()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(7);
            }
            return editor;
        }
        Project project = hostEditor.getProject();
        if (project == null) {
            project = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance((Project)project).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(8);
            }
            return editor;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        if (hostCaret != null && hostCaret.hasSelection() && (selstart = hostCaret.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, hostCaret.getSelectionEnd()))) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(9);
            }
            return editor;
        }
        if (!documentWindow.isValid()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(10);
            }
            return editor;
        }
        Editor editor = (Editor)hostEditor.getUserData(FORCE_INJECTED_EDITOR_KEY);
        if (editor != null) {
            Editor editor2 = editor;
            if (editor2 == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(11);
            }
            return editor2;
        }
        Editor editor3 = InjectedEditorWindowTracker.getInstance().createEditor((DocumentWindow)documentWindow, hostEditor, injectedFile);
        if (editor3 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(12);
        }
        return editor3;
    }

    public static Editor openEditorFor(@NotNull PsiFile file, @NotNull Project project) {
        Editor editor;
        if (file == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(14);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)virtualFile;
            virtualFile = window.getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow || editor.isDisposed()) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            DocumentWindowImpl window = (DocumentWindowImpl)document;
            return InjectedEditorWindowTracker.getInstance().createEditor((DocumentWindow)window, editor, file);
        }
        return editor;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor) {
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(15);
        }
        Editor editor2 = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor);
        if (editor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(16);
        }
        return editor2;
    }

    public static int hostToInjectedUnescaped(DocumentWindow window, int hostOffset) {
        Place shreds = ((DocumentWindowImpl)window).getShreds();
        Segment hostRangeMarker = shreds.get(0).getHostRangeMarker();
        if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
            return shreds.get(0).getPrefix().length();
        }
        StringBuilder chars = new StringBuilder();
        int unescaped = 0;
        for (int i = 0; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = shreds.get(i);
            int prefixLength = shred.getPrefix().length();
            int suffixLength = shred.getSuffix().length();
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            LiteralTextEscaper escaper = host == null ? null : host.createLiteralTextEscaper();
            unescaped += prefixLength;
            Segment currentRange = shred.getHostRangeMarker();
            if (currentRange != null) {
                Segment nextRange;
                Segment segment = nextRange = i == shreds.size() - 1 ? null : shreds.get(i + 1).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    hostOffset = Math.min(hostOffset, currentRange.getEndOffset());
                    int inHost = hostOffset - currentRange.getStartOffset();
                    if (escaper != null && escaper.decode(rangeInsideHost, chars)) {
                        int found = ObjectUtils.binarySearch((int)0, (int)inHost, index -> Integer.compare(escaper.getOffsetInHost(index, TextRange.create((int)0, (int)host.getTextLength())), inHost));
                        return unescaped + (found >= 0 ? found : -found - 1);
                    }
                    return unescaped + inHost;
                }
                unescaped = escaper != null && escaper.decode(rangeInsideHost, chars) ? (unescaped += chars.length()) : (unescaped += currentRange.getEndOffset() - currentRange.getStartOffset());
                unescaped += suffixLength;
            }
            chars.setLength(0);
        }
        return unescaped - shreds.get(shreds.size() - 1).getSuffix().length();
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(17);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)virtualFile;
            return window.getDocumentWindow();
        }
        return null;
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
        if (places == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(18);
        }
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextRange().getStartOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, int offset) {
        if (injectionHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(19);
        }
        Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate((PsiElement)injectionHost, (injectedPsi, places) -> ref.set((Object)injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places))));
        return (PsiElement)ref.get();
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element, @NotNull Language language, @NotNull Key<T> key, @Nullable T value) {
        PsiFile file;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(20);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(21);
        }
        if (key == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(22);
        }
        if ((file = InjectedLanguageUtil.getCachedInjectedFileWithLanguage(element, language)) != null) {
            file.putUserData(key, value);
        }
    }

    @Nullable
    public static PsiFile getCachedInjectedFileWithLanguage(@NotNull PsiElement element, @NotNull Language language) {
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(23);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(24);
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)element.getContainingFile());
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        return InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getCachedInjectedDocumentsInRange(containingFile, element.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance((Project)containingFile.getProject()).getPsiFile((Document)documentWindow)).filter(file -> file != null && file.getLanguage() == LanguageSubstitutors.getInstance().substituteLanguage(language, file.getVirtualFile(), file.getProject())).max(LONGEST_INJECTION_HOST_RANGE_COMPARATOR).orElse(null);
    }

    public static void injectReference(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (registrar == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(25);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(26);
        }
        if (prefix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(27);
        }
        if (suffix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(28);
        }
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(29);
        }
        if (rangeInsideHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(30);
        }
        ((InjectionRegistrarImpl)registrar).injectReference(language, prefix, suffix, host, rangeInsideHost);
    }

    @ApiStatus.Internal
    public static BooleanRunnable reparse(@NotNull PsiFile injectedPsiFile, @NotNull DocumentWindow injectedDocument, @NotNull PsiFile hostPsiFile, @NotNull Document hostDocument, @NotNull FileViewProvider hostViewProvider, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        VirtualFile hostVirtualFile;
        InjectedFileViewProvider provider;
        VirtualFile oldInjectedVFile;
        Language language;
        BooleanRunnable runnable;
        if (injectedPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(31);
        }
        if (injectedDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(32);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(33);
        }
        if (hostDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(34);
        }
        if (hostViewProvider == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(35);
        }
        if (indicator == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(36);
        }
        if (oldRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(37);
        }
        if (newRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(38);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(39);
        }
        if ((runnable = InjectionRegistrarImpl.reparse(language = injectedPsiFile.getLanguage(), (DocumentWindowImpl)injectedDocument, injectedPsiFile, (VirtualFileWindow)(oldInjectedVFile = (provider = (InjectedFileViewProvider)injectedPsiFile.getViewProvider()).getVirtualFile()), hostVirtualFile = hostViewProvider.getVirtualFile(), hostPsiFile, (DocumentEx)hostDocument, indicator, oldRoot, newRoot, documentManager)) == null) {
            InjectedEditorWindowTracker.getInstance().disposeEditorFor(injectedDocument);
        }
        return runnable;
    }

    public static void processTokens(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places, @NotNull @NotNull BiConsumer<? super @NotNull TextRange, ? super @NotNull TextAttributesKey @NotNull []> consumer) {
        List<? extends InjectedLanguageUtilBase.TokenInfo> tokens;
        if (injectedPsi == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(40);
        }
        if (places == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(41);
        }
        if (consumer == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(42);
        }
        if ((tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi)) == null) {
            return;
        }
        int shredIndex = -1;
        int injectionHostTextRangeStart = -1;
        for (InjectedLanguageUtilBase.TokenInfo tokenInfo : tokens) {
            ProgressManager.checkCanceled();
            ProperTextRange range = tokenInfo.rangeInsideInjectionHost();
            if (range.getLength() == 0) continue;
            if (shredIndex != tokenInfo.shredIndex()) {
                shredIndex = tokenInfo.shredIndex();
                PsiLanguageInjectionHost.Shred shred = places.get(shredIndex);
                PsiLanguageInjectionHost host = shred.getHost();
                if (host == null) {
                    return;
                }
                injectionHostTextRangeStart = host.getTextRange().getStartOffset();
            }
            TextRange hostRange = range.shiftRight(injectionHostTextRangeStart);
            consumer.accept((TextRange)hostRange, (TextAttributesKey[])tokenInfo.textAttributesKeys());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 1: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToFind";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsiFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedDocument";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostViewProvider";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentWindow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedStart";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findElementInInjected";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedFileWithLanguage";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "injectReference";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processTokens";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11, 12, 16 -> new IllegalStateException(string);
        };
    }

    static final class ImplServiceImpl
    implements InjectedLanguageEditorUtil.ImplService {
        ImplServiceImpl() {
        }

        @Nullable
        public Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file) {
            return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file);
        }
    }
}

