/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.daemon.impl.WholeFileDirtyMarker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileStatus {
    static final TextRange WHOLE_FILE_TEXT_RANGE = new UnfairTextRange(-1, -1);
    private static final Logger LOG = Logger.getInstance(FileStatus.class);
    private boolean wolfPassFinished;
    private final Int2ObjectMap<RangeMarker> dirtyScopes;
    private final IntSet defensivelyMarked;
    private boolean errorFound;

    FileStatus(@NotNull Project project) {
        if (project == null) {
            FileStatus.$$$reportNull$$$0(0);
        }
        this.dirtyScopes = new Int2ObjectOpenHashMap();
        this.defensivelyMarked = new IntOpenHashSet();
        this.markWholeFileDirty(project);
    }

    int @NotNull [] getAllKnownPassIds(@NotNull Project project) {
        if (project == null) {
            FileStatus.$$$reportNull$$$0(1);
        }
        IntArrayList r = IntArrayList.of((int[])new int[]{4, 8, 7, 11, 13, 14});
        TextEditorHighlightingPassRegistrarEx registrar = (TextEditorHighlightingPassRegistrarEx)TextEditorHighlightingPassRegistrar.getInstance(project);
        for (DirtyScopeTrackingHighlightingPassFactory factory : registrar.getDirtyScopeTrackingFactories()) {
            r.add(factory.getPassId());
        }
        int[] nArray = r.toIntArray();
        if (nArray == null) {
            FileStatus.$$$reportNull$$$0(2);
        }
        return nArray;
    }

    private void markWholeFileDirty(@NotNull Project project) {
        if (project == null) {
            FileStatus.$$$reportNull$$$0(3);
        }
        for (int passId : this.getAllKnownPassIds(project)) {
            this.setDirtyScope(passId, WholeFileDirtyMarker.INSTANCE);
        }
    }

    boolean isErrorFound() {
        return this.errorFound;
    }

    void setErrorFound(boolean errorFound) {
        this.errorFound = errorFound;
    }

    boolean isDefensivelyMarked(int passId) {
        return this.defensivelyMarked.contains(passId);
    }

    void setDefensivelyMarked(boolean defensivelyMarked, int passId) {
        if (defensivelyMarked) {
            this.defensivelyMarked.add(passId);
        } else {
            this.defensivelyMarked.remove(passId);
        }
    }

    void markDefensivelyMarkedForAllPasses(@NotNull Project project) {
        if (project == null) {
            FileStatus.$$$reportNull$$$0(4);
        }
        for (int passId : this.getAllKnownPassIds(project)) {
            this.setDefensivelyMarked(true, passId);
        }
    }

    void clearDefensivelyMarkedForAllPasses() {
        this.defensivelyMarked.clear();
    }

    boolean isDefensivelyMarkedForAnyPass() {
        return !this.defensivelyMarked.isEmpty();
    }

    boolean allDirtyScopesAreNull() {
        for (RangeMarker o : this.getAllDirtyScopes()) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    void combineScopesWith(@NotNull TextRange scope, @NotNull Document document) {
        if (scope == null) {
            FileStatus.$$$reportNull$$$0(5);
        }
        if (document == null) {
            FileStatus.$$$reportNull$$$0(6);
        }
        this.dirtyScopes.replaceAll((__, oldScope) -> FileStatus.combineScopes(oldScope, scope, document));
    }

    @Nullable
    RangeMarker getDirtyScope(int passId) {
        return (RangeMarker)this.dirtyScopes.get(passId);
    }

    void setWolfPassFinished() {
        this.wolfPassFinished = true;
    }

    boolean isWolfPassFinished() {
        return this.wolfPassFinished;
    }

    @NotNull
    Iterable<RangeMarker> getAllDirtyScopes() {
        ObjectCollection objectCollection = this.dirtyScopes.values();
        if (objectCollection == null) {
            FileStatus.$$$reportNull$$$0(7);
        }
        return objectCollection;
    }

    boolean containsDirtyScope(int passId) {
        return this.dirtyScopes.containsKey(passId);
    }

    @NotNull
    private static RangeMarker combineScopes(@Nullable RangeMarker oldScope, @NotNull TextRange newScope, @NotNull Document document) {
        TextRange result;
        if (newScope == null) {
            FileStatus.$$$reportNull$$$0(8);
        }
        if (document == null) {
            FileStatus.$$$reportNull$$$0(9);
        }
        if (newScope == WHOLE_FILE_TEXT_RANGE || oldScope == WholeFileDirtyMarker.INSTANCE) {
            RangeMarker rangeMarker = WholeFileDirtyMarker.INSTANCE;
            if (rangeMarker == null) {
                FileStatus.$$$reportNull$$$0(10);
            }
            return rangeMarker;
        }
        TextRange oldRange = oldScope == null ? null : oldScope.getTextRange();
        TextRange textRange = result = oldRange == null ? newScope : newScope.union(oldRange);
        if (oldScope != null && oldScope.isValid() && result.equals((Object)oldRange)) {
            RangeMarker rangeMarker = oldScope;
            if (rangeMarker == null) {
                FileStatus.$$$reportNull$$$0(11);
            }
            return rangeMarker;
        }
        if (result.getEndOffset() > document.getTextLength()) {
            if (result.getStartOffset() == 0) {
                RangeMarker rangeMarker = WholeFileDirtyMarker.INSTANCE;
                if (rangeMarker == null) {
                    FileStatus.$$$reportNull$$$0(12);
                }
                return rangeMarker;
            }
            result = result.intersection(new TextRange(0, document.getTextLength()));
        }
        assert (result != null);
        if (oldScope != null) {
            oldScope.dispose();
        }
        RangeMarker rangeMarker = document.createRangeMarker(result);
        if (rangeMarker == null) {
            FileStatus.$$$reportNull$$$0(13);
        }
        return rangeMarker;
    }

    @NonNls
    public String toString() {
        return (String)(this.defensivelyMarked.isEmpty() ? "" : "defensivelyMarked = " + String.valueOf(this.defensivelyMarked)) + (String)(this.wolfPassFinished ? "" : "; wolfPassFinished = " + this.wolfPassFinished) + (String)(this.errorFound ? "; errorFound = " + this.errorFound : "") + (String)(this.dirtyScopes.isEmpty() ? "" : "; dirtyScopes: (" + StringUtil.join((Collection)this.dirtyScopes.int2ObjectEntrySet(), e -> " pass: " + e.getIntKey() + " -> " + String.valueOf(e.getValue() == WholeFileDirtyMarker.INSTANCE ? "Whole file" : e.getValue()), (String)";") + ")");
    }

    void setDirtyScope(int passId, @Nullable RangeMarker scope) {
        RangeMarker marker = (RangeMarker)this.dirtyScopes.get(passId);
        if (marker != scope) {
            if (marker != null) {
                marker.dispose();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("FileStatus.setDirtyScope(" + passId + ", " + String.valueOf(scope) + ")");
            }
            this.dirtyScopes.put(passId, (Object)scope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/FileStatus";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownPassIds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirtyScopes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "combineScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllKnownPassIds";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markWholeFileDirty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markDefensivelyMarkedForAllPasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "combineScopesWith";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "combineScopes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

