/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import com.intellij.codeInsight.multiverse.CodeInsightContextManagerImpl;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiConsistencyAssertions;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.indexing.DumbModeAccessType;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CompletionInitializationUtil {
    private static final Logger LOG = Logger.getInstance(CompletionInitializationUtil.class);
    private static final Key<java.lang.ref.SoftReference<Pair<PsiFile, Document>>> FILE_COPY_KEY = Key.create((String)"CompletionFileCopy");

    @NotNull
    public static CompletionInitializationContextImpl createCompletionInitializationContext(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, int invocationCount, @NotNull CompletionType completionType) {
        if (project == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(2);
        }
        if (completionType == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(3);
        }
        CompletionInitializationContextImpl completionInitializationContextImpl = (CompletionInitializationContextImpl)((Object)WriteAction.compute(() -> {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            CompletionAssertions.checkEditorValid(editor);
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            assert (psiFile != null) : "no PSI file: " + String.valueOf(FileDocumentManager.getInstance().getFile(editor.getDocument()));
            psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
            PsiConsistencyAssertions.assertNoFileTextMismatch((PsiFile)psiFile, (Document)editor.getDocument(), null);
            return CompletionInitializationUtil.runContributorsBeforeCompletion(editor, psiFile, invocationCount, caret, completionType);
        }));
        if (completionInitializationContextImpl == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(4);
        }
        return completionInitializationContextImpl;
    }

    @NotNull
    public static CompletionInitializationContextImpl runContributorsBeforeCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile, int invocationCount, @NotNull Caret caret, @NotNull CompletionType completionType) {
        if (editor == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(6);
        }
        if (caret == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(7);
        }
        if (completionType == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(8);
        }
        final Ref current = Ref.create(null);
        CompletionInitializationContextImpl context = new CompletionInitializationContextImpl(editor, caret, psiFile, completionType, invocationCount){
            CompletionContributor dummyIdentifierChanger;

            public void setDummyIdentifier(@NotNull String dummyIdentifier) {
                if (dummyIdentifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setDummyIdentifier(dummyIdentifier);
                if (this.dummyIdentifierChanger != null) {
                    LOG.error("Changing the dummy identifier twice, already changed by " + String.valueOf(this.dummyIdentifierChanger) + ". The second one is " + String.valueOf(current.get()));
                }
                this.dummyIdentifierChanger = (CompletionContributor)current.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyIdentifier", "com/intellij/codeInsight/completion/CompletionInitializationUtil$1", "setDummyIdentifier"));
            }
        };
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            Project project = psiFile.getProject();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            List contributors = CompletionContributor.forLanguageHonorDumbness((Language)context.getPositionLanguage(), (Project)project);
            for (CompletionContributor contributor : contributors) {
                current.set((Object)contributor);
                contributor.beforeCompletion((CompletionInitializationContext)context);
                CompletionAssertions.checkEditorValid(editor);
                if (!documentManager.isUncommited(editor.getDocument())) continue;
                LOG.error("Contributor " + String.valueOf(contributor) + " left the document uncommitted");
            }
        });
        CompletionInitializationContextImpl completionInitializationContextImpl = context;
        if (completionInitializationContextImpl == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(9);
        }
        return completionInitializationContextImpl;
    }

    @NotNull
    public static CompletionParameters createCompletionParameters(@NotNull CompletionInitializationContext initContext, @NotNull CompletionProcess indicator, @NotNull OffsetsInFile finalOffsets) {
        if (initContext == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(11);
        }
        if (finalOffsets == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(12);
        }
        int offset = finalOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        PsiFile fileCopy = finalOffsets.getFile();
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CompletionInitializationUtil.findCompletionPositionLeaf(finalOffsets, offset, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, (Object)new CompletionContext(fileCopy, finalOffsets.getOffsets()));
        return new CompletionParameters(insertedElement, originalFile, initContext.getCompletionType(), offset, initContext.getInvocationCount(), initContext.getEditor(), indicator);
    }

    public static Supplier<OffsetsInFile> insertDummyIdentifier(@NotNull CompletionInitializationContext initContext, @NotNull CompletionProcessEx indicator) {
        if (initContext == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(14);
        }
        OffsetsInFile topLevelOffsets = indicator.getHostOffsets();
        Consumer<Supplier> registerDisposable = supplier -> indicator.registerChildDisposable((Supplier<? extends Disposable>)supplier);
        return CompletionInitializationUtil.doInsertDummyIdentifier(initContext, topLevelOffsets, registerDisposable);
    }

    private static Supplier<OffsetsInFile> doInsertDummyIdentifier(@NotNull CompletionInitializationContext initContext, @NotNull OffsetsInFile topLevelOffsets, @NotNull Consumer<? super Supplier<Disposable>> registerDisposable) {
        if (initContext == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(15);
        }
        if (topLevelOffsets == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(16);
        }
        if (registerDisposable == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(17);
        }
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        if (initContext.getDummyIdentifier().isEmpty()) {
            return () -> topLevelOffsets;
        }
        Editor editor = initContext.getEditor();
        Editor hostEditor = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor);
        OffsetMap hostMap = topLevelOffsets.getOffsets();
        PsiFile hostCopy = CompletionInitializationUtil.obtainFileCopy(topLevelOffsets.getFile());
        Document copyDocument = Objects.requireNonNull(hostCopy.getViewProvider().getDocument());
        String dummyIdentifier = initContext.getDummyIdentifier();
        int startOffset = hostMap.getOffset(CompletionInitializationContext.START_OFFSET);
        int endOffset = hostMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        Supplier<OffsetsInFile> apply = topLevelOffsets.replaceInCopy(hostCopy, startOffset, endOffset, dummyIdentifier);
        return () -> (OffsetsInFile)WriteAction.compute(() -> CompletionInitializationUtil.lambda$doInsertDummyIdentifier$6(registerDisposable, hostEditor, initContext, copyDocument, startOffset, endOffset, dummyIdentifier, (Supplier)apply));
    }

    @NotNull
    public static OffsetsInFile toInjectedIfAny(@NotNull PsiFile originalFile, @NotNull OffsetsInFile hostCopyOffsets) {
        if (originalFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(18);
        }
        if (hostCopyOffsets == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(19);
        }
        CompletionAssertions.assertHostInfo(hostCopyOffsets.getFile(), hostCopyOffsets.getOffsets());
        int hostStartOffset = hostCopyOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        OffsetsInFile translatedOffsets = hostCopyOffsets.toInjectedIfAny(hostStartOffset);
        if (translatedOffsets != hostCopyOffsets) {
            PsiFile injected = translatedOffsets.getFile();
            if (originalFile != injected && injected instanceof PsiFileImpl) {
                PsiFileImpl psiFile = (PsiFileImpl)injected;
                if (InjectedLanguageManager.getInstance((Project)originalFile.getProject()).isInjectedFragment(originalFile)) {
                    CompletionInitializationUtil.setOriginalFile(psiFile, originalFile);
                }
            }
            VirtualFile virtualFile = injected.getVirtualFile();
            DocumentWindow documentWindow = null;
            if (virtualFile instanceof VirtualFileWindow) {
                VirtualFileWindow window = (VirtualFileWindow)virtualFile;
                documentWindow = window.getDocumentWindow();
            }
            CompletionAssertions.assertInjectedOffsets(hostStartOffset, injected, documentWindow);
            if (injected.getTextRange().contains(translatedOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET))) {
                OffsetsInFile offsetsInFile = translatedOffsets;
                if (offsetsInFile == null) {
                    CompletionInitializationUtil.$$$reportNull$$$0(20);
                }
                return offsetsInFile;
            }
        }
        OffsetsInFile offsetsInFile = hostCopyOffsets;
        if (offsetsInFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(21);
        }
        return offsetsInFile;
    }

    private static void setOriginalFile(@NotNull PsiFileImpl copy, @NotNull PsiFile origin) {
        if (copy == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(22);
        }
        if (origin == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(23);
        }
        CompletionInitializationUtil.checkInjectionConsistency((PsiFile)copy);
        PsiFile currentOrigin = copy.getOriginalFile();
        if (currentOrigin == copy) {
            copy.setOriginalFile(origin);
        } else if (currentOrigin != origin) {
            PsiUtilCore.ensureValid((PsiElement)currentOrigin);
            CompletionInitializationUtil.checkInjectionConsistency(origin);
            CompletionInitializationUtil.checkInjectionConsistency(currentOrigin);
            PsiElement host = Objects.requireNonNull(currentOrigin.getContext());
            CompletionInitializationUtil.recoverFromBrokenInjection(host.getContainingFile());
            throw new AssertionError((Object)(String.valueOf(currentOrigin) + " != " + String.valueOf(origin) + "\n" + String.valueOf(currentOrigin.getViewProvider()) + " != " + String.valueOf(origin.getViewProvider()) + "\nhost of " + String.valueOf(host.getClass())));
        }
    }

    private static void recoverFromBrokenInjection(@NotNull PsiFile hostFile) {
        if (hostFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{hostFile.getViewProvider().getVirtualFile()}));
    }

    private static void checkInjectionConsistency(@NotNull PsiFile injectedFile) {
        PsiElement host;
        if (injectedFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(25);
        }
        if ((host = injectedFile.getContext()) instanceof PsiLanguageInjectionHost) {
            PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)host;
            DocumentWindow document = (DocumentWindow)injectedFile.getViewProvider().getDocument();
            assert (document != null);
            TextRange hostRange = host.getTextRange();
            LiteralTextEscaper escaper = injectionHost.createLiteralTextEscaper();
            TextRange relevantRange = escaper.getRelevantTextRange().shiftRight(hostRange.getStartOffset());
            for (Segment range : document.getHostRanges()) {
                if (!hostRange.contains(range) || relevantRange.contains(range)) continue;
                String message = "Injection host of " + String.valueOf(host.getClass()) + " with range " + String.valueOf(hostRange) + " contains injection at " + String.valueOf(range) + ", which contradicts literalTextEscaper that only allows injection at " + String.valueOf(relevantRange);
                PsiFile hostFile = Objects.requireNonNull(host).getContainingFile();
                CompletionInitializationUtil.recoverFromBrokenInjection(hostFile);
                Attachment fileText = new Attachment(hostFile.getViewProvider().getVirtualFile().getPath(), hostFile.getText());
                throw PluginException.createByClass((Throwable)new RuntimeExceptionWithAttachments(message, new Attachment[]{fileText}), (Class)host.getClass());
            }
        }
    }

    @NotNull
    public static PsiElement findCompletionPositionLeaf(@NotNull OffsetsInFile offsets, int offset, @NotNull PsiFile originalFile) {
        PsiElement insertedElement;
        if (offsets == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(26);
        }
        if (originalFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(27);
        }
        if ((insertedElement = offsets.getFile().findElementAt(offset)) == null && offsets.getFile().getTextLength() == offset) {
            insertedElement = PsiTreeUtil.getDeepestLast((PsiElement)offsets.getFile());
        }
        CompletionAssertions.assertCompletionPositionPsiConsistent(offsets, offset, originalFile, insertedElement);
        PsiElement psiElement = insertedElement;
        if (psiElement == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    @NotNull
    private static PsiFile obtainFileCopy(@NotNull PsiFile file) {
        Pair cached;
        boolean mayCacheCopy;
        if (file == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(29);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        boolean bl = mayCacheCopy = file.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem();
        if (mayCacheCopy && (cached = (Pair)SoftReference.dereference((Reference)((Reference)file.getUserData(FILE_COPY_KEY)))) != null && CompletionInitializationUtil.isCopyUpToDate((Document)cached.second, (PsiFile)cached.first, file)) {
            PsiFile copy = (PsiFile)cached.first;
            CompletionAssertions.assertCorrectOriginalFile("Cached", file, copy);
            PsiFile psiFile = copy;
            if (psiFile == null) {
                CompletionInitializationUtil.$$$reportNull$$$0(30);
            }
            return psiFile;
        }
        PsiFile copy = (PsiFile)file.copy();
        if (copy.isPhysical() || copy.getViewProvider().isEventSystemEnabled()) {
            LOG.error("File copy should be non-physical and non-event-system-enabled! Language=" + String.valueOf(file.getLanguage()) + "; file=" + String.valueOf(file) + " of " + String.valueOf(file.getClass()));
        }
        CompletionAssertions.assertCorrectOriginalFile("New", file, copy);
        if (CodeInsightContexts.isSharedSourceSupportEnabled((Project)file.getProject())) {
            CodeInsightContextManagerImpl codeInsightContextManager = (CodeInsightContextManagerImpl)CodeInsightContextManager.getInstance((Project)file.getProject());
            CodeInsightContext context = codeInsightContextManager.getCodeInsightContext(file.getViewProvider());
            codeInsightContextManager.setCodeInsightContext(copy.getViewProvider(), context);
        }
        if (mayCacheCopy) {
            Document document = copy.getViewProvider().getDocument();
            assert (document != null);
            CompletionInitializationUtil.syncAcceptSlashR(file.getViewProvider().getDocument(), document);
            file.putUserData(FILE_COPY_KEY, new java.lang.ref.SoftReference<Pair>(Pair.create((Object)copy, (Object)document)));
        }
        PsiFile psiFile = copy;
        if (psiFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(31);
        }
        return psiFile;
    }

    private static boolean isCopyUpToDate(@NotNull Document document, @NotNull PsiFile copyFile, @NotNull PsiFile originalFile) {
        if (document == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(32);
        }
        if (copyFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(33);
        }
        if (originalFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(34);
        }
        if (!(copyFile.getClass().equals(originalFile.getClass()) && copyFile.isValid() && copyFile.getName().equals(originalFile.getName()))) {
            return false;
        }
        PsiFile current = PsiDocumentManager.getInstance((Project)copyFile.getProject()).getPsiFile(document);
        return current != null && current.getViewProvider().getPsi(copyFile.getLanguage()) == copyFile;
    }

    private static void syncAcceptSlashR(Document originalDocument, Document documentCopy) {
        DocumentImpl origDocument;
        block3: {
            block2: {
                if (!(originalDocument instanceof DocumentImpl)) break block2;
                origDocument = (DocumentImpl)originalDocument;
                if (documentCopy instanceof DocumentImpl) break block3;
            }
            return;
        }
        DocumentImpl copyDocument = (DocumentImpl)documentCopy;
        copyDocument.setAcceptSlashR(origDocument.acceptsSlashR());
    }

    private static /* synthetic */ OffsetsInFile lambda$doInsertDummyIdentifier$6(Consumer registerDisposable, Editor hostEditor, CompletionInitializationContext initContext, Document copyDocument, int startOffset, int endOffset, String dummyIdentifier, Supplier apply) throws RuntimeException {
        registerDisposable.accept(() -> new OffsetTranslator(hostEditor.getDocument(), initContext.getFile(), copyDocument, startOffset, endOffset, dummyIdentifier));
        OffsetsInFile copyOffsets = (OffsetsInFile)apply.get();
        registerDisposable.accept(() -> copyOffsets.getOffsets());
        return copyOffsets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 20, 21, 28, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 4: 
            case 9: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionInitializationUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initContext";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalOffsets";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelOffsets";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerDisposable";
                break;
            }
            case 18: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostCopyOffsets";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsets";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionInitializationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionInitializationContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runContributorsBeforeCompletion";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toInjectedIfAny";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompletionPositionLeaf";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFileCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionInitializationContext";
                break;
            }
            case 4: 
            case 9: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runContributorsBeforeCompletion";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertDummyIdentifier";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doInsertDummyIdentifier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toInjectedIfAny";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "recoverFromBrokenInjection";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionConsistency";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findCompletionPositionLeaf";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "obtainFileCopy";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCopyUpToDate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 20, 21, 28, 30, 31 -> new IllegalStateException(string);
        };
    }
}

