/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InjectedGeneralHighlightingPass;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.codeInsight.util.HighlightVisitorScopeKt;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import io.opentelemetry.api.trace.SpanBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class HighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    public static final String SHORT_NAME = "Annotator";
    public boolean highlightErrorElements = true;
    public boolean runAnnotators = true;
    public boolean runVisitors = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"highlightErrorElements", (String)InspectionsBundle.message((String)"inspection.annotator.option.highlight.syntax", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"runAnnotators", (String)InspectionsBundle.message((String)"inspection.annotator.option.run.annotators", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"runVisitors", (String)InspectionsBundle.message((String)"inspection.annotator.option.run.highlight.visitors", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public HighlightVisitorBasedInspection setHighlightErrorElements(boolean value) {
        this.highlightErrorElements = value;
        HighlightVisitorBasedInspection highlightVisitorBasedInspection = this;
        if (highlightVisitorBasedInspection == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(1);
        }
        return highlightVisitorBasedInspection;
    }

    @NotNull
    public HighlightVisitorBasedInspection setRunAnnotators(boolean value) {
        this.runAnnotators = value;
        HighlightVisitorBasedInspection highlightVisitorBasedInspection = this;
        if (highlightVisitorBasedInspection == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(2);
        }
        return highlightVisitorBasedInspection;
    }

    @NotNull
    public HighlightVisitorBasedInspection setRunVisitors(boolean value) {
        this.runVisitors = value;
        HighlightVisitorBasedInspection highlightVisitorBasedInspection = this;
        if (highlightVisitorBasedInspection == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(3);
        }
        return highlightVisitorBasedInspection;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    public void checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (psiFile == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(6);
        }
        if (problemsHolder == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(8);
        }
        if (problemDescriptionsProcessor == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(9);
        }
        for (HighlightInfo info : HighlightVisitorBasedInspection.runAnnotatorsInGeneralHighlighting(psiFile, this.highlightErrorElements, this.runAnnotators, this.runVisitors)) {
            PsiElement element;
            TextRange range = new TextRange(info.startOffset, info.endOffset);
            for (element = psiFile.findElementAt(info.startOffset); element != null && !element.getTextRange().contains(range); element = element.getParent()) {
            }
            if (element == null) {
                element = psiFile;
            }
            GlobalInspectionUtil.createProblem(element, info, range.shiftRight(-element.getNode().getStartOffset()), info.getProblemGroup(), manager, problemDescriptionsProcessor, globalContext);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = HighlightVisitorBasedInspection.getGeneralGroupName();
        if (string == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static List<HighlightInfo> runAnnotatorsInGeneralHighlighting(@NotNull PsiFile psiFile, boolean highlightErrorElements, boolean runAnnotators, boolean runVisitors) {
        if (psiFile == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(11);
        }
        int startOffset = 0;
        int endOffset = psiFile.getTextLength();
        ProperTextRange visibleRange = ProperTextRange.create((Segment)psiFile.getTextRange());
        return HighlightVisitorBasedInspection.runAnnotatorsInGeneralHighlighting(psiFile, startOffset, endOffset, visibleRange, highlightErrorElements, runAnnotators, runVisitors);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public static List<HighlightInfo> runAnnotatorsInGeneralHighlighting(@NotNull PsiFile psiFile, int startOffset, int endOffset, @NotNull ProperTextRange visibleRange, boolean highlightErrorElements, boolean runAnnotators, boolean runVisitors) {
        if (psiFile == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(12);
        }
        if (visibleRange == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            List<HighlightInfo> list = Collections.emptyList();
            if (list == null) {
                HighlightVisitorBasedInspection.$$$reportNull$$$0(14);
            }
            return list;
        }
        DaemonProgressIndicator daemonProgressIndicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        CodeInsightContext context = CodeInsightContextUtil.getCodeInsightContext((PsiFile)psiFile);
        HighlightingSessionImpl.getOrCreateHighlightingSession(psiFile, context, daemonProgressIndicator, visibleRange);
        GeneralHighlightingPass ghp = new GeneralHighlightingPass(psiFile, document, startOffset, endOffset, true, visibleRange, null, runAnnotators, runVisitors, highlightErrorElements, HighlightInfoUpdater.EMPTY);
        InjectedGeneralHighlightingPass ighp = new InjectedGeneralHighlightingPass(psiFile, document, null, startOffset, endOffset, true, visibleRange, null, runAnnotators, runVisitors, highlightErrorElements, HighlightInfoUpdater.EMPTY);
        ighp.setContext(context);
        String fileName = psiFile.getName();
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        IJTracer tracer = TelemetryManager.Companion.getTracer(HighlightVisitorScopeKt.HighlightVisitorScope);
        for (TextEditorHighlightingPass textEditorHighlightingPass : List.of(ghp, ighp)) {
            TraceKt.use((SpanBuilder)tracer.spanBuilder(textEditorHighlightingPass.getClass().getSimpleName()).setAttribute("file", fileName), __ -> {
                pass.doCollectInformation((ProgressIndicator)daemonProgressIndicator);
                List<HighlightInfo> infos = pass.getInfos();
                for (HighlightInfo info : infos) {
                    if (info == null || info.getSeverity().compareTo(HighlightSeverity.INFORMATION) <= 0) continue;
                    result.add(info);
                }
                return null;
            });
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            HighlightVisitorBasedInspection.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 8, 9, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorBasedInspection";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setHighlightErrorElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setRunAnnotators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setRunVisitors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightVisitorBasedInspection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "runAnnotatorsInGeneralHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorsInGeneralHighlighting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 8, 9, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

