/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ExportedInspectionsResultModifier;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorUserDataKt;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolResultExporter
implements InspectionToolResultExporter {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolResultExporter.class);
    @NonNls
    public static final String INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT = "problem_class";
    @NonNls
    public static final String INSPECTION_RESULTS_SEVERITY_ATTRIBUTE = "severity";
    @NonNls
    public static final String INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE = "attribute_key";
    @NonNls
    public static final String INSPECTION_RESULTS_ID_ATTRIBUTE = "id";
    @NonNls
    public static final String INSPECTION_RESULTS_DESCRIPTION_ELEMENT = "description";
    @NonNls
    public static final String INSPECTION_RESULTS_FINGERPRINT_DATA = "fingerprint";
    @NonNls
    protected static final String INSPECTION_RESULTS_HINTS_ELEMENT = "hints";
    @NonNls
    protected static final String INSPECTION_RESULTS_HINT_ELEMENT = "hint";
    @NonNls
    protected static final String INSPECTION_RESULTS_VALUE_ATTRIBUTE = "value";
    @NonNls
    public static final String INSPECTION_RESULTS_LANGUAGE = "language";
    @NotNull
    protected final InspectionToolWrapper<?, ?> myToolWrapper;
    @NotNull
    protected final GlobalInspectionContextEx myContext;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements;
    private Map<String, Set<RefEntity>> myContents;
    private static final Object WRITER_LOCK = new Object();

    public DefaultInspectionToolResultExporter(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull GlobalInspectionContextEx context) {
        if (toolWrapper == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(1);
        }
        this.myExcludedElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.myProblemElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.mySuppressedElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.myResolvedElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    @Override
    @NotNull
    public InspectionToolWrapper<?, ?> getToolWrapper() {
        InspectionToolWrapper<?, ?> inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(2);
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.getContext().getRefManager();
        if (refManager == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(3);
        }
        return refManager;
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> synchronizedBidiMultiMap = this.myProblemElements;
        if (synchronizedBidiMultiMap == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(4);
        }
        return synchronizedBidiMultiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutput(CommonProblemDescriptor @NotNull [] descriptions, @NotNull RefEntity refElement) throws IOException {
        InspectionEP inspectionEP;
        if (refElement == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(5);
        }
        if (descriptions == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(6);
        }
        Object object = (inspectionEP = this.myToolWrapper.getExtension()) != null ? inspectionEP : WRITER_LOCK;
        synchronized (object) {
            Path file = InspectionsResultUtil.getInspectionResultPath(this.myContext.getOutputPath(), this.myToolWrapper.getShortName());
            boolean exists = Files.exists(file, new LinkOption[0]);
            if (!exists && !Files.isDirectory(file.getParent(), new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                if (!exists) {
                    ((Writer)writer).write(60);
                    writer.write("problems");
                    ((Writer)writer).write(32);
                    writer.write("is_local_tool");
                    ((Writer)writer).write(61);
                    ((Writer)writer).write(34);
                    writer.write(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper));
                    ((Writer)writer).write(34);
                    ((Writer)writer).write(62);
                    ((Writer)writer).write(10);
                }
                this.exportResults(descriptions, refElement, (? super Element element) -> {
                    try {
                        JbXmlOutputter.Companion.collapseMacrosAndWrite(element, (ComponentManager)this.getContext().getProject(), writer);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }, (? super CommonProblemDescriptor __) -> false);
                ((Writer)writer).write(10);
            }
        }
    }

    @Override
    public void exportResults(final @NotNull Consumer<? super Element> resultConsumer, final @NotNull Predicate<? super RefEntity> excludedEntities, final @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptors) {
        if (resultConsumer == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(7);
        }
        if (excludedEntities == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(8);
        }
        if (excludedDescriptors == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(9);
        }
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (elem == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolResultExporter.this.exportResults((Consumer<? super Element>)resultConsumer, elem, (Predicate<? super CommonProblemDescriptor>)excludedDescriptors);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/DefaultInspectionToolResultExporter$1", "visitElement"));
            }
        });
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myContext.getProject();
        if (project == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Override
    public void exportResults(@NotNull Consumer<? super Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        CommonProblemDescriptor[] descriptions;
        if (resultConsumer == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(11);
        }
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(12);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(13);
        }
        if ((descriptions = this.getProblemElements().get(refEntity)) != null) {
            this.exportResults(descriptions, refEntity, resultConsumer, isDescriptorExcluded);
        }
    }

    protected void exportResults(CommonProblemDescriptor @NotNull [] descriptors, @NotNull RefEntity refEntity, @NotNull BiConsumer<? super Element, ? super CommonProblemDescriptor> problemSink, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(14);
        }
        if (problemSink == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(15);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(16);
        }
        if (descriptors == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(17);
        }
        List<ProblemDescriptorKey> keys = Arrays.stream(descriptors).filter(desc -> !isDescriptorExcluded.test((CommonProblemDescriptor)desc)).map(desc -> new ProblemDescriptorKey((CommonProblemDescriptor)desc)).sorted().toList();
        for (ProblemDescriptorKey key : keys) {
            CommonProblemDescriptor descriptor = key.descriptor;
            Element element = null;
            try {
                element = refEntity.getRefManager().export(refEntity, key.lineNumber);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (element == null) {
                return;
            }
            this.exportResult(refEntity, descriptor, element);
            problemSink.accept((Element)element, (CommonProblemDescriptor)descriptor);
        }
    }

    protected void exportResults(CommonProblemDescriptor @NotNull [] descriptors, @NotNull RefEntity refEntity, @NotNull Consumer<? super Element> problemSink, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(18);
        }
        if (problemSink == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(19);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(20);
        }
        if (descriptors == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(21);
        }
        this.exportResults(descriptors, refEntity, (? super Element element, ? super CommonProblemDescriptor problem) -> problemSink.accept((Element)element), isDescriptorExcluded);
    }

    private void exportResult(@NotNull RefEntity refEntity, @NotNull CommonProblemDescriptor descriptor, @NotNull Element element) {
        PsiElement psiElement;
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(22);
        }
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(23);
        }
        if (element == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(24);
        }
        if (descriptor instanceof ProblemDescriptor) {
            ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
            psiElement = problemDescriptor.getPsiElement();
        } else {
            psiElement = null;
        }
        PsiElement psiElement2 = psiElement;
        try {
            UserDataHolder dataHolder;
            Map fingerprintData;
            ProblemDescriptorBase base;
            TextRange textRange;
            HighlightInfoType highlightInfoType;
            @NonNls Element problemClassElement = new Element(INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT);
            problemClassElement.setAttribute(INSPECTION_RESULTS_ID_ATTRIBUTE, this.myToolWrapper.getShortName());
            problemClassElement.addContent(ProblemDescriptorUtil.sanitizeIllegalXmlChars(this.myToolWrapper.getDisplayName()));
            HighlightSeverity severity = InspectionToolResultExporter.getSeverity(refEntity, psiElement2, this);
            SeverityRegistrar severityRegistrar = this.myContext.getCurrentProfile().getProfileManager().getSeverityRegistrar();
            if (descriptor instanceof ProblemDescriptor) {
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
                highlightInfoType = ProblemDescriptorUtil.highlightTypeFromDescriptor(problemDescriptor, severity, severityRegistrar);
            } else {
                highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, severity, severityRegistrar);
            }
            HighlightInfoType type = highlightInfoType;
            problemClassElement.setAttribute(INSPECTION_RESULTS_SEVERITY_ATTRIBUTE, type.getSeverity(psiElement2).getName());
            problemClassElement.setAttribute(INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE, type.getAttributesKey().getExternalName());
            element.addContent(problemClassElement);
            InspectionToolWrapper<?, ?> inspectionToolWrapper = this.myToolWrapper;
            if (inspectionToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionToolWrapper globalInspectionToolWrapper = (GlobalInspectionToolWrapper)inspectionToolWrapper;
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)globalInspectionToolWrapper.getTool();
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes != null) {
                    @NonNls Element hintsElement = new Element(INSPECTION_RESULTS_HINTS_ELEMENT);
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        @NonNls Element hintElement = new Element(INSPECTION_RESULTS_HINT_ELEMENT);
                        hintElement.setAttribute(INSPECTION_RESULTS_VALUE_ATTRIBUTE, ProblemDescriptorUtil.sanitizeIllegalXmlChars(hint));
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                }
            }
            @NonNls String template = descriptor.getDescriptionTemplate();
            String highlightedText = ProblemDescriptorUtil.extractHighlightedText(descriptor, psiElement2);
            @NonNls String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement2 != null ? highlightedText : "")), (String)" #loc ", (String)" ");
            Element descriptionElement = new Element(INSPECTION_RESULTS_DESCRIPTION_ELEMENT);
            descriptionElement.addContent(ProblemDescriptorUtil.sanitizeIllegalXmlChars(problemText));
            element.addContent(descriptionElement);
            Element highLightedElement = new Element("highlighted_element");
            highLightedElement.addContent(ProblemDescriptorUtil.sanitizeIllegalXmlChars(highlightedText));
            element.addContent(highLightedElement);
            Element language = new Element(INSPECTION_RESULTS_LANGUAGE);
            language.addContent(psiElement2 != null ? psiElement2.getLanguage().getID() : "");
            element.addContent(language);
            if (descriptor instanceof ProblemDescriptorBase && (textRange = (base = (ProblemDescriptorBase)descriptor).getTextRangeForNavigation()) != null) {
                int offset = textRange.getStartOffset() - base.getLineStartOffset();
                int length = textRange.getLength();
                element.addContent(new Element("offset").addContent(String.valueOf(offset)));
                element.addContent(new Element("length").addContent(String.valueOf(length)));
            }
            if (descriptor instanceof UserDataHolder && (fingerprintData = (Map)(dataHolder = (UserDataHolder)descriptor).getUserData(ProblemDescriptorUserDataKt.FINGERPRINT_DATA)) != null) {
                Element fingerprintElement = new Element(INSPECTION_RESULTS_FINGERPRINT_DATA);
                for (Map.Entry e : fingerprintData.entrySet()) {
                    fingerprintElement.setAttribute((String)e.getKey(), (String)e.getValue());
                }
                element.addContent(fingerprintElement);
            }
            if (descriptor instanceof ExportedInspectionsResultModifier) {
                ExportedInspectionsResultModifier modifier = (ExportedInspectionsResultModifier)descriptor;
                modifier.modifyResult(element);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String message = "Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName() + ", problem descriptor " + String.valueOf(descriptor);
            if (psiElement2 != null) {
                message = message + ", element class: " + String.valueOf(psiElement2.getClass()) + ", containing file: " + String.valueOf(psiElement2.getContainingFile());
            }
            LOG.error(message, (Throwable)e);
        }
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    @NotNull
    public GlobalInspectionContextEx getContext() {
        GlobalInspectionContextEx globalInspectionContextEx = this.myContext;
        if (globalInspectionContextEx == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(25);
        }
        return globalInspectionContextEx;
    }

    @NotNull
    private static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            @Override
            @NotNull
            protected ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                ArrayFactory arrayFactory = CommonProblemDescriptor.ARRAY_FACTORY;
                if (arrayFactory == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayFactory;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DefaultInspectionToolResultExporter$2", "arrayFactory"));
            }
        };
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element) {
        if (element == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(26);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (HighlightSeverity)WriteIntentReadAction.compute(() -> this.doGetSeverity(element));
        }
        return (HighlightSeverity)ReadAction.nonBlocking(() -> this.doGetSeverity(element)).executeSynchronously();
    }

    @Nullable
    private HighlightSeverity doGetSeverity(@NotNull RefElement element) {
        PsiFile psiElement;
        if (element == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(27);
        }
        if ((psiElement = ((RefElement)element.getRefManager().getRefinedElement((RefEntity)element)).getPointer().getContainingFile()) != null) {
            GlobalInspectionContextEx context = this.getContext();
            String shortName = this.getSeverityDelegateName();
            Tools tools = context.getTools().get(shortName);
            if (tools != null) {
                for (ScopeToolState state : tools.getTools()) {
                    InspectionToolWrapper toolWrapper = state.getTool();
                    if (toolWrapper != this.getToolWrapper()) continue;
                    return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                }
            }
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
            HighlightDisplayLevel level = profile.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
            return level.getSeverity();
        }
        return null;
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(28);
        }
        return this.myExcludedElements.containsValue(descriptor);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(29);
        }
        Object[] excluded = this.myExcludedElements.get(entity);
        Object[] problems = this.myProblemElements.get(entity);
        return excluded != null && problems != null && Comparing.equal((Object)ContainerUtil.newHashSet((Object[])excluded), (Object)ContainerUtil.newHashSet((Object[])problems));
    }

    @Override
    public void amnesty(@NotNull RefEntity element) {
        if (element == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(30);
        }
        this.myExcludedElements.remove(element);
    }

    @Override
    public void exclude(@NotNull RefEntity element) {
        if (element == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(31);
        }
        this.myExcludedElements.put(element, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(32);
        }
        this.myExcludedElements.removeValue(descriptor);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor) {
        RefEntity entity;
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(33);
        }
        if ((entity = (RefEntity)ObjectUtils.chooseNotNull((Object)this.myProblemElements.getKeyFor(descriptor), (Object)this.myResolvedElements.getKeyFor(descriptor))) != null) {
            this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
        }
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor) {
        RefEntity removed;
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(34);
        }
        if ((removed = this.myProblemElements.removeValue(descriptor)) != null) {
            this.mySuppressedElements.put(removed, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
        }
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed;
        if (entity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(35);
        }
        if ((removed = this.myProblemElements.remove(entity)) != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public synchronized void updateContent() {
        this.clearContents();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Set<Object> elements;
        if (this.filterResolvedItems()) {
            elements = this.getProblemElements().keys().stream().filter(entity -> !this.isExcluded((RefEntity)entity)).collect(Collectors.toSet());
        } else {
            elements = new HashSet<RefEntity>(this.getProblemElements().keys());
            elements.addAll(this.getResolvedElements());
            elements.addAll(this.mySuppressedElements.keys());
        }
        for (RefEntity refEntity : elements) {
            String string;
            if (refEntity instanceof RefElement) {
                RefElement refElement = (RefElement)refEntity;
                string = refEntity.getRefManager().getGroupName(refElement);
            } else {
                string = refEntity.getQualifiedName();
            }
            String groupName = string;
            this.registerContentEntry(refEntity, groupName);
        }
    }

    protected boolean filterResolvedItems() {
        return false;
    }

    protected synchronized void clearContents() {
        if (this.myContents == null) {
            this.myContents = new HashMap<String, Set<RefEntity>>(1);
        } else {
            this.myContents.clear();
        }
    }

    protected synchronized void registerContentEntry(RefEntity element, String packageName) {
        GlobalReportedProblemFilter globalReportedProblemFilter = this.myContext.getGlobalReportedProblemFilter();
        if (globalReportedProblemFilter == null || globalReportedProblemFilter.shouldReportProblem(element, this.getToolWrapper().getShortName())) {
            if (this.myContents == null) {
                this.myContents = new HashMap<String, Set<RefEntity>>(1);
            }
            Set content = this.myContents.computeIfAbsent(packageName, k -> new HashSet());
            content.add(element);
        }
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        if (descriptions == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(36);
        }
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        if (descriptors == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(37);
        }
        if (refElement == null || descriptors.length == 0) {
            return;
        }
        ReportedProblemFilter filter = this.myContext.getReportedProblemFilter();
        if (filter != null && !filter.shouldReportProblem(refElement, descriptors)) {
            return;
        }
        DefaultInspectionToolResultExporter.checkFromSameFile(refElement, descriptors);
        if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper) || this instanceof AggregateResultsExporter) {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors);
        } else {
            this.addLocalInspectionProblem(refElement, descriptors);
        }
    }

    private void addLocalInspectionProblem(@NotNull RefEntity refElement, CommonProblemDescriptor @NotNull [] descriptors) {
        if (refElement == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(38);
        }
        if (descriptors == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(39);
        }
        try {
            this.writeOutput(descriptors, refElement);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void checkFromSameFile(RefEntity element, CommonProblemDescriptor[] descriptors) {
        if (!(element instanceof RefElement)) {
            return;
        }
        RefElement refElement = (RefElement)element;
        SmartPsiElementPointer pointer = refElement.getPointer();
        if (pointer == null) {
            return;
        }
        VirtualFile entityFile = DefaultInspectionToolResultExporter.ensureNotInjectedFile(pointer.getVirtualFile());
        if (entityFile == null) {
            return;
        }
        for (CommonProblemDescriptor d : descriptors) {
            ProblemDescriptorBase base;
            VirtualFile file;
            if (!(d instanceof ProblemDescriptorBase) || (file = (base = (ProblemDescriptorBase)d).getContainingFile()) == null) continue;
            LOG.assertTrue(DefaultInspectionToolResultExporter.ensureNotInjectedFile(file).equals(entityFile), (Object)("descriptor and containing entity files should be the same; descriptor: " + d.getDescriptionTemplate() + ", entityFile: " + entityFile.getName()));
        }
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(40);
        }
        return this.myProblemElements.getKeyFor(descriptor);
    }

    @Contract(value="null -> null")
    private static VirtualFile ensureNotInjectedFile(VirtualFile file) {
        VirtualFile virtualFile;
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)file;
            virtualFile = window.getDelegate();
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        Collection<CommonProblemDescriptor> collection = this.myProblemElements.getValues();
        if (collection == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(41);
        }
        return collection;
    }

    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor) {
        RefEntity entity;
        if (descriptor == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(42);
        }
        if ((entity = this.myProblemElements.removeValue(descriptor)) != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor) {
        return this.myResolvedElements.containsValue(descriptor);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity) && !this.myProblemElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        Collection<RefEntity> collection = this.myResolvedElements.keys();
        if (collection == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(43);
        }
        return collection;
    }

    @Override
    public CommonProblemDescriptor @NotNull [] getResolvedProblems(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(44);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.myResolvedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
        if (commonProblemDescriptorArray == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(45);
        }
        return commonProblemDescriptorArray;
    }

    @Override
    @NotNull
    public synchronized ThreeState hasReportedProblems() {
        if (this.myContents == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DefaultInspectionToolResultExporter.$$$reportNull$$$0(46);
            }
            return threeState;
        }
        ThreeState threeState = this.myContents.isEmpty() ? ThreeState.NO : ThreeState.YES;
        if (threeState == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(47);
        }
        return threeState;
    }

    @Override
    @NotNull
    public synchronized Map<String, Set<RefEntity>> getContent() {
        Map<String, Set<RefEntity>> map = Collections.synchronizedMap(this.myContents == null ? new HashMap(1) : this.myContents);
        if (map == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(48);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 10, 25, 41, 43, 45, 46, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 25: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/DefaultInspectionToolResultExporter";
                break;
            }
            case 5: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 6: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedEntities";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptors";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isDescriptorExcluded";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 17: 
            case 21: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 23: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/DefaultInspectionToolResultExporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptors";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElements";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedProblems";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "hasReportedProblems";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 25: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeOutput";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "exportResult";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doGetSeverity";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "suppressProblem";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addProblemElement";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addLocalInspectionProblem";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveProblem";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedProblems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 10, 25, 41, 43, 45, 46, 47, 48 -> new IllegalStateException(string);
        };
    }

    private static class ProblemDescriptorKey
    implements Comparable<ProblemDescriptorKey> {
        final CommonProblemDescriptor descriptor;
        VirtualFile file;
        int lineNumber = -1;
        int position;
        String descriptionTemplate;

        private ProblemDescriptorKey(CommonProblemDescriptor desc) {
            this.descriptor = desc;
            if (desc instanceof ProblemDescriptor) {
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)desc;
                this.lineNumber = problemDescriptor.getLineNumber();
            }
            if (desc instanceof ProblemDescriptorBase) {
                ProblemDescriptorBase descriptorBase = (ProblemDescriptorBase)desc;
                this.file = descriptorBase.getContainingFile();
                TextRange textRange = descriptorBase.getTextRange();
                this.position = textRange != null ? textRange.getStartOffset() : 0;
                this.descriptionTemplate = desc.getDescriptionTemplate();
            }
        }

        @Override
        public int compareTo(@NotNull ProblemDescriptorKey o) {
            if (o == null) {
                ProblemDescriptorKey.$$$reportNull$$$0(0);
            }
            if (this.file == null || o.file == null) {
                return Boolean.compare(this.file == null, o.file == null);
            }
            int comparison = this.file.getPath().compareTo(o.file.getPath());
            if (comparison == 0) {
                comparison = Integer.compare(this.lineNumber, o.lineNumber);
            }
            if (comparison == 0) {
                comparison = Integer.compare(this.position, o.position);
            }
            if (comparison == 0) {
                comparison = this.descriptionTemplate.compareTo(o.descriptionTemplate);
            }
            return comparison;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/codeInspection/DefaultInspectionToolResultExporter$ProblemDescriptorKey", "compareTo"));
        }
    }
}

