/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptorImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorBase
extends CommonProblemDescriptorImpl
implements ProblemDescriptor {
    private static final Logger LOG = Logger.getInstance(ProblemDescriptorBase.class);
    @NotNull
    private final SmartPsiElementPointer<?> myStartSmartPointer;
    @Nullable
    private final SmartPsiElementPointer<?> myEndSmartPointer;
    private final ProblemHighlightType myHighlightType;
    private final boolean myOnTheFly;
    private Navigatable myNavigatable;
    private final boolean myAfterEndOfLine;
    private final TextRange myTextRangeInElement;
    private final boolean myShowTooltip;
    private TextAttributesKey myEnforcedTextAttributes;
    private int myLineNumber;
    private ProblemGroup myProblemGroup;
    @NlsSafe
    @Nullable
    private String tooltip;

    public ProblemDescriptorBase(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull LocalQuickFix @Nullable [] fixes, @NotNull ProblemHighlightType highlightType, boolean isAfterEndOfLine, @Nullable TextRange rangeInElement, boolean showTooltip, boolean onTheFly) {
        if (startElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(1);
        }
        if (descriptionTemplate == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(2);
        }
        if (highlightType == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(3);
        }
        super(descriptionTemplate, (QuickFix<?>[])ProblemDescriptorBase.filterFixes(fixes, onTheFly));
        this.myLineNumber = -1;
        this.myShowTooltip = showTooltip;
        PsiFile startContainingFile = startElement.getContainingFile();
        LOG.assertTrue(startContainingFile != null && startContainingFile.isValid() || startElement.isValid(), (Object)startElement);
        PsiFile endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        LOG.assertTrue(startElement == endElement || endContainingFile != null && endContainingFile.isValid() || endElement.isValid(), (Object)endElement);
        this.assertPhysical(startElement);
        if (startElement != endElement) {
            this.assertPhysical(endElement);
        }
        TextRange startElementRange = ProblemDescriptorBase.getAnnotationRange(startElement);
        LOG.assertTrue(startElement instanceof ExternallyAnnotated || startElement instanceof PsiBinaryFile || startElementRange != null, (Object)startElement);
        TextRange endElementRange = startElement == endElement ? startElementRange : ProblemDescriptorBase.getAnnotationRange(endElement);
        LOG.assertTrue(endElement instanceof ExternallyAnnotated || endElement instanceof PsiBinaryFile || endElementRange != null, (Object)endElement);
        if (!(startElementRange == null || endElementRange == null || startElementRange.getStartOffset() < endElementRange.getEndOffset() || startElement instanceof PsiFile && endElement instanceof PsiFile)) {
            LOG.error("Empty PSI elements must not be passed to createDescriptor. Start: " + String.valueOf(startElement) + ", end: " + String.valueOf(endElement) + ", startContainingFile: " + String.valueOf(startContainingFile));
        }
        if (rangeInElement != null && startElementRange != null && endElementRange != null) {
            TextRange.assertProperRange((Segment)rangeInElement);
            if (rangeInElement.getEndOffset() > endElementRange.getEndOffset() - startElementRange.getStartOffset()) {
                LOG.error("Argument rangeInElement " + String.valueOf(rangeInElement) + " endOffset must not exceed descriptor text range (" + startElementRange.getStartOffset() + ", " + endElementRange.getEndOffset() + ") length (" + (endElementRange.getEndOffset() - startElementRange.getStartOffset()) + ").");
            }
        }
        if (rangeInElement != null) {
            LOG.assertTrue(!(startElement instanceof PsiBinaryFile));
            TextRange.assertProperRange((Segment)rangeInElement);
        }
        this.myHighlightType = highlightType;
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        this.myStartSmartPointer = manager.createSmartPsiElementPointer(startElement, startContainingFile);
        SmartPsiElementPointer<?> smartPsiElementPointer = this.myEndSmartPointer = startElement == endElement ? null : manager.createSmartPsiElementPointer(endElement, endContainingFile);
        if (this.myEndSmartPointer != null && endContainingFile != startContainingFile) {
            LOG.error("start/end elements should be from the same file but was startContainingFile=" + String.valueOf(startContainingFile) + " (" + String.valueOf(startContainingFile == null ? null : PsiUtilCore.getVirtualFile((PsiElement)startContainingFile)) + "), endContainingFile=" + String.valueOf(endContainingFile) + " (" + String.valueOf(endContainingFile == null ? null : PsiUtilCore.getVirtualFile((PsiElement)endContainingFile)) + ")");
        }
        this.myAfterEndOfLine = isAfterEndOfLine;
        this.myTextRangeInElement = rangeInElement;
        this.myOnTheFly = onTheFly;
    }

    public ProblemDescriptorBase(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull LocalQuickFix @Nullable [] fixes, @NotNull ProblemHighlightType highlightType, boolean isAfterEndOfLine, @Nullable TextRange rangeInElement, boolean showTooltip, boolean onTheFly, @Nullable String tooltip) {
        if (startElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(5);
        }
        if (descriptionTemplate == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(6);
        }
        if (highlightType == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(7);
        }
        this(startElement, endElement, descriptionTemplate, fixes, highlightType, isAfterEndOfLine, rangeInElement, showTooltip, onTheFly);
        this.tooltip = tooltip;
    }

    private static @NotNull LocalQuickFix @Nullable [] filterFixes(LocalQuickFix @Nullable [] fixes, boolean onTheFly) {
        if (onTheFly || fixes == null) {
            return fixes;
        }
        List filtered = ContainerUtil.filter((Object[])fixes, fix -> fix != null && fix.availableInBatchMode());
        return filtered.isEmpty() ? LocalQuickFix.EMPTY_ARRAY : filtered.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @Nullable
    private static TextRange getAnnotationRange(@NotNull PsiElement startElement) {
        TextRange textRange;
        if (startElement == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(8);
        }
        if (startElement instanceof ExternallyAnnotated) {
            ExternallyAnnotated externally = (ExternallyAnnotated)startElement;
            textRange = externally.getAnnotationRegion();
        } else {
            textRange = startElement.getTextRange();
        }
        return textRange;
    }

    private void assertPhysical(@NotNull PsiElement element) {
        if (element == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(9);
        }
        if (!element.isPhysical()) {
            LOG.error("Non-physical PsiElement. Physical element is required to be able to anchor the problem in the source tree: " + String.valueOf(element) + "; parent: " + String.valueOf(element.getParent()) + "; file: " + String.valueOf(element.getContainingFile()));
        }
    }

    public PsiElement getPsiElement() {
        PsiElement startElement = this.getStartElement();
        if (this.myEndSmartPointer == null) {
            return startElement;
        }
        PsiElement endElement = this.getEndElement();
        if (startElement == endElement) {
            return startElement;
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
    }

    @Nullable
    public TextRange getTextRangeInElement() {
        return this.myTextRangeInElement;
    }

    public PsiElement getStartElement() {
        return this.myStartSmartPointer.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndSmartPointer == null ? this.getStartElement() : this.myEndSmartPointer.getElement();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myStartSmartPointer.getProject();
        if (project == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(10);
        }
        return project;
    }

    public int getLineNumber() {
        if (this.myLineNumber == -1) {
            int textLength;
            PsiElement psiElement = this.getPsiElement();
            if (psiElement == null) {
                return -1;
            }
            if (!psiElement.isValid()) {
                return -1;
            }
            LOG.assertTrue(psiElement.isPhysical());
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)psiElement.getProject());
            PsiFile containingFile = manager.getTopLevelFile(psiElement);
            Document document = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(containingFile);
            if (document == null) {
                return -1;
            }
            TextRange textRange = this.getTextRange();
            if (textRange == null) {
                return -1;
            }
            int startOffset = (textRange = manager.injectedToHost(psiElement, textRange)).getStartOffset();
            LOG.assertTrue(startOffset <= (textLength = document.getTextLength()), (Object)(this.getDescriptionTemplate() + " at " + startOffset + ", " + textLength));
            this.myLineNumber = document.getLineNumber(startOffset);
        }
        return this.myLineNumber;
    }

    public int getLineStartOffset() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return -1;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)psiElement.getProject());
        PsiFile containingFile = manager.getTopLevelFile(psiElement);
        Document document = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(containingFile);
        if (document == null) {
            return -1;
        }
        return document.getLineStartOffset(this.getLineNumber());
    }

    @NotNull
    public ProblemHighlightType getHighlightType() {
        ProblemHighlightType problemHighlightType = this.myHighlightType;
        if (problemHighlightType == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(11);
        }
        return problemHighlightType;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setTextAttributes(TextAttributesKey key) {
        this.myEnforcedTextAttributes = key;
    }

    public TextAttributesKey getEnforcedTextAttributes() {
        return this.myEnforcedTextAttributes;
    }

    @Nullable
    public TextRange getTextRangeForNavigation() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            return null;
        }
        PsiElement element = this.getPsiElement();
        return InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, textRange);
    }

    @Nullable
    public TextRange getTextRange() {
        PsiElement endElement;
        PsiElement startElement = this.getStartElement();
        PsiElement psiElement = endElement = this.myEndSmartPointer == null ? startElement : this.getEndElement();
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange startRange = ProblemDescriptorBase.getAnnotationRange(startElement);
        if (startRange == null) {
            return null;
        }
        if (startElement != endElement) {
            TextRange endRange = ProblemDescriptorBase.getAnnotationRange(endElement);
            if (endRange == null) {
                return null;
            }
            startRange = startRange.union(endRange);
        } else if (this.myTextRangeInElement != null) {
            if (this.myTextRangeInElement.getEndOffset() > startRange.getLength()) {
                return null;
            }
            startRange = startRange.cutOut(this.myTextRangeInElement);
        }
        if (this.isAfterEndOfLine()) {
            int endOffset = startRange.getEndOffset();
            return new TextRange(endOffset, endOffset);
        }
        return startRange;
    }

    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    @Nullable
    public VirtualFile getContainingFile() {
        return this.myStartSmartPointer.getVirtualFile();
    }

    public void setNavigatable(Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    public boolean showTooltip() {
        return this.myShowTooltip;
    }

    @NotNull
    public String getTooltipTemplate() {
        String string = this.tooltip == null ? this.getDescriptionTemplate() : this.tooltip;
        if (string == null) {
            ProblemDescriptorBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public String toString() {
        PsiElement element = this.getPsiElement();
        return ProblemDescriptorUtil.renderDescriptionMessage(this, element);
    }

    public @NotNull LocalQuickFix @Nullable [] getFixes() {
        return (LocalQuickFix[])super.getFixes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertPhysical";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

