/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import com.intellij.codeInspection.dataFlow.memory.EqClass;
import com.intellij.codeInspection.dataFlow.memory.SortedIntSet;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EqClassImpl
extends SortedIntSet
implements EqClass {
    private final DfaValueFactory myFactory;
    public static final Comparator<DfaVariableValue> CANONICAL_VARIABLE_COMPARATOR = Comparator.nullsFirst((v1, v2) -> {
        int result = CANONICAL_VARIABLE_COMPARATOR.compare(v1.getQualifier(), v2.getQualifier());
        if (result != 0) {
            return result;
        }
        return Integer.compare(v1.getID(), v2.getID());
    });

    EqClassImpl(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    EqClassImpl(@NotNull EqClassImpl toCopy) {
        if (toCopy == null) {
            EqClassImpl.$$$reportNull$$$0(0);
        }
        super(toCopy.toNativeArray());
        this.myFactory = toCopy.myFactory;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            int value = this.get(i);
            DfaValue dfaValue = this.myFactory.getValue(value);
            buf.append(dfaValue);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    @NotNull
    public DfaVariableValue getVariable(int index) {
        DfaVariableValue dfaVariableValue = (DfaVariableValue)this.myFactory.getValue(this.get(index));
        if (dfaVariableValue == null) {
            EqClassImpl.$$$reportNull$$$0(1);
        }
        return dfaVariableValue;
    }

    @Override
    @NotNull
    public List<DfaVariableValue> asList() {
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.size());
        this.forValues(id -> vars.add((DfaVariableValue)this.myFactory.getValue(id)));
        ArrayList<DfaVariableValue> arrayList = vars;
        if (arrayList == null) {
            EqClassImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public DfaVariableValue getCanonicalVariable() {
        if (this.size() == 1) {
            return this.getVariable(0);
        }
        return StreamEx.of(this.iterator()).min(CANONICAL_VARIABLE_COMPARATOR).orElse(null);
    }

    @Override
    @NotNull
    public Iterator<DfaVariableValue> iterator() {
        return new Iterator<DfaVariableValue>(){
            int pos;

            @Override
            public boolean hasNext() {
                return this.pos < EqClassImpl.this.size();
            }

            @Override
            public DfaVariableValue next() {
                if (this.pos >= EqClassImpl.this.size()) {
                    throw new NoSuchElementException();
                }
                return (DfaVariableValue)EqClassImpl.this.myFactory.getValue(EqClassImpl.this.get(this.pos++));
            }
        };
    }

    @Override
    public boolean contains(@NotNull DfaValue value) {
        if (value == null) {
            EqClassImpl.$$$reportNull$$$0(3);
        }
        return this.contains(value.getID());
    }

    @Override
    public boolean containsAll(@NotNull EqClass that) {
        if (that == null) {
            EqClassImpl.$$$reportNull$$$0(4);
        }
        return this.containsAll((SortedIntSet)((Object)that));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/memory/EqClassImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/memory/EqClassImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

