/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl.modcommand;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.options.OptControl;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.lang.impl.modcommand.ModCommandActionQuickFixUberWrapper;
import com.intellij.lang.impl.modcommand.ModCommandActionQuickFixWrapper;
import com.intellij.lang.impl.modcommand.ModCommandActionWrapper;
import com.intellij.lang.impl.modcommand.PsiUpdateImpl;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandService;
import com.intellij.modcommand.ModCommandWithContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.ModUpdateSystemOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ModCommandServiceImpl
implements ModCommandService {
    @NotNull
    public IntentionAction wrap(@NotNull ModCommandAction action) {
        if (action == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(0);
        }
        return new ModCommandActionWrapper(action, null);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement wrapToLocalQuickFixAndIntentionActionOnPsiElement(@NotNull ModCommandAction action, @NotNull PsiElement psiElement) {
        if (action == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(2);
        }
        return new ModCommandActionQuickFixUberWrapper(action, psiElement);
    }

    @NotNull
    public LocalQuickFix wrapToQuickFix(@NotNull ModCommandAction action) {
        if (action == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(3);
        }
        return new ModCommandActionQuickFixWrapper(action);
    }

    @NotNull
    public LocalQuickFix wrapToQuickFix(@NotNull ModCommandAction action, boolean availableInBatchMode) {
        if (action == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(4);
        }
        return new ModCommandActionQuickFixWrapper(action, availableInBatchMode);
    }

    @Nullable
    public ModCommandAction unwrap(@NotNull LocalQuickFix fix) {
        if (fix == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(5);
        }
        if (fix instanceof ModCommandActionQuickFixWrapper) {
            ModCommandActionQuickFixWrapper wrapper = (ModCommandActionQuickFixWrapper)fix;
            return wrapper.getAction();
        }
        return null;
    }

    @NotNull
    public ModCommand psiUpdate(@NotNull ActionContext context, @NotNull @NotNull Consumer<@NotNull ModPsiUpdater> updater) {
        if (context == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(7);
        }
        ModCommand modCommand = PsiUpdateImpl.psiUpdate(context, updater);
        if (modCommand == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(8);
        }
        return modCommand;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public <T extends InspectionProfileEntry> ModCommand updateOption(@NotNull PsiElement context, @NotNull T inspection, @NotNull @NotNull Consumer<@NotNull T> updater) {
        if (context == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(9);
        }
        if (inspection == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(10);
        }
        if (updater == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(11);
        }
        InspectionProfileEntry copiedTool = ModCommandServiceImpl.getToolCopy(context, inspection);
        @NotNull List controls = inspection.getOptionsPane().allControls();
        Element options = new Element("copy");
        inspection.writeSettings(options);
        copiedTool.readSettings(options);
        updater.accept(copiedTool);
        OptionController oldController = inspection.getOptionController();
        OptionController newController = copiedTool.getOptionController();
        ArrayList<ModUpdateSystemOptions.ModifiedOption> modifiedOptions = new ArrayList<ModUpdateSystemOptions.ModifiedOption>();
        for (OptControl control : controls) {
            Object oldValue = oldController.getOption(control.bindId());
            Object newValue = newController.getOption(control.bindId());
            if (oldValue == null || newValue == null || oldValue.equals(newValue)) continue;
            String bindId = "currentProfile." + inspection.getShortName() + ".options." + control.bindId();
            modifiedOptions.add(new ModUpdateSystemOptions.ModifiedOption(bindId, oldValue, newValue));
        }
        return modifiedOptions.isEmpty() ? ModCommand.nop() : new ModUpdateSystemOptions(modifiedOptions);
    }

    @NotNull
    private static <T extends InspectionProfileEntry> InspectionProfileEntry getToolCopy(@NotNull PsiElement context, @NotNull T inspection) {
        InspectionToolWrapper<?, ?> tool;
        if (context == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(12);
        }
        if (inspection == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(13);
        }
        if ((tool = InspectionProfileManager.getInstance(context.getProject()).getCurrentProfile().getInspectionTool(inspection.getShortName(), context)) == null) {
            throw new IllegalArgumentException("Tool not found: " + inspection.getShortName());
        }
        InspectionProfileEntry copiedTool = tool.createCopy().getTool();
        if (copiedTool.getClass() != inspection.getClass()) {
            GlobalInspectionTool global;
            LocalInspectionTool local;
            if (copiedTool instanceof GlobalInspectionTool && (local = (global = (GlobalInspectionTool)copiedTool).getSharedLocalInspectionTool()) != null) {
                copiedTool = local;
            }
            if (copiedTool.getClass() != inspection.getClass()) {
                throw new IllegalArgumentException("Invalid class: " + String.valueOf(copiedTool.getClass()) + "!=" + String.valueOf(inspection.getClass()) + " (id: " + inspection.getShortName() + ")");
            }
        }
        InspectionProfileEntry inspectionProfileEntry = copiedTool;
        if (inspectionProfileEntry == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(14);
        }
        return inspectionProfileEntry;
    }

    @Nullable
    public ModCommandWithContext chooseFileAndPerform(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull ModCommandAction commandAction, int fixOffset) {
        if (hostFile == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(15);
        }
        if (commandAction == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(16);
        }
        Project project = hostFile.getProject();
        ThrowableComputable computable = () -> (ModCommandWithContext)ReadAction.nonBlocking(() -> {
            ActionContext context = ModCommandServiceImpl.chooseContextForAction(hostFile, hostEditor, commandAction, fixOffset);
            if (context == null) {
                return new ModCommandWithContext(ActionContext.from(null, (PsiFile)hostFile), ModCommand.nop());
            }
            return new ModCommandWithContext(context, commandAction.perform(context));
        }).expireWhen(() -> project.isDisposed()).executeSynchronously();
        return (ModCommandWithContext)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, commandAction.getFamilyName(), true, project);
    }

    @RequiresBackgroundThread
    @Nullable
    private static ActionContext chooseContextForAction(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull ModCommandAction commandAction, int fixOffset) {
        ActionContext injectedContext;
        if (hostFile == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(17);
        }
        if (commandAction == null) {
            ModCommandServiceImpl.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (hostEditor == null) {
            return ActionContext.from(null, (PsiFile)hostFile);
        }
        int offset = fixOffset >= 0 ? fixOffset : hostEditor.getCaretModel().getOffset();
        ActionContext hostContext = ActionContext.from((Editor)hostEditor, (PsiFile)hostFile).withOffset(offset);
        PsiFile injectedFile = InjectedLanguageUtilBase.findInjectedPsiNoCommit(hostFile, offset);
        if (injectedFile != null && commandAction.getPresentation(injectedContext = hostContext.mapToInjected(injectedFile)) != null) {
            return injectedContext;
        }
        if (commandAction.getPresentation(hostContext) != null) {
            return hostContext.withOffset(offset);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/modcommand/ModCommandServiceImpl";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/modcommand/ModCommandServiceImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "psiUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapToLocalQuickFixAndIntentionActionOnPsiElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapToQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "psiUpdate";
                break;
            }
            case 8: 
            case 14: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateOption";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolCopy";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "chooseFileAndPerform";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "chooseContextForAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 14 -> new IllegalStateException(string);
        };
    }
}

