/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;

class VirtualFileWindowImpl
extends LightVirtualFile
implements VirtualFileWindow {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VirtualFileWindowImpl.class);
    private final VirtualFile myDelegate;
    private final DocumentWindowImpl myDocumentWindow;

    VirtualFileWindowImpl(@NotNull String name, @NotNull VirtualFile delegate, @NotNull DocumentWindowImpl window, @NotNull Language language, @NotNull CharSequence text) {
        if (name == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(1);
        }
        if (window == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(2);
        }
        if (language == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(3);
        }
        if (text == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(4);
        }
        super(name, language, text);
        this.setCharset(delegate.getCharset(), null, false);
        this.setFileType((FileType)language.getAssociatedFileType());
        if (delegate instanceof VirtualFileWindow) {
            throw new IllegalArgumentException(String.valueOf(delegate) + " must not be injected");
        }
        this.myDelegate = delegate;
        this.myDocumentWindow = window;
    }

    @NotNull
    public String getPresentableName() {
        Language language = this.getLanguage();
        String string = AnalysisBundle.message((String)"virtual.file.window.name", (Object[])new Object[]{language != null && language != Language.ANY ? language.getDisplayName() + " " : ""});
        if (string == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public VirtualFile getDelegate() {
        VirtualFile virtualFile = this.myDelegate;
        if (virtualFile == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public DocumentWindowImpl getDocumentWindow() {
        DocumentWindowImpl documentWindowImpl = this.myDocumentWindow;
        if (documentWindowImpl == null) {
            VirtualFileWindowImpl.$$$reportNull$$$0(7);
        }
        return documentWindowImpl;
    }

    public boolean isValid() {
        return this.myDelegate.isValid() && this.myDocumentWindow.isValid();
    }

    public String toString() {
        return "VirtualFileWindow in " + this.myDelegate.getPresentableUrl();
    }

    public boolean isWritable() {
        return this.myDelegate.isWritable();
    }

    public void setWritable(boolean writable) {
        LOG.error("Operation is not supported");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/VirtualFileWindowImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/VirtualFileWindowImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

