/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl.modcommand;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.injected.editor.InjectionEditService;
import com.intellij.lang.Language;
import com.intellij.lang.impl.modcommand.ChangedVirtualDirectory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.FutureVirtualFile;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCreateFile;
import com.intellij.modcommand.ModDeleteFile;
import com.intellij.modcommand.ModHighlight;
import com.intellij.modcommand.ModNavigate;
import com.intellij.modcommand.ModNothing;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.ModShowConflicts;
import com.intellij.modcommand.ModStartRename;
import com.intellij.modcommand.ModStartTemplate;
import com.intellij.modcommand.ModTemplateBuilder;
import com.intellij.modcommand.ModUpdateFileText;
import com.intellij.modcommand.ModUpdateReferences;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiUpdateImpl {
    private static final Key<PsiFile> ORIGINAL_FILE_FOR_INJECTION = Key.create((String)"ORIGINAL_FILE_FOR_INJECTION");

    PsiUpdateImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static ModCommand psiUpdate(final @NotNull ActionContext context, final @NotNull @NotNull Consumer<@NotNull ModPsiUpdater> updater) {
        if (context == null) {
            PsiUpdateImpl.$$$reportNull$$$0(0);
        }
        if (updater == null) {
            PsiUpdateImpl.$$$reportNull$$$0(1);
        }
        var runnable = new Runnable(){
            private ModPsiUpdaterImpl myUpdater;

            @Override
            public void run() {
                this.myUpdater = new ModPsiUpdaterImpl(context);
                updater.accept(this.myUpdater);
            }

            void dispose() {
                if (this.myUpdater != null) {
                    Disposer.dispose((Disposable)this.myUpdater);
                }
            }
        };
        PostprocessReformattingAspect.getInstance((Project)context.project()).postponeFormattingInside(runnable);
        ModCommand modCommand = runnable.myUpdater.getCommand();
        ModCommand modCommand2 = modCommand;
        if (modCommand2 == null) {
            PsiUpdateImpl.$$$reportNull$$$0(2);
        }
        return modCommand2;
        finally {
            runnable.dispose();
        }
    }

    @NotNull
    private static PsiFile getInjectedFileCopy(@NotNull PsiLanguageInjectionHost host, @NotNull PsiFile hostFileCopy, final @NotNull Language injectedLanguage) {
        if (host == null) {
            PsiUpdateImpl.$$$reportNull$$$0(3);
        }
        if (hostFileCopy == null) {
            PsiUpdateImpl.$$$reportNull$$$0(4);
        }
        if (injectedLanguage == null) {
            PsiUpdateImpl.$$$reportNull$$$0(5);
        }
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)hostFileCopy.getProject());
        PsiLanguageInjectionHost hostCopy = (PsiLanguageInjectionHost)PsiTreeUtil.findSameElementInCopy((PsiElement)host, (PsiFile)hostFileCopy);
        var visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){
            private final Language origLanguage;
            PsiFile injectedFileCopy;
            {
                this.origLanguage = injectedLanguage;
                this.injectedFileCopy = null;
            }

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (places == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (injectedPsi.getLanguage() == this.origLanguage) {
                    this.injectedFileCopy = injectedPsi;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "injectedPsi";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "places";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$2";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        injectionManager.enumerate((PsiElement)hostCopy, visitor);
        PsiFile psiFile = Objects.requireNonNull(visitor.injectedFileCopy);
        if (psiFile == null) {
            PsiUpdateImpl.$$$reportNull$$$0(6);
        }
        return psiFile;
    }

    @NotNull
    private static PsiFile copyFile(Project project, PsiFile origFile) {
        PsiFile file;
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        boolean injectedFragment = manager.isInjectedFragment(origFile);
        if (!injectedFragment) {
            PsiElement navigationElement = origFile.getNavigationElement();
            file = navigationElement != origFile && navigationElement instanceof PsiFile ? (PsiFile)navigationElement.copy() : (PsiFile)origFile.copy();
        } else {
            file = PsiFileFactory.getInstance((Project)project).createFileFromText(origFile.getName(), origFile.getLanguage(), (CharSequence)manager.getUnescapedText((PsiElement)origFile), false, true, true, origFile.getVirtualFile());
            file.putUserData(ORIGINAL_FILE_FOR_INJECTION, (Object)origFile);
        }
        file.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)origFile);
        PsiFile psiFile = file;
        if (psiFile == null) {
            PsiUpdateImpl.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileCopy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "psiUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFileCopy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiUpdate";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedFileCopy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class ModPsiUpdaterImpl
    implements ModPsiUpdater,
    DocumentListener,
    Disposable {
        @NotNull
        private final ActionContext myActionContext;
        @Nullable
        private FileTracker myTracker;
        @NotNull
        private final Map<PsiFile, FileTracker> myChangedFiles;
        @NotNull
        private final Map<VirtualFile, ChangedDirectoryInfo> myChangedDirectories;
        @Nullable
        private VirtualFile myNavigationFile;
        private int myCaretOffset;
        private int myCaretVirtualEnd;
        @NotNull
        private TextRange mySelection;
        private final List<ModHighlight.HighlightInfo> myHighlightInfos;
        private final List<ModStartTemplate.TemplateField> myTemplateFields;
        @NotNull
        private @NotNull Function<? super @NotNull PsiFile, ? extends @NotNull ModCommand> myTemplateFinishFunction;
        @Nullable
        private ModStartRename myRenameSymbol;
        private final List<ModUpdateReferences> myTrackedDeclarations;
        private boolean myPositionUpdated;
        private @NlsContexts.Tooltip String myErrorMessage;
        private @NlsContexts.Tooltip String myInfoMessage;
        @NotNull
        private final @NotNull Map<@NotNull PsiElement, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModShowConflicts.Conflict> myConflictMap;

        private ModPsiUpdaterImpl(@NotNull ActionContext actionContext) {
            if (actionContext == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(0);
            }
            this.myChangedFiles = new LinkedHashMap<PsiFile, FileTracker>();
            this.myChangedDirectories = new LinkedHashMap<VirtualFile, ChangedDirectoryInfo>();
            this.myHighlightInfos = new ArrayList<ModHighlight.HighlightInfo>();
            this.myTemplateFields = new ArrayList<ModStartTemplate.TemplateField>();
            this.myTemplateFinishFunction = f -> ModCommand.nop();
            this.myTrackedDeclarations = new ArrayList<ModUpdateReferences>();
            this.myPositionUpdated = false;
            this.myConflictMap = new LinkedHashMap<PsiElement, ModShowConflicts.Conflict>();
            this.myActionContext = actionContext;
            this.myCaretOffset = this.myCaretVirtualEnd = actionContext.offset();
            this.mySelection = actionContext.selection();
        }

        @NotNull
        private FileTracker tracker() {
            FileTracker fileTracker = this.myTracker == null ? this.tracker(this.myActionContext.file()) : this.myTracker;
            if (fileTracker == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(1);
            }
            return fileTracker;
        }

        @NotNull
        private VirtualFile navigationFile() {
            if (this.myNavigationFile == null) {
                this.myNavigationFile = this.tracker().myOrigFile.getViewProvider().getVirtualFile();
            }
            VirtualFile virtualFile = this.myNavigationFile;
            if (virtualFile == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        private FileTracker tracker(@NotNull PsiFile file) {
            if (file == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(3);
            }
            FileTracker result = this.myChangedFiles.computeIfAbsent(file, origFile -> {
                FileTracker tracker = new FileTracker((PsiFile)origFile, this.myChangedFiles);
                Disposer.register((Disposable)this, (Disposable)tracker);
                return tracker;
            });
            if (this.myTracker == null && this.myActionContext.file() == file) {
                this.myTracker = result;
                this.myTracker.myPositionDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
            }
            FileTracker fileTracker = result;
            if (fileTracker == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(4);
            }
            return fileTracker;
        }

        @NotNull
        public PsiFile getOriginalFile(@NotNull PsiFile copyFile) throws IllegalArgumentException {
            Map.Entry entry;
            if (copyFile == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(5);
            }
            if ((entry = (Map.Entry)ContainerUtil.find(this.myChangedFiles.entrySet(), e -> ((FileTracker)e.getValue()).myCopyFile == copyFile)) == null) {
                throw new IllegalArgumentException("Supplied file is not a writable copy tracked by this tracker: " + String.valueOf(copyFile));
            }
            PsiFile psiFile = (PsiFile)entry.getKey();
            if (psiFile == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(6);
            }
            return psiFile;
        }

        public <E extends PsiElement> E getWritable(E element) {
            if (element == null) {
                return null;
            }
            if (element instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)element;
                VirtualFile file = dir.getVirtualFile();
                if (file instanceof ChangedVirtualDirectory) {
                    return element;
                }
                ChangedDirectoryInfo directory = this.myChangedDirectories.computeIfAbsent(file, f -> ChangedDirectoryInfo.create(dir));
                PsiDirectory result = directory.psiDirectory;
                return (E)result;
            }
            PsiFile file = element.getContainingFile();
            if (file.getViewProvider().getVirtualFile() instanceof ChangedVirtualDirectory.AddedVirtualFile) {
                return element;
            }
            PsiFile originalFile = (PsiFile)ObjectUtils.coalesce((Object)((PsiFile)file.getUserData(ORIGINAL_FILE_FOR_INJECTION)), (Object)file.getOriginalFile());
            if (originalFile != file) {
                FileTracker tracker = this.tracker(originalFile);
                if (tracker.myCopyFile == file) {
                    return element;
                }
            }
            return this.tracker(file).getCopy(element);
        }

        public void dispose() {
        }

        public void select(@NotNull PsiElement element) {
            TextRange range;
            if (element == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(7);
            }
            if ((range = this.getRange(element)) != null) {
                this.select(range);
            }
        }

        @Nullable
        private TextRange getRange(@NotNull PsiElement element) {
            if (element == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(8);
            }
            if (!element.isValid()) {
                throw new IllegalArgumentException("Element " + String.valueOf(element) + " is not valid");
            }
            if (this.myTracker == null || !PsiTreeUtil.isAncestor((PsiElement)this.myTracker.myCopyFile, (PsiElement)element, (boolean)false)) {
                LightVirtualFile lvf;
                PsiFile file = element.getContainingFile();
                VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                if (virtualFile instanceof LightVirtualFile && (virtualFile = (lvf = (LightVirtualFile)virtualFile).getParent()) instanceof ChangedVirtualDirectory) {
                    ChangedVirtualDirectory cvd = (ChangedVirtualDirectory)virtualFile;
                    this.myNavigationFile = new FutureVirtualFile(cvd.getOriginalFile(), lvf.getName(), lvf.getFileType());
                } else {
                    this.myNavigationFile = file.getOriginalFile().getVirtualFile();
                }
                if (this.myTracker != null) {
                    this.myTracker.myPositionDocument.removeDocumentListener((DocumentListener)this);
                }
                this.myTracker = this.tracker(file.getOriginalFile());
                this.myTracker.myPositionDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
                return element.getTextRange();
            }
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)element);
            this.myTracker.unblock();
            Segment range = pointer.getRange();
            if (range == null) {
                return null;
            }
            return TextRange.create((Segment)range);
        }

        @NotNull
        private static TextRange templateRange(@NotNull TextRange elementRange, @Nullable TextRange rangeInElement) {
            if (elementRange == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(9);
            }
            if (rangeInElement == null) {
                TextRange textRange = elementRange;
                if (textRange == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(10);
                }
                return textRange;
            }
            int start = rangeInElement.getStartOffset();
            int templateStartOffset = elementRange.getStartOffset() + start;
            TextRange textRange = TextRange.from((int)templateStartOffset, (int)rangeInElement.getLength());
            if (textRange == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(11);
            }
            return textRange;
        }

        public void select(@NotNull TextRange range) {
            if (range == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(12);
            }
            this.myPositionUpdated = true;
            this.mySelection = range = this.mapRange(range);
            this.myCaretOffset = range.getStartOffset();
            this.myCaretVirtualEnd = range.getEndOffset();
        }

        public void highlight(@NotNull PsiElement element, @NotNull TextAttributesKey attributesKey) {
            TextRange range;
            if (element == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(13);
            }
            if (attributesKey == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(14);
            }
            if ((range = this.getRange(element)) != null) {
                this.highlight(range, attributesKey);
            }
        }

        public void highlight(@NotNull TextRange range, @NotNull TextAttributesKey attributesKey) {
            if (range == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(15);
            }
            if (attributesKey == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(16);
            }
            range = this.mapRange(range);
            this.myHighlightInfos.add(new ModHighlight.HighlightInfo(range, attributesKey, true));
        }

        @NotNull
        public ModTemplateBuilder templateBuilder() {
            if (!this.myTemplateFields.isEmpty()) {
                throw new IllegalStateException("Template was already created");
            }
            return new ModTemplateBuilder(){

                @NotNull
                public ModTemplateBuilder field(@NotNull PsiElement element, @NotNull Expression expression) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return this.createField(element, null, expression, null);
                }

                @NotNull
                public ModTemplateBuilder field(@NotNull PsiElement element, @NotNull String varName, @NotNull Expression expression) {
                    if (element == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (varName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (expression == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return this.createField(element, varName, expression, null);
                }

                @NotNull
                public ModTemplateBuilder field(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @NotNull String varName, @NotNull Expression expression) {
                    if (element == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (rangeInElement == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (varName == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (expression == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return this.createField(element, varName, expression, rangeInElement);
                }

                @NotNull
                private ModTemplateBuilder createField(@NotNull PsiElement element, @Nullable String varName, @NotNull Expression expression, @Nullable TextRange rangeInElement) {
                    TextRange elementRange;
                    if (element == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    if (expression == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    if ((elementRange = this.getRange(element)) == null) {
                        throw new IllegalStateException("Unable to restore element for template");
                    }
                    TextRange rangeForTemplate = ModPsiUpdaterImpl.templateRange(elementRange, rangeInElement);
                    TextRange range = this.mapRange(rangeForTemplate);
                    Result result = expression.calculateResult((ExpressionContext)new DummyContext(range, element));
                    myTemplateFields.add((ModStartTemplate.TemplateField)new ModStartTemplate.ExpressionField(range, varName, expression));
                    if (result != null) {
                        FileTracker tracker = Objects.requireNonNull(myTracker);
                        tracker.myDocument.replaceString(rangeForTemplate.getStartOffset(), rangeForTemplate.getEndOffset(), (CharSequence)result.toString());
                    }
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    return v0;
                }

                @NotNull
                public ModTemplateBuilder field(@NotNull PsiElement element, @NotNull String varName, @NotNull String dependantVariableName, boolean alwaysStopAt) {
                    TextRange elementRange;
                    if (element == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    if (varName == null) {
                        1.$$$reportNull$$$0(13);
                    }
                    if (dependantVariableName == null) {
                        1.$$$reportNull$$$0(14);
                    }
                    if ((elementRange = this.getRange(element)) == null) {
                        throw new IllegalStateException("Unable to restore element for template");
                    }
                    TextRange range = this.mapRange(elementRange);
                    myTemplateFields.add((ModStartTemplate.TemplateField)new ModStartTemplate.DependantVariableField(range, varName, dependantVariableName, alwaysStopAt));
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    return v0;
                }

                @NotNull
                public ModTemplateBuilder finishAt(int offset) {
                    TextRange range = this.mapRange(TextRange.create((int)offset, (int)offset));
                    myTemplateFields.add((ModStartTemplate.TemplateField)new ModStartTemplate.EndField(range));
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(16);
                    }
                    return v0;
                }

                @NotNull
                public ModTemplateBuilder onTemplateFinished(@NotNull @NotNull Function<? super @NotNull PsiFile, ? extends @NotNull ModCommand> templateFinishFunction) {
                    if (templateFinishFunction == null) {
                        1.$$$reportNull$$$0(17);
                    }
                    if (myTemplateFields.isEmpty()) {
                        throw new IllegalStateException("Template was not created");
                    }
                    myTemplateFinishFunction = templateFinishFunction;
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(18);
                    }
                    return v0;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 11, 15, 16, 18 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: 
                        case 4: 
                        case 8: 
                        case 10: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 3: 
                        case 7: 
                        case 13: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "varName";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "rangeInElement";
                            break;
                        }
                        case 11: 
                        case 15: 
                        case 16: 
                        case 18: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl$1";
                            break;
                        }
                        case 14: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dependantVariableName";
                            break;
                        }
                        case 17: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "templateFinishFunction";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl$1";
                            break;
                        }
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createField";
                            break;
                        }
                        case 15: {
                            objectArray = objectArray2;
                            objectArray2[1] = "field";
                            break;
                        }
                        case 16: {
                            objectArray = objectArray2;
                            objectArray2[1] = "finishAt";
                            break;
                        }
                        case 18: {
                            objectArray = objectArray2;
                            objectArray2[1] = "onTemplateFinished";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "field";
                            break;
                        }
                        case 9: 
                        case 10: {
                            objectArray = objectArray;
                            objectArray[2] = "createField";
                            break;
                        }
                        case 11: 
                        case 15: 
                        case 16: 
                        case 18: {
                            break;
                        }
                        case 17: {
                            objectArray = objectArray;
                            objectArray[2] = "onTemplateFinished";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 11, 15, 16, 18 -> new IllegalStateException(string);
                    };
                }
            };
        }

        public void moveCaretTo(int offset) {
            this.myPositionUpdated = true;
            PsiLanguageInjectionHost host = this.tracker().getHostCopy();
            if (host != null) {
                InjectedLanguageManager instance = InjectedLanguageManager.getInstance((Project)this.myActionContext.project());
                PsiFile file = this.findInjectedFile(instance, host);
                offset = instance.mapUnescapedOffsetToInjected(file, offset);
                offset = instance.injectedToHost((PsiElement)file, offset);
            }
            this.myCaretOffset = this.myCaretVirtualEnd = offset;
            if (!this.mySelection.containsOffset(offset)) {
                this.mySelection = TextRange.create((int)offset, (int)offset);
            }
        }

        public void moveCaretTo(@NotNull PsiElement element) {
            TextRange range;
            if (element == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(17);
            }
            if ((range = this.getRange(element)) != null) {
                range = this.mapRange(range);
                this.myPositionUpdated = true;
                this.myCaretOffset = range.getStartOffset();
                this.myCaretVirtualEnd = range.getEndOffset();
            }
        }

        public void rename(@NotNull PsiNameIdentifierOwner element, @NotNull @NotNull List<@NotNull String> suggestedNames) {
            if (element == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(18);
            }
            if (suggestedNames == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(19);
            }
            this.rename((PsiNamedElement)element, element.getNameIdentifier(), suggestedNames);
        }

        public void rename(@NotNull PsiNamedElement element, @Nullable PsiElement nameIdentifier, @NotNull @NotNull List<@NotNull String> suggestedNames) {
            if (element == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(20);
            }
            if (suggestedNames == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(21);
            }
            if (this.myRenameSymbol != null) {
                throw new IllegalStateException("One element is already registered for rename");
            }
            TextRange range = this.getRange((PsiElement)element);
            if (range == null) {
                throw new IllegalArgumentException("Element disappeared after postponed operations: " + String.valueOf(element));
            }
            range = this.mapRange(range);
            TextRange identifierRange = nameIdentifier != null ? this.getRange(nameIdentifier) : null;
            identifierRange = identifierRange == null ? null : this.mapRange(identifierRange);
            this.myRenameSymbol = new ModStartRename(this.navigationFile(), new ModStartRename.RenameSymbolRange(range, identifierRange), suggestedNames);
        }

        public void trackDeclaration(@NotNull PsiElement declaration) {
            TextRange range;
            if (declaration == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(22);
            }
            if ((range = this.getRange(declaration)) == null) {
                throw new IllegalArgumentException("Element disappeared after postponed operations: " + String.valueOf(declaration));
            }
            range = this.mapRange(range);
            String oldText = Objects.requireNonNull(this.myTracker).myCopyFile.getText();
            this.myTrackedDeclarations.add(new ModUpdateReferences(this.navigationFile(), oldText, range, range));
        }

        public void cancel(@NlsContexts.Tooltip @NotNull String errorMessage) {
            if (errorMessage == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(23);
            }
            if (this.myErrorMessage != null) {
                throw new IllegalStateException("Update is already cancelled");
            }
            this.myErrorMessage = errorMessage;
        }

        public void message(@NotNull String message) {
            if (message == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(24);
            }
            if (this.myInfoMessage != null) {
                throw new IllegalStateException("Message display was already requested; cannot show two messages");
            }
            this.myInfoMessage = message;
        }

        public int getCaretOffset() {
            return this.myCaretOffset;
        }

        public void showConflicts(@NotNull @NotNull Map<@NotNull PsiElement, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModShowConflicts.Conflict> conflicts) {
            if (conflicts == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(25);
            }
            conflicts.forEach((e, c) -> {
                PsiFile file;
                FileTracker tracker;
                if (!e.isPhysical() && (tracker = this.myChangedFiles.get(file = e.getContainingFile().getOriginalFile())) != null) {
                    if (!tracker.myFragments.isEmpty()) {
                        throw new IllegalArgumentException("Supplied element belongs to a changed file");
                    }
                    e = PsiTreeUtil.findSameElementInCopy((PsiElement)e, (PsiFile)file);
                }
                this.myConflictMap.merge((PsiElement)e, (ModShowConflicts.Conflict)c, ModShowConflicts.Conflict::merge);
            });
        }

        private TextRange mapRange(@NotNull TextRange range) {
            PsiLanguageInjectionHost host;
            if (range == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(26);
            }
            if ((host = this.tracker().getHostCopy()) != null) {
                InjectedLanguageManager instance = InjectedLanguageManager.getInstance((Project)this.myActionContext.project());
                PsiFile file = this.findInjectedFile(instance, host);
                int start = instance.mapUnescapedOffsetToInjected(file, range.getStartOffset());
                int end = instance.mapUnescapedOffsetToInjected(file, range.getEndOffset());
                range = instance.injectedToHost((PsiElement)file, TextRange.create((int)start, (int)end));
            }
            return range;
        }

        @NotNull
        private PsiFile findInjectedFile(InjectedLanguageManager instance, PsiLanguageInjectionHost host) {
            final Language language = this.tracker().myCopyFile.getLanguage();
            var visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){
                PsiFile myFile = null;

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (places == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (injectedPsi.getLanguage() == language) {
                        this.myFile = injectedPsi;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "injectedPsi";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "places";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl$2";
                    objectArray[2] = "visit";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            instance.enumerate((PsiElement)host, visitor);
            PsiFile psiFile = Objects.requireNonNull(visitor.myFile);
            if (psiFile == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(27);
            }
            return psiFile;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(28);
            }
            if (this.myCaretVirtualEnd > this.myCaretOffset) {
                this.myCaretOffset = ModPsiUpdaterImpl.updateOffset(event, this.myCaretOffset, true);
                this.myCaretVirtualEnd = ModPsiUpdaterImpl.updateOffset(event, this.myCaretVirtualEnd, false);
            } else {
                this.myCaretOffset = this.myCaretVirtualEnd = ModPsiUpdaterImpl.updateOffset(event, this.myCaretOffset, false);
            }
            this.mySelection = ModPsiUpdaterImpl.updateRange(event, this.mySelection);
            this.myHighlightInfos.replaceAll(info -> info.withRange(ModPsiUpdaterImpl.updateRange(event, info.range())));
            this.myTemplateFields.replaceAll(info -> info.withRange(ModPsiUpdaterImpl.updateRange(event, info.range())));
            this.myTrackedDeclarations.replaceAll(range -> range.withNewRange(ModPsiUpdaterImpl.updateRange(event, range.newRange())));
            if (this.myRenameSymbol != null) {
                ModStartRename.RenameSymbolRange renameSymbolRange = this.myRenameSymbol.symbolRange();
                this.myRenameSymbol = this.myRenameSymbol.withRange(ModPsiUpdaterImpl.updateRange(event, renameSymbolRange));
            }
        }

        @NotNull
        private static ModStartRename.RenameSymbolRange updateRange(@NotNull DocumentEvent event, @NotNull ModStartRename.RenameSymbolRange range) {
            if (event == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(29);
            }
            if (range == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(30);
            }
            TextRange idRange = range.nameIdentifierRange();
            return new ModStartRename.RenameSymbolRange(ModPsiUpdaterImpl.updateRange(event, range.range()), idRange != null ? ModPsiUpdaterImpl.updateRange(event, idRange) : null);
        }

        @NotNull
        private static TextRange updateRange(@NotNull DocumentEvent event, @NotNull TextRange range) {
            if (event == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(31);
            }
            if (range == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(32);
            }
            if (range.isEmpty()) {
                int newPos = ModPsiUpdaterImpl.updateOffset(event, range.getEndOffset(), false);
                TextRange textRange = newPos == range.getEndOffset() ? range : TextRange.from((int)newPos, (int)0);
                if (textRange == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(33);
                }
                return textRange;
            }
            int newStart = ModPsiUpdaterImpl.updateOffset(event, range.getStartOffset(), true);
            int newEnd = ModPsiUpdaterImpl.updateOffset(event, range.getEndOffset(), false);
            if (range.getStartOffset() == newStart && range.getEndOffset() == newEnd) {
                TextRange textRange = range;
                if (textRange == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(34);
                }
                return textRange;
            }
            TextRange textRange = TextRange.create((int)newStart, (int)newEnd);
            if (textRange == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(35);
            }
            return textRange;
        }

        private static int updateOffset(DocumentEvent event, int pos, boolean leanRight) {
            String oldContent;
            String newContent;
            int index;
            int offset = event.getOffset();
            int oldLength = event.getOldLength();
            int newLength = event.getNewLength();
            if (pos < offset || pos == offset && (!leanRight || oldLength > 0)) {
                return pos;
            }
            if (pos >= offset + oldLength) {
                return pos + newLength - oldLength;
            }
            if (newLength > oldLength && (index = (newContent = event.getNewFragment().toString()).indexOf(oldContent = event.getOldFragment().toString())) >= 0) {
                return pos + index;
            }
            return offset + newLength;
        }

        @NotNull
        private ModCommand getCommand() {
            if (this.myRenameSymbol != null && !this.myTemplateFields.isEmpty()) {
                throw new IllegalStateException("Cannot have both rename and template commands");
            }
            if (this.myErrorMessage != null) {
                ModCommand modCommand = ModCommand.error((String)this.myErrorMessage);
                if (modCommand == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(36);
                }
                return modCommand;
            }
            if (ContainerUtil.exists(this.myChangedFiles.values(), ft -> ft.myGuardModification)) {
                ModCommand modCommand = ModCommand.error((String)AnalysisBundle.message((String)"modcommand.executor.modification.of.guarded.region", (Object[])new Object[0]));
                if (modCommand == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(37);
                }
                return modCommand;
            }
            ModCommand modCommand = ModCommand.showConflicts(this.myConflictMap).andThen(this.myChangedFiles.values().stream().map(fileTracker -> fileTracker.getUpdateCommand()).reduce(ModCommand.nop(), ModCommand::andThen)).andThen(this.myChangedDirectories.values().stream().flatMap(info -> info.createFileCommands(this.myActionContext.project())).reduce(ModCommand.nop(), ModCommand::andThen)).andThen(this.getNavigateCommand()).andThen(this.getHighlightCommand()).andThen(this.getTemplateCommand()).andThen(this.myTrackedDeclarations.stream().map(c -> c).reduce(ModCommand.nop(), ModCommand::andThen)).andThen((ModCommand)(this.myRenameSymbol == null ? ModCommand.nop() : this.myRenameSymbol)).andThen(this.myInfoMessage == null ? ModCommand.nop() : ModCommand.info((String)this.myInfoMessage));
            if (modCommand == null) {
                ModPsiUpdaterImpl.$$$reportNull$$$0(38);
            }
            return modCommand;
        }

        @NotNull
        private ModCommand getNavigateCommand() {
            if (!this.myPositionUpdated || this.myRenameSymbol != null || this.myTracker == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(39);
                }
                return modCommand;
            }
            int length = this.myTracker.myTargetFile.getFileDocument().getTextLength();
            int start = -1;
            int end = -1;
            int caret = -1;
            if (this.mySelection.getEndOffset() <= length) {
                start = this.mySelection.getStartOffset();
                end = this.mySelection.getEndOffset();
            }
            if (this.myCaretOffset <= length) {
                caret = this.myCaretOffset;
            }
            if (start == -1 && end == -1 && caret == -1) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(40);
                }
                return modCommand;
            }
            return new ModNavigate(this.navigationFile(), start, end, caret);
        }

        @NotNull
        private ModCommand getHighlightCommand() {
            if (this.myHighlightInfos.isEmpty()) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(41);
                }
                return modCommand;
            }
            return new ModHighlight(this.navigationFile(), this.myHighlightInfos);
        }

        @NotNull
        private ModCommand getTemplateCommand() {
            if (this.myTemplateFields.isEmpty()) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    ModPsiUpdaterImpl.$$$reportNull$$$0(42);
                }
                return modCommand;
            }
            return new ModStartTemplate(this.navigationFile(), this.myTemplateFields, this.myTemplateFinishFunction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4, 6, 10, 11, 27, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionContext";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 10: 
                case 11: 
                case 27: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copyFile";
                    break;
                }
                case 7: 
                case 8: 
                case 13: 
                case 17: 
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementRange";
                    break;
                }
                case 12: 
                case 15: 
                case 26: 
                case 30: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestedNames";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
                case 28: 
                case 29: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tracker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigationFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalFile";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "templateRange";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findInjectedFile";
                    break;
                }
                case 33: 
                case 34: 
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateRange";
                    break;
                }
                case 36: 
                case 37: 
                case 38: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
                case 39: 
                case 40: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigateCommand";
                    break;
                }
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightCommand";
                    break;
                }
                case 42: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 10: 
                case 11: 
                case 27: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tracker";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getOriginalFile";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "templateRange";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "highlight";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "moveCaretTo";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "rename";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "trackDeclaration";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "cancel";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "message";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "showConflicts";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "mapRange";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "documentChanged";
                    break;
                }
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "updateRange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4, 6, 10, 11, 27, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 -> new IllegalStateException(string);
            };
        }

        private record ChangedDirectoryInfo(@NotNull ChangedVirtualDirectory directory, @NotNull PsiDirectory psiDirectory) {
            @NotNull
            private final ChangedVirtualDirectory directory;
            @NotNull
            private final PsiDirectory psiDirectory;

            private ChangedDirectoryInfo(@NotNull ChangedVirtualDirectory directory, @NotNull PsiDirectory psiDirectory) {
                if (directory == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(0);
                }
                if (psiDirectory == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(1);
                }
            }

            @NotNull
            static ChangedDirectoryInfo create(@NotNull PsiDirectory directory) {
                if (directory == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(2);
                }
                VirtualFile origDirectory = directory.getVirtualFile();
                ChangedVirtualDirectory changedDirectory = new ChangedVirtualDirectory(origDirectory);
                return new ChangedDirectoryInfo(changedDirectory, PsiDirectoryFactory.getInstance((Project)directory.getProject()).createDirectory((VirtualFile)changedDirectory));
            }

            @NotNull
            Stream<ModCommand> createFileCommands(@NotNull Project project) {
                if (project == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(3);
                }
                PsiManager manager = PsiManager.getInstance((Project)project);
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                ChangedVirtualDirectory root = this.directory();
                HashMap<ChangedVirtualDirectory, VirtualFile> mapping = new HashMap<ChangedVirtualDirectory, VirtualFile>();
                mapping.put(root, root.getOriginalFile());
                StreamEx streamEx = ((StreamEx)StreamEx.ofTree((Object)((Object)root), ChangedVirtualDirectory.class, vf -> StreamEx.ofValues(vf.getAddedChildren())).skip(1L)).map(vf -> {
                    if (vf.isDirectory()) {
                        FutureVirtualFile file = new FutureVirtualFile((VirtualFile)mapping.get(vf.getParent()), vf.getName(), null);
                        mapping.put((ChangedVirtualDirectory)((Object)vf), (VirtualFile)file);
                        return new ModCreateFile(file, (ModCreateFile.Content)new ModCreateFile.Directory());
                    }
                    PsiFile psiFile = manager.findFile((VirtualFile)vf);
                    if (psiFile == null) {
                        return ModCommand.nop();
                    }
                    Document document = psiFile.getViewProvider().getDocument();
                    documentManager.commitDocument(document);
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    return new ModCreateFile(new FutureVirtualFile((VirtualFile)mapping.get(vf.getParent()), vf.getName(), vf.getFileType()), (ModCreateFile.Content)new ModCreateFile.Text(psiFile.getText()));
                });
                if (streamEx == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(4);
                }
                return streamEx;
            }

            @NotNull
            public ChangedVirtualDirectory directory() {
                ChangedVirtualDirectory changedVirtualDirectory = this.directory;
                if (changedVirtualDirectory == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(5);
                }
                return changedVirtualDirectory;
            }

            @NotNull
            public PsiDirectory psiDirectory() {
                PsiDirectory psiDirectory = this.psiDirectory;
                if (psiDirectory == null) {
                    ChangedDirectoryInfo.$$$reportNull$$$0(6);
                }
                return psiDirectory;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiDirectory";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl$ChangedDirectoryInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl$ChangedDirectoryInfo";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createFileCommands";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "directory";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "psiDirectory";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createFileCommands";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4, 5, 6 -> new IllegalStateException(string);
                };
            }
        }

        private class DummyContext
        implements ExpressionContext {
            private final TextRange myRange;
            @NotNull
            private final PsiElement myElement;

            private DummyContext(@NotNull TextRange range, PsiElement element) {
                if (element == null) {
                    DummyContext.$$$reportNull$$$0(0);
                }
                this.myRange = range;
                this.myElement = element;
            }

            public Project getProject() {
                return ModPsiUpdaterImpl.this.myActionContext.project();
            }

            @Nullable
            public Editor getEditor() {
                return null;
            }

            public int getStartOffset() {
                return this.myRange.getStartOffset();
            }

            public int getTemplateStartOffset() {
                return this.myRange.getStartOffset();
            }

            public int getTemplateEndOffset() {
                return this.myRange.getEndOffset();
            }

            public <T> T getProperty(Key<T> key) {
                return null;
            }

            @Nullable
            public PsiElement getPsiElementAtStartOffset() {
                return this.myElement.isValid() ? this.myElement : null;
            }

            @Nullable
            public TextResult getVariableValue(String variableName) {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/impl/modcommand/PsiUpdateImpl$ModPsiUpdaterImpl$DummyContext", "<init>"));
            }
        }
    }

    private static class FileTracker
    implements DocumentListener,
    Disposable {
        @Nullable
        private final PsiLanguageInjectionHost myInjectionHost;
        @NotNull
        private final PsiFile myTargetFile;
        @NotNull
        private final Document myPositionDocument;
        @NotNull
        private final List<ModUpdateFileText.Fragment> myFragments;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final String myOrigText;
        @NotNull
        private final PsiFile myOrigFile;
        @NotNull
        private final PsiFile myCopyFile;
        @NotNull
        private final PsiDocumentManager myManager;
        private boolean myDeleted;
        private boolean myGuardModification;

        FileTracker(@NotNull PsiFile origFile, @NotNull Map<PsiFile, FileTracker> changedFiles) {
            if (origFile == null) {
                FileTracker.$$$reportNull$$$0(0);
            }
            if (changedFiles == null) {
                FileTracker.$$$reportNull$$$0(1);
            }
            this.myFragments = new ArrayList<ModUpdateFileText.Fragment>();
            Project project = origFile.getProject();
            this.myCopyFile = PsiUpdateImpl.copyFile(project, origFile);
            PsiFileImplUtil.setNonPhysicalFileDeleteHandler((PsiFile)this.myCopyFile, f -> {
                this.myDeleted = true;
            });
            this.myDocument = this.myCopyFile.getViewProvider().getDocument();
            assert (!this.myCopyFile.getViewProvider().isEventSystemEnabled()) : "Event system for " + this.myCopyFile.getName();
            InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)project);
            boolean injected = injectionManager.isInjectedFragment(origFile);
            if (injected) {
                PsiLanguageInjectionHost host;
                this.myInjectionHost = host = Objects.requireNonNull(injectionManager.getInjectionHost((PsiElement)origFile));
                PsiFile hostFile = host.getContainingFile();
                FileTracker hostTracker = changedFiles.get(hostFile);
                PsiFile hostFileCopy = hostTracker != null ? hostTracker.myTargetFile : (PsiFile)hostFile.copy();
                PsiFile injectedFileCopy = PsiUpdateImpl.getInjectedFileCopy(host, hostFileCopy, origFile.getLanguage());
                Disposable disposable = ((InjectionEditService)ApplicationManager.getApplication().getService(InjectionEditService.class)).synchronizeWithFragment(injectedFileCopy, this.myDocument);
                this.myDocument.addDocumentListener(new DocumentListener(){

                    public void beforeDocumentChange(@NotNull DocumentEvent event) {
                        RangeMarker guard;
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((guard = myDocument.getRangeGuard(event.getOffset(), event.getOffset() + event.getOldLength())) != null) {
                            myGuardModification = true;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/impl/modcommand/PsiUpdateImpl$FileTracker$1", "beforeDocumentChange"));
                    }
                }, (Disposable)this);
                Disposer.register((Disposable)this, (Disposable)disposable);
                this.myTargetFile = hostFileCopy;
                origFile = hostFile;
                this.myPositionDocument = hostFileCopy.getViewProvider().getDocument();
            } else {
                this.myInjectionHost = null;
                this.myTargetFile = this.myCopyFile;
                this.myPositionDocument = this.myDocument;
            }
            this.myPositionDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
            this.myOrigText = this.myTargetFile.getText();
            this.myOrigFile = origFile;
            this.myManager = PsiDocumentManager.getInstance((Project)project);
            PostprocessReformattingAspect.getInstance((Project)project).forcePostprocessFormat(this.myCopyFile, (Disposable)this);
        }

        @Nullable
        PsiLanguageInjectionHost getHostCopy() {
            return (PsiLanguageInjectionHost)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myInjectionHost, (PsiFile)this.myTargetFile);
        }

        void unblock() {
            this.myManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
        }

        ModCommand getUpdateCommand() {
            VirtualFile origVirtualFile = this.myOrigFile.getOriginalFile().getVirtualFile();
            if (origVirtualFile == null) {
                return new ModNothing();
            }
            if (this.myDeleted) {
                return new ModDeleteFile(origVirtualFile);
            }
            this.myManager.commitDocument(this.myDocument);
            this.unblock();
            String newText = this.myTargetFile.getFileDocument().getText();
            return this.myOrigText.equals(newText) ? new ModNothing() : new ModUpdateFileText(origVirtualFile, this.myOrigText, newText, this.myFragments);
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                FileTracker.$$$reportNull$$$0(2);
            }
            this.recordFragment(new ModUpdateFileText.Fragment(event.getOffset(), event.getOldLength(), event.getNewLength()));
        }

        private void recordFragment(@NotNull ModUpdateFileText.Fragment newFragment) {
            List<ModUpdateFileText.Fragment> intersected;
            if (newFragment == null) {
                FileTracker.$$$reportNull$$$0(3);
            }
            int insertionPoint = 0;
            int intersect = 0;
            for (int i = this.myFragments.size() - 1; i >= 0; --i) {
                ModUpdateFileText.Fragment fragment = this.myFragments.get(i);
                if (fragment.offset() > newFragment.offset() + newFragment.oldLength()) {
                    this.myFragments.set(i, fragment.shift(newFragment.newLength() - newFragment.oldLength()));
                    continue;
                }
                if (fragment.intersects(newFragment)) {
                    ++intersect;
                    continue;
                }
                insertionPoint = i + 1;
                break;
            }
            if (!(intersected = this.myFragments.subList(insertionPoint, insertionPoint + intersect)).isEmpty()) {
                ModUpdateFileText.Fragment first = intersected.get(0);
                ModUpdateFileText.Fragment last = intersected.get(intersected.size() - 1);
                int diff = intersected.stream().mapToInt(f -> f.newLength() - f.oldLength()).sum();
                ModUpdateFileText.Fragment mergedFragment = new ModUpdateFileText.Fragment(first.offset(), last.offset() + last.newLength() - diff - first.offset(), last.offset() + last.newLength() - first.offset());
                newFragment = mergedFragment.mergeWithNext(newFragment);
            }
            intersected.clear();
            intersected.add(newFragment);
        }

        public void dispose() {
        }

        @NotNull
        <E extends PsiElement> E getCopy(@NotNull E orig) {
            if (orig == null) {
                FileTracker.$$$reportNull$$$0(4);
            }
            if (this.myDeleted) {
                throw new IllegalStateException("The file was deleted.");
            }
            if (orig == this.myOrigFile) {
                PsiFile file;
                PsiFile psiFile = file = this.myCopyFile;
                if (psiFile == null) {
                    FileTracker.$$$reportNull$$$0(5);
                }
                return (E)psiFile;
            }
            if (!this.myFragments.isEmpty()) {
                throw new IllegalStateException("File is already modified. Elements to update must be requested before any modifications");
            }
            PsiElement psiElement = PsiTreeUtil.findSameElementInCopy(orig, (PsiFile)this.myCopyFile);
            if (psiElement == null) {
                FileTracker.$$$reportNull$$$0(6);
            }
            return (E)psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changedFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newFragment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orig";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$FileTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/impl/modcommand/PsiUpdateImpl$FileTracker";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "documentChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "recordFragment";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCopy";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

