/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.ModuleContext;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ResolveScopeManagerImpl
extends ResolveScopeManager
implements Disposable {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<Pair<VirtualFile, CodeInsightContext>, GlobalSearchScope> myDefaultResolveScopesCache;
    private final AdditionalIndexableFileSet myAdditionalIndexableFileSet;

    public ResolveScopeManagerImpl(Project project) {
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myManager = PsiManager.getInstance((Project)project);
        this.myAdditionalIndexableFileSet = new AdditionalIndexableFileSet(project);
        this.myDefaultResolveScopesCache = ConcurrentFactoryMap.create(key -> (GlobalSearchScope)ReadAction.compute(() -> this.createScopeByFile((Pair<VirtualFile, CodeInsightContext>)key)), () -> CollectionFactory.createConcurrentWeakKeySoftValueMap());
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    ResolveScopeManagerImpl.this.myDefaultResolveScopesCache.clear();
                }
            }
        });
        ResolveScopeProvider.EP_NAME.addChangeListener(() -> this.myDefaultResolveScopesCache.clear(), (Disposable)this);
        ResolveScopeEnlarger.EP_NAME.addChangeListener(() -> this.myDefaultResolveScopesCache.clear(), (Disposable)this);
    }

    @NotNull
    private GlobalSearchScope createScopeByFile(@NotNull Pair<VirtualFile, CodeInsightContext> key) {
        ResolveScopeProvider resolveScopeProvider;
        if (key == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(0);
        }
        VirtualFile original = VirtualFileUtil.originalFile((VirtualFile)((VirtualFile)key.first));
        VirtualFile file = (VirtualFile)ObjectUtils.notNull((Object)original, (Object)((VirtualFile)key.first));
        CodeInsightContext context = (CodeInsightContext)key.second;
        GlobalSearchScope scope = null;
        Iterator iterator = ResolveScopeProvider.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (scope = (resolveScopeProvider = (ResolveScopeProvider)iterator.next()).getResolveScope(file, context, this.myProject)) == null) {
        }
        if (scope == null) {
            scope = this.getInherentResolveScope(file);
        }
        for (ResolveScopeEnlarger enlarger : ResolveScopeEnlarger.EP_NAME.getExtensionList()) {
            SearchScope extra = enlarger.getAdditionalResolveScope(file, context, this.myProject);
            if (extra == null) continue;
            scope = scope.union(extra);
        }
        if (original != null && !scope.contains((VirtualFile)key.first)) {
            scope = scope.union((SearchScope)GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)((VirtualFile)key.first)));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getResolveScopeFromProviders(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context) {
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(3);
        }
        GlobalSearchScope globalSearchScope = this.myDefaultResolveScopesCache.get(Pair.create((Object)vFile, (Object)context));
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getInherentResolveScope(@NotNull VirtualFile vFile) {
        ProjectFileIndex projectFileIndex;
        Module module;
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(5);
        }
        if ((module = (projectFileIndex = this.myProjectRootManager.getFileIndex()).getModuleForFile(vFile)) != null) {
            boolean includeTests = TestSourcesFilter.isTestSources((VirtualFile)vFile, (Project)this.myProject);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        if (!projectFileIndex.isInLibrary(vFile)) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (!allScope.contains(vFile)) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)vFile).uniteWith(allScope);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(7);
                }
                return globalSearchScope;
            }
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = LibraryScopeCache.getInstance(this.myProject).getLibraryScope(vFile);
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        PsiElement context;
        PsiCodeFragment fragment;
        GlobalSearchScope forcedScope;
        if (element == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(10);
        }
        ProgressIndicatorProvider.checkCanceled();
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return this.getResolveScopeFromProviders(directory.getVirtualFile(), CodeInsightContexts.anyContext());
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiCodeFragment && (forcedScope = (fragment = (PsiCodeFragment)containingFile).getForcedResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = forcedScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        if (containingFile != null && (context = containingFile.getContext()) != null) {
            GlobalSearchScope globalSearchScope = this.withFile(containingFile, this.getResolveScope(context));
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }
        if (containingFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        return this.getPsiFileResolveScope(containingFile);
    }

    @NotNull
    private GlobalSearchScope getPsiFileResolveScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(14);
        }
        if (psiFile instanceof FileResolveScopeProvider) {
            FileResolveScopeProvider provider = (FileResolveScopeProvider)psiFile;
            GlobalSearchScope globalSearchScope = provider.getFileResolveScope();
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        if (!psiFile.getOriginalFile().isPhysical() && !psiFile.getViewProvider().isPhysical()) {
            GlobalSearchScope globalSearchScope = this.withFile(psiFile, GlobalSearchScope.allScope((Project)this.myProject));
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(16);
            }
            return globalSearchScope;
        }
        return this.getResolveScopeFromProviders(psiFile.getViewProvider().getVirtualFile(), CodeInsightContextUtil.getCodeInsightContext((PsiFile)psiFile));
    }

    private GlobalSearchScope withFile(PsiFile containingFile, GlobalSearchScope scope) {
        return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)containingFile) ? scope : scope.uniteWith(GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)containingFile.getViewProvider().getVirtualFile()));
    }

    @NotNull
    public GlobalSearchScope getDefaultResolveScope(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(17);
        }
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null) : "directory=" + vFile.isDirectory() + "; " + String.valueOf(this.myProject) + "; vFile=" + String.valueOf(vFile) + "; type=" + String.valueOf(vFile.getFileType());
        return this.getResolveScopeFromProviders(vFile, CodeInsightContexts.anyContext());
    }

    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        FileViewProvider fileViewProvider;
        PsiFile containingFile;
        VirtualFile virtualFile;
        VirtualFile vDirectory;
        if (element == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(18);
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            vDirectory = directory.getVirtualFile();
            virtualFile = null;
            containingFile = null;
            fileViewProvider = null;
        } else {
            containingFile = element.getContainingFile();
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(19);
                }
                return globalSearchScope;
            }
            fileViewProvider = containingFile.getViewProvider();
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(20);
                }
                return globalSearchScope;
            }
            if (virtualFile instanceof VirtualFileWindow) {
                VirtualFileWindow window = (VirtualFileWindow)virtualFile;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)window.getDelegate());
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(21);
                }
                return globalSearchScope;
            }
            if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)virtualFile);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(22);
                }
                return globalSearchScope;
            }
            vDirectory = virtualFile.getParent();
        }
        if (vDirectory == null) {
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(23);
            }
            return globalSearchScope;
        }
        VirtualFile notNullVFile = virtualFile != null ? virtualFile : vDirectory;
        Module module = this.findModule(fileViewProvider, notNullVFile);
        if (module == null) {
            ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
            List entries = projectFileIndex.getOrderEntriesForFile(notNullVFile);
            if (entries.isEmpty() && (WorkspaceFileIndex.getInstance((Project)this.myProject).findFileSet(notNullVFile, true, false, false, true, true, true) != null || this.myAdditionalIndexableFileSet.isInSet(notNullVFile))) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(24);
                }
                return globalSearchScope;
            }
            GlobalSearchScope result = LibraryScopeCache.getInstance(this.myProject).getLibraryUseScope(notNullVFile);
            GlobalSearchScope globalSearchScope = containingFile == null || virtualFile.isDirectory() || result.contains(virtualFile) ? result : GlobalSearchScope.fileScope((PsiFile)containingFile).uniteWith(result);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(25);
            }
            return globalSearchScope;
        }
        boolean isTest = TestSourcesFilter.isTestSources((VirtualFile)vDirectory, (Project)this.myProject);
        GlobalSearchScope globalSearchScope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(26);
        }
        return globalSearchScope;
    }

    @Nullable
    private Module findModule(@Nullable FileViewProvider fileViewProvider, @NotNull VirtualFile notNullVFile) {
        CodeInsightContext context;
        if (notNullVFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(27);
        }
        if (fileViewProvider != null && CodeInsightContexts.isSharedSourceSupportEnabled((Project)this.myProject) && (context = CodeInsightContextUtil.getCodeInsightContext((FileViewProvider)fileViewProvider)) instanceof ModuleContext) {
            ModuleContext moduleContext = (ModuleContext)context;
            return moduleContext.getModule();
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        return projectFileIndex.getModuleForFile(notNullVFile);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7, 8, 9, 11, 12, 13, 15, 16, 19, 20, 21, 22, 23, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl";
                break;
            }
            case 2: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notNullVFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeByFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScopeFromProviders";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherentResolveScope";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFileResolveScope";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeByFile";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopeFromProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInherentResolveScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileResolveScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResolveScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7, 8, 9, 11, 12, 13, 15, 16, 19, 20, 21, 22, 23, 24, 25, 26 -> new IllegalStateException(string);
        };
    }
}

