/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BatchConsumer;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.group.GroupedCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.Consumer;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionResultSet
implements Consumer<LookupElement> {
    private final PrefixMatcher prefixMatcher;
    private final java.util.function.Consumer<? super CompletionResult> consumer;
    protected final CompletionService myCompletionService;
    @ApiStatus.Internal
    @Nullable
    public final CompletionContributor contributor;
    private boolean myStopped;

    protected CompletionResultSet(@NotNull PrefixMatcher prefixMatcher, @NotNull java.util.function.Consumer<? super CompletionResult> consumer, @Nullable CompletionContributor contributor) {
        if (prefixMatcher == null) {
            CompletionResultSet.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CompletionResultSet.$$$reportNull$$$0(1);
        }
        this.myCompletionService = CompletionService.getCompletionService();
        this.prefixMatcher = prefixMatcher;
        this.consumer = consumer;
        this.contributor = contributor;
    }

    @ApiStatus.Internal
    public java.util.function.Consumer<? super CompletionResult> getConsumer() {
        return this.consumer;
    }

    public void consume(LookupElement element) {
        this.addElement(element);
    }

    public abstract void addElement(@NotNull LookupElement var1);

    public void passResult(@NotNull CompletionResult result) {
        if (result == null) {
            CompletionResultSet.$$$reportNull$$$0(2);
        }
        this.consumer.accept(result);
    }

    public void startBatch() {
        java.util.function.Consumer<? super CompletionResult> consumer = this.consumer;
        if (consumer instanceof BatchConsumer) {
            BatchConsumer batch = (BatchConsumer)((Object)consumer);
            batch.startBatch();
        }
    }

    public void endBatch() {
        java.util.function.Consumer<? super CompletionResult> consumer = this.consumer;
        if (consumer instanceof BatchConsumer) {
            BatchConsumer batch = (BatchConsumer)((Object)consumer);
            batch.endBatch();
        }
    }

    public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
        if (elements == null) {
            CompletionResultSet.$$$reportNull$$$0(3);
        }
        this.startBatch();
        int seldomCounter = 0;
        for (LookupElement lookupElement : elements) {
            this.addElement(lookupElement);
            if (++seldomCounter % 1000 != 0) continue;
            ProgressManager.checkCanceled();
        }
        this.endBatch();
    }

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher var1);

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull String var1);

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter var1);

    public abstract void addLookupAdvertisement(@NlsContexts.PopupAdvertisement @NotNull String var1);

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet caseInsensitive();

    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.prefixMatcher;
        if (prefixMatcher == null) {
            CompletionResultSet.$$$reportNull$$$0(4);
        }
        return prefixMatcher;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public void stopHere() {
        this.myStopped = true;
    }

    @NotNull
    public LinkedHashSet<CompletionResult> runRemainingContributors(@NotNull CompletionParameters parameters, boolean passResult) {
        if (parameters == null) {
            CompletionResultSet.$$$reportNull$$$0(5);
        }
        LinkedHashSet<CompletionResult> elements = new LinkedHashSet<CompletionResult>();
        this.runRemainingContributors(parameters, (Consumer<? super CompletionResult>)((Consumer)result -> {
            if (passResult) {
                this.passResult((CompletionResult)result);
            }
            elements.add((CompletionResult)result);
        }));
        LinkedHashSet<CompletionResult> linkedHashSet = elements;
        if (linkedHashSet == null) {
            CompletionResultSet.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    public void runRemainingContributors(@NotNull CompletionParameters parameters, @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            CompletionResultSet.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            CompletionResultSet.$$$reportNull$$$0(8);
        }
        this.runRemainingContributors(parameters, consumer, true);
    }

    public void runRemainingContributors(@NotNull CompletionParameters parameters, @NotNull Consumer<? super CompletionResult> consumer, boolean stop) {
        if (parameters == null) {
            CompletionResultSet.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            CompletionResultSet.$$$reportNull$$$0(10);
        }
        this.runRemainingContributors(parameters, consumer, stop, null);
    }

    public void runRemainingContributors(@NotNull CompletionParameters parameters, final @NotNull Consumer<? super CompletionResult> consumer, boolean stop, @Nullable CompletionSorter customSorter) {
        GroupedCompletionContributor groupedCompletionContributor;
        CompletionContributor completionContributor;
        if (parameters == null) {
            CompletionResultSet.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            CompletionResultSet.$$$reportNull$$$0(12);
        }
        if (GroupedCompletionContributor.isGroupEnabledInApp() && (completionContributor = this.contributor) instanceof GroupedCompletionContributor && (groupedCompletionContributor = (GroupedCompletionContributor)((Object)completionContributor)).groupIsEnabled(parameters)) {
            return;
        }
        if (stop) {
            this.stopHere();
        }
        this.myCompletionService.getVariantsFromContributors(parameters, this.contributor, this.getPrefixMatcher(), (Consumer<? super CompletionResult>)new BatchConsumer<CompletionResult>(){

            @Override
            public void startBatch() {
                CompletionResultSet.this.startBatch();
            }

            @Override
            public void endBatch() {
                CompletionResultSet.this.endBatch();
            }

            public void consume(CompletionResult result) {
                consumer.consume((Object)result);
            }
        }, customSorter);
    }

    public void restartCompletionOnPrefixChange(@NotNull String prefix) {
        if (prefix == null) {
            CompletionResultSet.$$$reportNull$$$0(13);
        }
        this.restartCompletionOnPrefixChange((ElementPattern<String>)StandardPatterns.string().equalTo((Object)prefix));
    }

    public abstract void restartCompletionOnPrefixChange(@NotNull ElementPattern<String> var1);

    public void restartCompletionOnAnyPrefixChange() {
        this.restartCompletionOnPrefixChange((ElementPattern<String>)StandardPatterns.string());
    }

    public abstract void restartCompletionWhenNothingMatches();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionResultSet";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionResultSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runRemainingContributors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "passResult";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAllElements";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runRemainingContributors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restartCompletionOnPrefixChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

