/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class InsertionContext {
    public static final OffsetKey TAIL_OFFSET = OffsetKey.create("tailOffset", true);
    private final OffsetMap myOffsetMap;
    private final char myCompletionChar;
    private final LookupElement[] myElements;
    private final PsiFile myPsiFile;
    private final Editor myEditor;
    private Runnable myLaterRunnable;
    private boolean myAddCompletionChar;

    public InsertionContext(@NotNull OffsetMap offsetMap, char completionChar, @NotNull @NotNull LookupElement @NotNull [] elements, @NotNull PsiFile psiFile, @NotNull Editor editor, boolean addCompletionChar) {
        if (offsetMap == null) {
            InsertionContext.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            InsertionContext.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            InsertionContext.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            InsertionContext.$$$reportNull$$$0(3);
        }
        this.myOffsetMap = offsetMap;
        this.myCompletionChar = completionChar;
        this.myElements = elements;
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.setTailOffset(editor.getCaretModel().getOffset());
        this.myAddCompletionChar = addCompletionChar;
    }

    public void setTailOffset(int offset) {
        this.myOffsetMap.addOffset(TAIL_OFFSET, offset);
    }

    public int getTailOffset() {
        return this.myOffsetMap.getOffset(TAIL_OFFSET);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            InsertionContext.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            InsertionContext.$$$reportNull$$$0(5);
        }
        return editor;
    }

    public void commitDocument() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(this.getDocument());
    }

    @NotNull
    public Document getDocument() {
        Document document = this.getEditor().getDocument();
        if (document == null) {
            InsertionContext.$$$reportNull$$$0(6);
        }
        return document;
    }

    public int getOffset(@NotNull OffsetKey key) {
        if (key == null) {
            InsertionContext.$$$reportNull$$$0(7);
        }
        return this.getOffsetMap().getOffset(key);
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            InsertionContext.$$$reportNull$$$0(8);
        }
        return offsetMap;
    }

    @NotNull
    public OffsetKey trackOffset(int offset, boolean movableToRight) {
        OffsetKey key = OffsetKey.create("tracked", movableToRight);
        this.getOffsetMap().addOffset(key, offset);
        OffsetKey offsetKey = key;
        if (offsetKey == null) {
            InsertionContext.$$$reportNull$$$0(9);
        }
        return offsetKey;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.START_OFFSET);
    }

    public char getCompletionChar() {
        return this.myCompletionChar;
    }

    @NotNull
    public @NotNull LookupElement @NotNull [] getElements() {
        if (this.myElements == null) {
            InsertionContext.$$$reportNull$$$0(10);
        }
        return this.myElements;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPsiFile.getProject();
        if (project == null) {
            InsertionContext.$$$reportNull$$$0(11);
        }
        return project;
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    @Nullable
    public Runnable getLaterRunnable() {
        return this.myLaterRunnable;
    }

    public void setLaterRunnable(@Nullable Runnable laterRunnable) {
        this.myLaterRunnable = laterRunnable;
    }

    public void setAddCompletionChar(boolean addCompletionChar) {
        this.myAddCompletionChar = addCompletionChar;
    }

    public boolean shouldAddCompletionChar() {
        return this.myAddCompletionChar;
    }

    public static boolean shouldAddCompletionChar(char completionChar) {
        return completionChar != '\u0000' && completionChar != '\t' && completionChar != '\n';
    }

    @NotNull
    public InsertionContext forkByOffsetMap() {
        return new InsertionContext(this.myOffsetMap.copyOffsets(this.myEditor.getDocument()), this.myCompletionChar, this.myElements, this.myPsiFile, this.myEditor, this.myAddCompletionChar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/InsertionContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/InsertionContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "trackOffset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

