/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;

public abstract class BasicUndoableAction
implements UndoableAction {
    private final DocumentReference[] myRefs;
    private long myPerformedTimestamp;

    public BasicUndoableAction() {
        this.myPerformedTimestamp = -1L;
        this.myRefs = null;
    }

    public BasicUndoableAction(DocumentReference ... refs) {
        this.myPerformedTimestamp = -1L;
        this.myRefs = refs;
    }

    public BasicUndoableAction(Document ... docs) {
        if (docs == null) {
            BasicUndoableAction.$$$reportNull$$$0(0);
        }
        this.myPerformedTimestamp = -1L;
        this.myRefs = new DocumentReference[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            this.myRefs[i] = DocumentReferenceManager.getInstance().create(docs[i]);
        }
    }

    public BasicUndoableAction(VirtualFile ... files) {
        if (files == null) {
            BasicUndoableAction.$$$reportNull$$$0(1);
        }
        this.myPerformedTimestamp = -1L;
        this.myRefs = new DocumentReference[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.myRefs[i] = DocumentReferenceManager.getInstance().create(files[i]);
        }
    }

    @Override
    public DocumentReference[] getAffectedDocuments() {
        return this.myRefs;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public long getPerformedNanoTime() {
        return this.myPerformedTimestamp;
    }

    @Override
    public void setPerformedNanoTime(long l) {
        this.myPerformedTimestamp = l;
    }

    public String toString() {
        return "%s{refs=%s%s}".formatted(this.getClass().getName().replace(this.getClass().getPackageName() + ".", ""), Arrays.toString(this.getAffectedDocuments()), this.isGlobal() ? ", global" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "docs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "files";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/command/undo/BasicUndoableAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

