/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBackedByIntentionAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class Annotation
implements Segment {
    private final int myStartOffset;
    private final int myEndOffset;
    @NotNull
    private final HighlightSeverity mySeverity;
    private final @NlsContexts.DetailedDescription String myMessage;
    @NotNull
    @NotNull List<@NotNull Consumer<? super QuickFixActionRegistrar>> myLazyQuickFixes;
    private ProblemHighlightType myHighlightType;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes;
    private @NlsContexts.Tooltip String myTooltip;
    private boolean myAfterEndOfLine;
    private boolean myIsFileLevelAnnotation;
    private GutterIconRenderer myGutterIconRenderer;
    @Nullable
    private ProblemGroup myProblemGroup;
    private List<QuickFixInfo> myBatchFixes;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public Annotation(int startOffset, int endOffset, @NotNull HighlightSeverity severity, @NlsContexts.DetailedDescription @Nullable String message, @NlsContexts.Tooltip @Nullable String tooltip) {
        if (severity == null) {
            Annotation.$$$reportNull$$$0(0);
        }
        this.myLazyQuickFixes = List.of();
        this.myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        assert (startOffset <= endOffset) : startOffset + ":" + endOffset;
        assert (startOffset >= 0) : "Start offset must not be negative: " + startOffset;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            Annotation.$$$reportNull$$$0(1);
        }
        this.registerFix(fix, null);
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction fix, TextRange range) {
        if (fix == null) {
            Annotation.$$$reportNull$$$0(2);
        }
        this.registerFix(fix, range, null);
    }

    @Deprecated
    public void registerFix(@NotNull LocalQuickFix fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix == null) {
            Annotation.$$$reportNull$$$0(3);
        }
        if (problemDescriptor == null) {
            Annotation.$$$reportNull$$$0(4);
        }
        range = this.notNullize(range);
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(QuickFixWrapper.wrap(problemDescriptor, fix), fix, range, key));
    }

    @Deprecated
    public void registerFix(@NotNull IntentionAction fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix == null) {
            Annotation.$$$reportNull$$$0(5);
        }
        range = this.notNullize(range);
        List<QuickFixInfo> fixes = this.myQuickFixes;
        if (fixes == null) {
            this.myQuickFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(fix, range, key));
    }

    @NotNull
    private TextRange notNullize(@Nullable TextRange range) {
        TextRange textRange = range == null ? new TextRange(this.myStartOffset, this.myEndOffset) : range;
        if (textRange == null) {
            Annotation.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Deprecated
    public <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull T fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix == null) {
            Annotation.$$$reportNull$$$0(7);
        }
        this.registerBatchFix(fix, fix, range, key);
    }

    @Deprecated
    @ApiStatus.Internal
    public void registerBatchFix(@NotNull IntentionAction action, @NotNull LocalQuickFix fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (action == null) {
            Annotation.$$$reportNull$$$0(8);
        }
        if (fix == null) {
            Annotation.$$$reportNull$$$0(9);
        }
        range = this.notNullize(range);
        List<QuickFixInfo> fixes = this.myBatchFixes;
        if (fixes == null) {
            this.myBatchFixes = fixes = new ArrayList<QuickFixInfo>();
        }
        fixes.add(new QuickFixInfo(action, fix, range, key));
    }

    @Deprecated
    public <T extends IntentionAction & LocalQuickFix> void registerUniversalFix(@NotNull T fix, @Nullable TextRange range, @Nullable HighlightDisplayKey key) {
        if (fix == null) {
            Annotation.$$$reportNull$$$0(10);
        }
        this.registerBatchFix(fix, range, key);
        this.registerFix(fix, range, key);
    }

    @Deprecated(forRemoval=true)
    public void setNeedsUpdateOnTyping(boolean __) {
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            Annotation.$$$reportNull$$$0(11);
        }
        return highlightSeverity;
    }

    @NotNull
    public ProblemHighlightType getHighlightType() {
        ProblemHighlightType problemHighlightType = this.myHighlightType;
        if (problemHighlightType == null) {
            Annotation.$$$reportNull$$$0(12);
        }
        return problemHighlightType;
    }

    @NotNull
    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            TextAttributesKey textAttributesKey = this.myEnforcedAttributesKey;
            if (textAttributesKey == null) {
                Annotation.$$$reportNull$$$0(13);
            }
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = switch (this.myHighlightType) {
            case ProblemHighlightType.GENERIC_ERROR_OR_WARNING -> {
                if (this.mySeverity == HighlightSeverity.ERROR) {
                    yield CodeInsightColors.ERRORS_ATTRIBUTES;
                }
                if (this.mySeverity == HighlightSeverity.WARNING) {
                    yield CodeInsightColors.WARNINGS_ATTRIBUTES;
                }
                if (this.mySeverity == HighlightSeverity.WEAK_WARNING) {
                    yield CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                }
                yield HighlighterColors.NO_HIGHLIGHTING;
            }
            case ProblemHighlightType.GENERIC_ERROR -> CodeInsightColors.ERRORS_ATTRIBUTES;
            case ProblemHighlightType.LIKE_DEPRECATED -> CodeInsightColors.DEPRECATED_ATTRIBUTES;
            case ProblemHighlightType.LIKE_UNUSED_SYMBOL -> CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
            case ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, ProblemHighlightType.ERROR -> CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
            default -> HighlighterColors.NO_HIGHLIGHTING;
        };
        if (textAttributesKey == null) {
            Annotation.$$$reportNull$$$0(14);
        }
        return textAttributesKey;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    @Deprecated
    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    @Nullable
    public @Unmodifiable List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes == null ? null : Collections.unmodifiableList(this.myQuickFixes);
    }

    @Nullable
    public @Unmodifiable List<QuickFixInfo> getBatchFixes() {
        return this.myBatchFixes == null ? null : Collections.unmodifiableList(this.myBatchFixes);
    }

    @NlsContexts.DetailedDescription
    public String getMessage() {
        return this.myMessage;
    }

    @NlsContexts.Tooltip
    public String getTooltip() {
        return this.myTooltip;
    }

    @Deprecated
    public void setTooltip(@NlsContexts.Tooltip String tooltip) {
        this.myTooltip = tooltip;
    }

    @Deprecated
    public void setHighlightType(@NotNull ProblemHighlightType highlightType) {
        if (highlightType == null) {
            Annotation.$$$reportNull$$$0(15);
        }
        this.myHighlightType = highlightType;
    }

    @Deprecated
    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    @Deprecated
    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    @Deprecated
    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    @Nullable
    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    @Deprecated
    public void setGutterIconRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    @NonNls
    public String toString() {
        return "Annotation(message='" + this.myMessage + "', severity='" + String.valueOf(this.mySeverity) + "', toolTip='" + this.myTooltip + "')";
    }

    @ApiStatus.Internal
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull Consumer<? super QuickFixActionRegistrar>> getLazyQuickFixes() {
        List<Consumer<? super QuickFixActionRegistrar>> list = this.myLazyQuickFixes;
        if (list == null) {
            Annotation.$$$reportNull$$$0(16);
        }
        return list;
    }

    @ApiStatus.Internal
    public void registerLazyQuickFixes(@NotNull @NotNull @Unmodifiable List<@NotNull Consumer<? super QuickFixActionRegistrar>> lazyQuickFixes) {
        if (lazyQuickFixes == null) {
            Annotation.$$$reportNull$$$0(17);
        }
        this.myLazyQuickFixes = lazyQuickFixes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/annotation/Annotation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/annotation/Annotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerBatchFix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerUniversalFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerLazyQuickFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 12, 13, 14, 16 -> new IllegalStateException(string);
        };
    }

    public static final class QuickFixInfo {
        @NotNull
        public final IntentionAction quickFix;
        @NotNull
        private final LocalQuickFix localQuickFix;
        @NotNull
        public final TextRange textRange;
        public final HighlightDisplayKey key;

        QuickFixInfo(@NotNull IntentionAction fix, @NotNull TextRange range, @Nullable HighlightDisplayKey key) {
            LocalQuickFix localQuickFix;
            if (fix == null) {
                QuickFixInfo.$$$reportNull$$$0(0);
            }
            if (range == null) {
                QuickFixInfo.$$$reportNull$$$0(1);
            }
            if (fix instanceof LocalQuickFix) {
                LocalQuickFix lqf = (LocalQuickFix)((Object)fix);
                localQuickFix = lqf;
            } else {
                localQuickFix = new LocalQuickFixBackedByIntentionAction(fix);
            }
            this(fix, localQuickFix, range, key);
        }

        QuickFixInfo(@NotNull IntentionAction fix, @NotNull LocalQuickFix localQuickFix, @NotNull TextRange range, @Nullable HighlightDisplayKey key) {
            if (fix == null) {
                QuickFixInfo.$$$reportNull$$$0(2);
            }
            if (localQuickFix == null) {
                QuickFixInfo.$$$reportNull$$$0(3);
            }
            if (range == null) {
                QuickFixInfo.$$$reportNull$$$0(4);
            }
            this.key = key;
            this.quickFix = fix;
            this.localQuickFix = localQuickFix;
            this.textRange = range;
        }

        public String toString() {
            return this.quickFix.toString();
        }

        @NotNull
        public LocalQuickFix getLocalQuickFix() {
            LocalQuickFix localQuickFix = this.localQuickFix;
            if (localQuickFix == null) {
                QuickFixInfo.$$$reportNull$$$0(5);
            }
            return localQuickFix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/annotation/Annotation$QuickFixInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/annotation/Annotation$QuickFixInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

