/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    @NotNull
    private final Editor myEditor;
    private final int myOffset;
    private final int myInvocationCount;
    private final CompletionProcess myProcess;
    private boolean myIsTestingMode;
    private boolean myCompleteOnlyNotImported;

    private CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, @NotNull CompletionType completionType, int offset, int invocationCount, @NotNull Editor editor, @NotNull CompletionProcess process, boolean isTestingMode, boolean completeOnlyNotImported) {
        if (position == null) {
            CompletionParameters.$$$reportNull$$$0(0);
        }
        if (originalFile == null) {
            CompletionParameters.$$$reportNull$$$0(1);
        }
        if (completionType == null) {
            CompletionParameters.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CompletionParameters.$$$reportNull$$$0(3);
        }
        if (process == null) {
            CompletionParameters.$$$reportNull$$$0(4);
        }
        PsiUtilCore.ensureValid((PsiElement)position);
        assert (position.getTextRange().containsOffset(offset)) : position;
        this.myPosition = position;
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
        this.myEditor = editor;
        this.myProcess = process;
        this.myIsTestingMode = isTestingMode;
        this.myCompleteOnlyNotImported = completeOnlyNotImported;
    }

    @ApiStatus.Internal
    public CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, @NotNull CompletionType completionType, int offset, int invocationCount, @NotNull Editor editor, @NotNull CompletionProcess process) {
        if (position == null) {
            CompletionParameters.$$$reportNull$$$0(5);
        }
        if (originalFile == null) {
            CompletionParameters.$$$reportNull$$$0(6);
        }
        if (completionType == null) {
            CompletionParameters.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            CompletionParameters.$$$reportNull$$$0(8);
        }
        if (process == null) {
            CompletionParameters.$$$reportNull$$$0(9);
        }
        this(position, originalFile, completionType, offset, invocationCount, editor, process, false, false);
    }

    @NotNull
    public CompletionParameters withType(@NotNull CompletionType type) {
        if (type == null) {
            CompletionParameters.$$$reportNull$$$0(10);
        }
        return new CompletionParameters(this.myPosition, this.myOriginalFile, type, this.myOffset, this.myInvocationCount, this.myEditor, this.myProcess, this.myIsTestingMode, this.myCompleteOnlyNotImported);
    }

    @NotNull
    public CompletionParameters withInvocationCount(int newCount) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, this.myCompletionType, this.myOffset, newCount, this.myEditor, this.myProcess, this.myIsTestingMode, this.myCompleteOnlyNotImported);
    }

    @NotNull
    public PsiElement getPosition() {
        PsiElement psiElement = this.myPosition;
        if (psiElement == null) {
            CompletionParameters.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile;
        if (psiFile == null) {
            CompletionParameters.$$$reportNull$$$0(12);
        }
        return psiFile;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            CompletionParameters.$$$reportNull$$$0(13);
        }
        return completionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public boolean isAutoPopup() {
        return this.myInvocationCount == 0;
    }

    @NotNull
    public CompletionParameters withPosition(@NotNull PsiElement element, int offset) {
        if (element == null) {
            CompletionParameters.$$$reportNull$$$0(14);
        }
        return new CompletionParameters(element, this.myOriginalFile, this.myCompletionType, offset, this.myInvocationCount, this.myEditor, this.myProcess, this.myIsTestingMode, this.myCompleteOnlyNotImported);
    }

    public boolean isExtendedCompletion() {
        return this.myCompletionType == CompletionType.BASIC && this.myInvocationCount >= 2;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            CompletionParameters.$$$reportNull$$$0(15);
        }
        return editor;
    }

    @NotNull
    public CompletionProcess getProcess() {
        CompletionProcess completionProcess = this.myProcess;
        if (completionProcess == null) {
            CompletionParameters.$$$reportNull$$$0(16);
        }
        return completionProcess;
    }

    public boolean isTestingMode() {
        return this.myIsTestingMode;
    }

    public void setTestingMode(boolean runTestingMode) {
        this.myIsTestingMode = runTestingMode;
    }

    public boolean isCompleteOnlyNotImported() {
        return this.myCompleteOnlyNotImported;
    }

    public void setCompleteOnlyNotImported(boolean onlyNonImported) {
        this.myCompleteOnlyNotImported = onlyNonImported;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionParameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 15, 16 -> new IllegalStateException(string);
        };
    }
}

