/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupArranger
implements WeighingContext {
    protected final List<LookupElement> myItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myMatchingItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myExactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myInexactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myTopPriorityItems = new ArrayList<LookupElement>();
    private final Key<PrefixMatcher> myMatcherKey = Key.create((String)"LookupArrangerMatcher");
    @Nullable
    private volatile Predicate<LookupElement> myAdditionalMatcher;
    @NotNull
    private volatile String myAdditionalPrefix = "";

    public void addElement(@NotNull LookupElement item, @NotNull LookupElementPresentation presentation) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            LookupArranger.$$$reportNull$$$0(1);
        }
        this.myItems.add(item);
        this.updateCache(item);
    }

    private void updateCache(@NotNull LookupElement item) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(2);
        }
        if (!this.prefixMatches(item)) {
            return;
        }
        this.myMatchingItems.add(item);
        if (this.supportCustomCaches(item)) {
            return;
        }
        if (this.isTopPriorityItem(item)) {
            this.myTopPriorityItems.add(item);
        }
        if (this.isPrefixItem(item, true)) {
            this.myExactPrefixItems.add(item);
        } else if (this.isPrefixItem(item, false)) {
            this.myInexactPrefixItems.add(item);
        }
    }

    @ApiStatus.Internal
    protected boolean supportCustomCaches(@Nullable LookupElement item) {
        return false;
    }

    public void registerMatcher(@NotNull LookupElement item, @NotNull PrefixMatcher matcher) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(3);
        }
        if (matcher == null) {
            LookupArranger.$$$reportNull$$$0(4);
        }
        item.putUserData(this.myMatcherKey, matcher);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public void registerAdditionalMatcher(@NotNull Predicate<LookupElement> matcher) {
        if (matcher == null) {
            LookupArranger.$$$reportNull$$$0(5);
        }
        this.myAdditionalMatcher = matcher;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @Nullable
    public Predicate<LookupElement> getAdditionalMatcher() {
        return this.myAdditionalMatcher;
    }

    @Override
    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            LookupArranger.$$$reportNull$$$0(6);
        }
        String prefix = this.itemMatcher(element).getPrefix();
        String additionalPrefix = this.myAdditionalPrefix;
        Object object = additionalPrefix.isEmpty() ? prefix : prefix + additionalPrefix;
        if (object == null) {
            LookupArranger.$$$reportNull$$$0(7);
        }
        return object;
    }

    @Override
    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        PrefixMatcher matcher;
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(8);
        }
        if ((matcher = (PrefixMatcher)item.getUserData(this.myMatcherKey)) == null) {
            throw new AssertionError((Object)("Item not in lookup: item=" + String.valueOf((Object)item) + "; lookup items=" + String.valueOf(this.myItems)));
        }
        PrefixMatcher prefixMatcher = matcher;
        if (prefixMatcher == null) {
            LookupArranger.$$$reportNull$$$0(9);
        }
        return prefixMatcher;
    }

    private boolean prefixMatches(@NotNull LookupElement item) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(10);
        }
        PrefixMatcher matcher = this.itemMatcher(item);
        Predicate<LookupElement> additionalMatcher = this.myAdditionalMatcher;
        if (additionalMatcher != null && !additionalMatcher.test(item)) {
            return false;
        }
        if (!this.myAdditionalPrefix.isEmpty()) {
            matcher = matcher.cloneWithPrefix(matcher.getPrefix() + this.myAdditionalPrefix);
        }
        return matcher.prefixMatches(item);
    }

    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
    }

    public void prefixReplaced(@NotNull Lookup lookup, @NotNull String newPrefix) {
        if (lookup == null) {
            LookupArranger.$$$reportNull$$$0(11);
        }
        if (newPrefix == null) {
            LookupArranger.$$$reportNull$$$0(12);
        }
        ArrayList<LookupElement> itemCopy = new ArrayList<LookupElement>(this.myItems);
        this.myItems.clear();
        for (LookupElement item : itemCopy) {
            PrefixMatcher matcher;
            if (!item.isValid() || !(matcher = this.itemMatcher(item).cloneWithPrefix(newPrefix)).prefixMatches(item)) continue;
            item.putUserData(this.myMatcherKey, matcher);
            this.myItems.add(item);
        }
        this.prefixChanged(lookup);
    }

    public void prefixChanged(@NotNull Lookup lookup) {
        if (lookup == null) {
            LookupArranger.$$$reportNull$$$0(13);
        }
        this.myAdditionalPrefix = ((LookupElementListPresenter)((Object)lookup)).getAdditionalPrefix();
        this.rebuildItemCache();
    }

    @ApiStatus.Internal
    protected void rebuildItemCache() {
        this.myMatchingItems.clear();
        this.myExactPrefixItems.clear();
        this.myInexactPrefixItems.clear();
        this.myTopPriorityItems.clear();
        for (LookupElement item : this.myItems) {
            this.updateCache(item);
        }
    }

    @ApiStatus.Internal
    protected boolean isTopPriorityItem(@Nullable LookupElement item) {
        return false;
    }

    protected List<LookupElement> retainItems(@NotNull Set<LookupElement> retained) {
        if (retained == null) {
            LookupArranger.$$$reportNull$$$0(14);
        }
        ArrayList<LookupElement> filtered = new ArrayList<LookupElement>();
        ArrayList<LookupElement> removed = new ArrayList<LookupElement>();
        for (LookupElement item : this.myItems) {
            (retained.contains((Object)item) ? filtered : removed).add(item);
        }
        this.myItems.clear();
        this.myItems.addAll(filtered);
        this.rebuildItemCache();
        return removed;
    }

    @NotNull
    public abstract Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup var1, boolean var2);

    @NotNull
    public abstract LookupArranger createEmptyCopy();

    @NotNull
    protected List<LookupElement> getPrefixItems(boolean exactly) {
        List<LookupElement> list = Collections.unmodifiableList(exactly ? this.myExactPrefixItems : this.myInexactPrefixItems);
        if (list == null) {
            LookupArranger.$$$reportNull$$$0(15);
        }
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    protected List<LookupElement> getTopPriorityItems() {
        List<LookupElement> list = Collections.unmodifiableList(this.myTopPriorityItems);
        if (list == null) {
            LookupArranger.$$$reportNull$$$0(16);
        }
        return list;
    }

    protected boolean isPrefixItem(@NotNull LookupElement item, boolean exactly) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(17);
        }
        String pattern = this.itemPattern(item);
        for (String s : item.getAllLookupStrings()) {
            if (!s.equalsIgnoreCase(pattern) || item.isCaseSensitive() && exactly && !s.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<LookupElement> getMatchingItems() {
        List<LookupElement> list = this.myMatchingItems;
        if (list == null) {
            LookupArranger.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            LookupArranger.$$$reportNull$$$0(19);
        }
        Map<LookupElement, List<Pair<String, Object>>> map = Collections.emptyMap();
        if (map == null) {
            LookupArranger.$$$reportNull$$$0(20);
        }
        return map;
    }

    public void prefixTruncated(@NotNull LookupEx lookup, int hideOffset) {
        if (lookup == null) {
            LookupArranger.$$$reportNull$$$0(21);
        }
        lookup.hideLookup(false);
    }

    public boolean isCompletion() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 15, 16, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupArranger";
                break;
            }
            case 11: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retained";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupArranger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "itemPattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "itemMatcher";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixItems";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopPriorityItems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingItems";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerMatcher";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalMatcher";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "itemPattern";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "itemMatcher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prefixReplaced";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prefixChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "retainItems";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixItem";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prefixTruncated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 15, 16, 18, 20 -> new IllegalStateException(string);
        };
    }

    public static class DefaultArranger
    extends LookupArranger {
        @Override
        @NotNull
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                DefaultArranger.$$$reportNull$$$0(0);
            }
            LinkedHashSet<LookupElement> result = new LinkedHashSet<LookupElement>();
            result.addAll(this.getPrefixItems(true));
            result.addAll(this.getPrefixItems(false));
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!CompletionService.isStartMatch(item, this)) continue;
                result.add(item);
            }
            result.addAll(items);
            ArrayList list = new ArrayList(result);
            int selected = !lookup.isSelectionTouched() && onExplicitAction ? 0 : list.indexOf((Object)lookup.getCurrentItem());
            return new Pair(list, (Object)Math.max(selected, 0));
        }

        @Override
        @NotNull
        public LookupArranger createEmptyCopy() {
            return new DefaultArranger();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/LookupArranger$DefaultArranger", "arrangeItems"));
        }
    }
}

