/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ProblemsHolder {
    private static final Logger LOG = Logger.getInstance(ProblemsHolder.class);
    private final InspectionManager myManager;
    private final PsiFile myPsiFile;
    private final boolean myOnTheFly;
    private final List<ProblemDescriptor> myProblems;

    public ProblemsHolder(@NotNull InspectionManager manager, @NotNull PsiFile psiFile, boolean onTheFly) {
        if (manager == null) {
            ProblemsHolder.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            ProblemsHolder.$$$reportNull$$$0(1);
        }
        this.myProblems = new ArrayList<ProblemDescriptor>();
        this.myManager = manager;
        this.myPsiFile = psiFile;
        this.myOnTheFly = onTheFly;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(2);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(3);
        }
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(4);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(5);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(6);
        }
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, descriptionTemplate, this.myOnTheFly, fixes, highlightType));
    }

    public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
        PsiElement psiElement;
        if (problemDescriptor == null) {
            ProblemsHolder.$$$reportNull$$$0(7);
        }
        if ((psiElement = problemDescriptor.getPsiElement()) != null && !this.isInPsiFile(psiElement)) {
            PsiElement newTarget;
            ExternallyDefinedPsiElement external = (ExternallyDefinedPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ExternallyDefinedPsiElement.class, (boolean)false);
            if (external != null && (newTarget = external.getProblemTarget()) != null) {
                this.redirectProblem(problemDescriptor, newTarget);
                return;
            }
            if (this.isOnTheFly()) {
                LOG.error("Inspection generated invalid ProblemDescriptor '" + String.valueOf(problemDescriptor) + "'. It contains PsiElement with getContainingFile(): '" + String.valueOf(psiElement.getContainingFile()) + "' (" + String.valueOf(psiElement.getContainingFile().getClass()) + "); but expected: '" + String.valueOf(this.getFile()) + "' (" + String.valueOf(this.getFile().getClass()) + ")");
            }
        }
        this.saveProblem(problemDescriptor);
    }

    protected void saveProblem(@NotNull ProblemDescriptor problemDescriptor) {
        if (problemDescriptor == null) {
            ProblemsHolder.$$$reportNull$$$0(8);
        }
        this.myProblems.add(problemDescriptor);
    }

    @ApiStatus.Internal
    protected boolean isInPsiFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            ProblemsHolder.$$$reportNull$$$0(9);
        }
        return (file = element.getContainingFile()) != null && this.myPsiFile.getViewProvider() == file.getViewProvider();
    }

    @ApiStatus.Internal
    protected void redirectProblem(@NotNull ProblemDescriptor problem, @NotNull PsiElement target) {
        if (problem == null) {
            ProblemsHolder.$$$reportNull$$$0(10);
        }
        if (target == null) {
            ProblemsHolder.$$$reportNull$$$0(11);
        }
        PsiElement original = problem.getPsiElement();
        VirtualFile vFile = original.getContainingFile().getVirtualFile();
        assert (vFile != null);
        String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
        String description = XmlStringUtil.stripHtml((String)problem.getDescriptionTemplate());
        String template = AnalysisBundle.message("inspection.redirect.template", description, path, original.getTextRange().getStartOffset(), vFile.getName());
        ProblemDescriptor newProblem = this.getManager().createProblemDescriptor(target, template, (LocalQuickFix)null, problem.getHighlightType(), this.isOnTheFly());
        this.registerProblem(newProblem);
    }

    public void registerProblem(@NotNull PsiReference reference, @InspectionMessage String descriptionTemplate, ProblemHighlightType highlightType) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(12);
        }
        LocalQuickFix[] fixes = null;
        if (reference instanceof LocalQuickFixProvider) {
            LocalQuickFixProvider local = (LocalQuickFixProvider)reference;
            fixes = local.getQuickFixes();
        }
        this.registerProblemForReference(reference, highlightType, descriptionTemplate, fixes);
    }

    public void registerProblemForReference(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType, @NotNull @InspectionMessage String descriptionTemplate, LocalQuickFix ... fixes) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(13);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(14);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(15);
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), descriptionTemplate, highlightType, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    public void registerProblem(@NotNull PsiReference reference) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(16);
        }
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    public void registerProblem(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(17);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(18);
        }
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), highlightType);
    }

    public void registerPossibleProblem(PsiElement identifier) {
        this.registerProblem(identifier, "possible problem", ProblemHighlightType.POSSIBLE_PROBLEM, new LocalQuickFix[0]);
    }

    @ApiStatus.Internal
    public void clearResults() {
        this.myProblems.clear();
    }

    @NotNull
    @InspectionMessage
    public static String unresolvedReferenceMessage(@NotNull PsiReference reference) {
        String message;
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(19);
        }
        if (reference instanceof EmptyResolveMessageProvider) {
            EmptyResolveMessageProvider empty = (EmptyResolveMessageProvider)reference;
            String pattern = empty.getUnresolvedMessagePattern();
            try {
                message = BundleBase.format((String)pattern, (Object[])new Object[]{reference.getCanonicalText()});
            }
            catch (IllegalArgumentException ex) {
                message = pattern;
                LOG.info(pattern);
            }
        } else {
            message = AnalysisBundle.message("error.cannot.resolve.default.message", reference.getCanonicalText());
        }
        String string = message;
        if (string == null) {
            ProblemsHolder.$$$reportNull$$$0(20);
        }
        return string;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @Nullable TextRange rangeInElement, @NotNull @InspectionMessage String descriptionTemplate, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(21);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(22);
        }
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInElement, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable TextRange rangeInElement, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(23);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(24);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(25);
        }
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, rangeInElement, descriptionTemplate, highlightType, this.myOnTheFly, fixes));
    }

    @NotNull
    public @Unmodifiable List<ProblemDescriptor> getResults() {
        List<ProblemDescriptor> list = this.myProblems;
        if (list == null) {
            ProblemsHolder.$$$reportNull$$$0(26);
        }
        return list;
    }

    public ProblemDescriptor @NotNull [] getResultsArray() {
        List<ProblemDescriptor> problems = this.getResults();
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ProblemsHolder.$$$reportNull$$$0(27);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public final InspectionManager getManager() {
        InspectionManager inspectionManager = this.myManager;
        if (inspectionManager == null) {
            ProblemsHolder.$$$reportNull$$$0(28);
        }
        return inspectionManager;
    }

    public boolean hasResults() {
        return !this.myProblems.isEmpty();
    }

    public int getResultCount() {
        return this.myProblems.size();
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            ProblemsHolder.$$$reportNull$$$0(29);
        }
        return psiFile;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            ProblemsHolder.$$$reportNull$$$0(30);
        }
        return project;
    }

    @Contract(pure=true)
    @NotNull
    public ProblemBuilder problem(@NotNull PsiElement psiElement, @InspectionMessage @NotNull String descriptionTemplate) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(31);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(32);
        }
        return new ProblemBuilder(psiElement, descriptionTemplate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 26, 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 4: 
            case 21: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 22: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 6: 
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemsHolder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unresolvedReferenceMessage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsArray";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInPsiFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "redirectProblem";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemForReference";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unresolvedReferenceMessage";
                break;
            }
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "problem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 26, 27, 28, 29, 30 -> new IllegalStateException(string);
        };
    }

    public final class ProblemBuilder {
        private final @InspectionMessage @NotNull String myDescriptionTemplate;
        @NotNull
        private final PsiElement myPsiElement;
        @NotNull
        private ProblemHighlightType myHighlightType;
        @Nullable
        private TextRange myRange;
        @NotNull
        private final List<LocalQuickFix> myFixes;

        private ProblemBuilder(@InspectionMessage @NotNull PsiElement element, String template) {
            if (element == null) {
                ProblemBuilder.$$$reportNull$$$0(0);
            }
            if (template == null) {
                ProblemBuilder.$$$reportNull$$$0(1);
            }
            this.myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            this.myFixes = new ArrayList<LocalQuickFix>();
            this.myPsiElement = element;
            this.myDescriptionTemplate = template;
        }

        @Contract(value="_ -> this", mutates="this")
        public ProblemBuilder highlight(ProblemHighlightType problemHighlightType) {
            this.myHighlightType = problemHighlightType;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public ProblemBuilder range(@NotNull TextRange rangeInElement) {
            if (rangeInElement == null) {
                ProblemBuilder.$$$reportNull$$$0(2);
            }
            this.myRange = rangeInElement;
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public ProblemBuilder fix(@NotNull LocalQuickFix fix) {
            if (fix == null) {
                ProblemBuilder.$$$reportNull$$$0(3);
            }
            this.myFixes.add(fix);
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public ProblemBuilder fix(@NotNull ModCommandAction action) {
            if (action == null) {
                ProblemBuilder.$$$reportNull$$$0(4);
            }
            this.myFixes.add(LocalQuickFix.from(action));
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public ProblemBuilder maybeFix(@Nullable LocalQuickFix fix) {
            if (fix != null) {
                this.myFixes.add(fix);
            }
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        public ProblemBuilder maybeFix(@Nullable ModCommandAction action) {
            if (action != null) {
                this.myFixes.add(LocalQuickFix.from(action));
            }
            return this;
        }

        public void register() {
            ProblemsHolder.this.registerProblem(this.myPsiElement, this.myDescriptionTemplate, this.myHighlightType, this.myRange, this.myFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ProblemsHolder$ProblemBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "range";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

