/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance(AnalysisScope.class);
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    protected static final int PACKAGE = 5;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    @NotNull
    private final Project myProject;
    private final @Unmodifiable List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    protected final SearchScope myScope;
    private boolean mySearchInLibraries;
    private GlobalSearchScope myFilter;
    @Type
    protected int myType;
    private Set<? extends VirtualFile> myVFiles;
    private VirtualFileSet myFilesSet;
    private boolean myIncludeTestSource;
    private boolean myAnalyzeInjectedCode;

    public AnalysisScope(@NotNull Project project) {
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(0);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module module) {
        if (module == null) {
            AnalysisScope.$$$reportNull$$$0(1);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = module.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(Module @NotNull [] modules) {
        if (modules == null) {
            AnalysisScope.$$$reportNull$$$0(2);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = modules[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            AnalysisScope.$$$reportNull$$$0(3);
        }
        this(psiDirectory, null);
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory, @Nullable Module module) {
        if (psiDirectory == null) {
            AnalysisScope.$$$reportNull$$$0(4);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = module;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AnalysisScope.$$$reportNull$$$0(5);
        }
        this(psiFile, null);
    }

    public AnalysisScope(@NotNull PsiFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            AnalysisScope.$$$reportNull$$$0(6);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = module;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        GlobalSearchScope gss;
        if (scope == null) {
            AnalysisScope.$$$reportNull$$$0(7);
        }
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(8);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && (gss = (GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(9);
        }
        if (virtualFiles == null) {
            AnalysisScope.$$$reportNull$$$0(10);
        }
        this.myIncludeTestSource = true;
        this.myAnalyzeInjectedCode = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        VirtualFileSet files = VfsUtilCore.createCompactVirtualFileSet(virtualFiles);
        files.freeze();
        this.myVFiles = files;
        this.myType = 9;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        LOG.assertTrue(this.myFilesSet == null, (Object)"don't modify AnalysisScope after it has been used");
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        LOG.assertTrue(this.myFilesSet == null, (Object)"don't modify AnalysisScope after it has been used");
        this.myIncludeTestSource = includeTestSource;
    }

    public void setAnalyzeInjectedCode(boolean analyzeInjectedCode) {
        LOG.assertTrue(this.myFilesSet == null, (Object)"don't modify AnalysisScope after it has been used");
        this.myAnalyzeInjectedCode = analyzeInjectedCode;
    }

    @NotNull
    protected Processor<? super VirtualFile> createFileSearcher(@NotNull Collection<? super VirtualFile> addTo) {
        ProgressIndicator indicator;
        if (addTo == null) {
            AnalysisScope.$$$reportNull$$$0(11);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText(AnalysisBundle.message("scanning.scope.progress.title", new Object[0]));
        }
        Processor processor = virtualFile -> {
            addTo.add((VirtualFile)virtualFile);
            return true;
        };
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(12);
        }
        return processor;
    }

    private boolean isFilteredOut(@NotNull VirtualFile virtualFile) {
        GlobalSearchScope filter;
        if (virtualFile == null) {
            AnalysisScope.$$$reportNull$$$0(13);
        }
        if ((filter = this.myFilter) != null && !filter.contains(virtualFile)) {
            return true;
        }
        return !this.myIncludeTestSource && (Boolean)ReadAction.compute(() -> TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject)) != false;
    }

    @NotNull
    private FileIndex getFileIndex() {
        Object object = this.myModule == null ? ProjectRootManager.getInstance((Project)this.myProject).getFileIndex() : ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        if (object == null) {
            AnalysisScope.$$$reportNull$$$0(14);
        }
        return object;
    }

    @NotNull
    private static String displayProjectRelativePath(@NotNull PsiFileSystemItem item, @Nullable Module module) {
        VirtualFile virtualFile;
        if (item == null) {
            AnalysisScope.$$$reportNull$$$0(15);
        }
        LOG.assertTrue((virtualFile = item.getVirtualFile()) != null, (Object)item);
        String filePath = ProjectUtilCore.displayFilePath((Project)item.getProject(), (VirtualFile)virtualFile);
        String string = module == null ? filePath : ProjectUtilCore.appendModuleName((Module)module, (String)filePath, (boolean)false);
        if (string == null) {
            AnalysisScope.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        VirtualFile file;
        if (psiElement == null) {
            AnalysisScope.$$$reportNull$$$0(17);
        }
        return (file = psiElement.getContainingFile().getVirtualFile()) != null && this.contains(file);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AnalysisScope.$$$reportNull$$$0(18);
        }
        if (this.myFilesSet == null) {
            if (this.myType == 8 && this.myScope != null) {
                return this.myScope.contains(file);
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
                return index.isInContent(file) && !this.isFilteredOut(file);
            }
        }
        return this.getFileSet().contains((Object)file);
    }

    @NotNull
    protected VirtualFileSet createFilesSet() {
        final VirtualFileSet fileSet = VfsUtilCore.createCompactVirtualFileSet();
        switch (this.myType) {
            case 3: {
                fileSet.add((Object)((PsiFileSystemItem)this.myElement).getVirtualFile());
                fileSet.freeze();
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                long timeStamp = System.currentTimeMillis();
                this.accept(this.createFileSearcher((Collection<? super VirtualFile>)fileSet));
                fileSet.freeze();
                LOG.info("Scanning scope took " + (System.currentTimeMillis() - timeStamp) + " ms");
                break;
            }
            case 9: {
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
                for (VirtualFile virtualFile : this.myVFiles) {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(this, new VirtualFileVisitor.Option[0]){

                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                            boolean ignored;
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!(ignored = ((Boolean)ReadAction.compute(() -> fileIndex.isExcluded(file))).booleanValue()) && !file.isDirectory()) {
                                fileSet.add((Object)file);
                            }
                            VirtualFileVisitor.Result result = ignored ? SKIP_CHILDREN : CONTINUE;
                            if (result == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "file";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/analysis/AnalysisScope$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/analysis/AnalysisScope$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitFileEx";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitFileEx";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1 -> new IllegalStateException(string);
                            };
                        }
                    });
                }
                fileSet.freeze();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + this.myType + "; can't create file set off it");
            }
        }
        VirtualFileSet virtualFileSet = fileSet;
        if (virtualFileSet == null) {
            AnalysisScope.$$$reportNull$$$0(19);
        }
        return virtualFileSet;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(20);
        }
        this.acceptImpl(visitor, false);
    }

    public void acceptIdempotentVisitor(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(21);
        }
        this.acceptImpl(visitor, true);
    }

    private void acceptImpl(@NotNull PsiElementVisitor visitor, boolean idempotent) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(22);
        }
        boolean needReadAction = !ApplicationManager.getApplication().isReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        FileIndex fileIndex = this.getFileIndex();
        this.accept((Processor<? super VirtualFile>)((Processor)file -> {
            if (file.isDirectory()) {
                return true;
            }
            if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
                return true;
            }
            boolean isInContent = (Boolean)ReadAction.compute(() -> fileIndex.isInContent(file));
            if (isInContent && !this.isFilteredOut((VirtualFile)file) && !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.myProject)) {
                return AnalysisScope.processFile(file, visitor, psiManager, needReadAction, idempotent);
            }
            return true;
        }));
    }

    public boolean accept(@NotNull Processor<? super VirtualFile> processor) {
        List<Module> modules;
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(23);
        }
        if (this.myType == 9) {
            return this.getFileSet().process(file -> this.isFilteredOut((VirtualFile)file) || processor.process(file));
        }
        if (this.myFilesSet != null) {
            return this.myFilesSet.process(processor);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator = this.createScopeIterator(processor, this.myScope);
            if (!projectFileIndex.iterateContent(contentIterator)) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots((Project)this.myProject, (boolean)false, (boolean)false)) {
                    if (VfsUtilCore.iterateChildrenRecursively((VirtualFile)libraryRoot, (VirtualFileFilter)VirtualFileFilter.ALL, (ContentIterator)contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        SearchScope libraryRoots = this.myScope;
        if (libraryRoots instanceof LocalSearchScope) {
            LocalSearchScope lss = (LocalSearchScope)libraryRoots;
            PsiElement[] psiElements = lss.getScope();
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (PsiElement element : psiElements) {
                VirtualFile file2 = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile((PsiElement)element));
                if (file2 == null || !files.add(file2) || processor.process((Object)file2)) continue;
                return false;
            }
            return true;
        }
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof PsiDirectory) {
            PsiDirectory dir = (PsiDirectory)psiElement;
            return this.accept(dir, processor);
        }
        if (this.myElement != null) {
            VirtualFile file3 = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile((PsiElement)this.myElement));
            return file3 == null || processor.process((Object)file3);
        }
        List<Module> list = modules = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules != null) {
            for (Module module : modules) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                if (moduleFileIndex.iterateContent(this.createScopeIterator(processor, null))) continue;
                return false;
            }
            return true;
        }
        return projectFileIndex.iterateContent(this.createScopeIterator(processor, null));
    }

    @NotNull
    private VirtualFileSet getFileSet() {
        VirtualFileSet fileSet = this.myFilesSet;
        if (fileSet == null) {
            this.myFilesSet = fileSet = this.createFilesSet();
        }
        VirtualFileSet virtualFileSet = fileSet;
        if (virtualFileSet == null) {
            AnalysisScope.$$$reportNull$$$0(24);
        }
        return virtualFileSet;
    }

    @NotNull
    private ContentIterator createScopeIterator(@NotNull Processor<? super VirtualFile> processor, @Nullable SearchScope searchScope) {
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(25);
        }
        ContentIterator contentIterator = fileOrDir -> {
            boolean isInScope = (Boolean)ReadAction.compute(() -> {
                if (searchScope != null && !searchScope.contains(fileOrDir)) {
                    return false;
                }
                if (this.isFilteredOut(fileOrDir)) {
                    return false;
                }
                return !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, this.myProject);
            });
            return !isInScope || processor.process((Object)fileOrDir);
        };
        if (contentIterator == null) {
            AnalysisScope.$$$reportNull$$$0(26);
        }
        return contentIterator;
    }

    private static boolean processFile(@NotNull VirtualFile vFile, @NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, boolean needReadAction, boolean idempotent) {
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(27);
        }
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(28);
        }
        if (psiManager == null) {
            AnalysisScope.$$$reportNull$$$0(29);
        }
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            Project project = psiManager.getProject();
            if (idempotent) {
                ReadAction.nonBlocking(() -> AnalysisScope.doProcessFile(visitor, psiManager, vFile)).withDocumentsCommitted(project).inSmartMode(project).executeSynchronously();
            } else {
                AnalysisScope.commitAndRunInSmartMode(() -> AnalysisScope.doProcessFile(visitor, psiManager, vFile), project);
            }
        } else {
            AnalysisScope.doProcessFile(visitor, psiManager, vFile);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(Runnable runnable, Project project) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance((Project)project);
            dumbService.waitForSmartMode();
        } while (!(passed = ((Boolean)PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(() -> {
            if (dumbService.isDumb()) {
                return false;
            }
            runnable.run();
            return true;
        })).booleanValue()));
    }

    private static boolean shouldHighlightFile(@NotNull PsiFile file) {
        if (file == null) {
            AnalysisScope.$$$reportNull$$$0(30);
        }
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(@NotNull Module module) {
        if (module == null) {
            AnalysisScope.$$$reportNull$$$0(31);
        }
        return switch (this.myType) {
            case 1 -> true;
            case 4 -> {
                if (this.myModule == module) {
                    yield true;
                }
                yield false;
            }
            case 7 -> this.myModules.contains(module);
            case 8 -> {
                if (module.isDisposed()) {
                    yield false;
                }
                for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                    if (!this.myScope.contains(file)) continue;
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, @NotNull VirtualFile vFile) {
        if (visitor == null) {
            AnalysisScope.$$$reportNull$$$0(32);
        }
        if (psiManager == null) {
            AnalysisScope.$$$reportNull$$$0(33);
        }
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(34);
        }
        ProgressManager.checkCanceled();
        if (!vFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(vFile);
        if (psiFile == null || !AnalysisScope.shouldHighlightFile(psiFile)) {
            return;
        }
        psiFile.accept(visitor);
        InjectedLanguageManager.getInstance((Project)psiManager.getProject()).dropFileCaches(psiFile);
    }

    protected boolean accept(@NotNull PsiDirectory dir, @NotNull Processor<? super VirtualFile> processor) {
        if (dir == null) {
            AnalysisScope.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            AnalysisScope.$$$reportNull$$$0(36);
        }
        Project project = dir.getProject();
        boolean processGeneratedFiles = GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(dir.getVirtualFile(), project);
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir.getVirtualFile(), (VirtualFileFilter)VirtualFileFilter.ALL, fileOrDir -> {
            if (this.isFilteredOut(fileOrDir)) {
                return true;
            }
            if (!processGeneratedFiles && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, project)) {
                return true;
            }
            return fileOrDir.isDirectory() || processor.process((Object)fileOrDir);
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    @NotNull
    @Nls
    public String getDisplayName() {
        return switch (this.myType) {
            case 8 -> this.myScope.getDisplayName();
            case 4 -> AnalysisBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
            case 7 -> AnalysisBundle.message("scope.module.list", StringUtil.join(this.myModules, module -> AnalysisScope.pathToName(module.getModuleFilePath()), (String)", "), this.myModules.size());
            case 1 -> AnalysisBundle.message("scope.project", this.myProject.getName());
            case 3 -> AnalysisBundle.message("scope.file", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement, this.myModule));
            case 2 -> AnalysisBundle.message("scope.directory", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement, this.myModule));
            case 9 -> AnalysisBundle.message("scope.virtual.files", new Object[0]);
            default -> "";
        };
    }

    @NotNull
    @Nls
    public String getShortenName() {
        return switch (this.myType) {
            case 8 -> this.myScope.getDisplayName();
            case 4 -> AnalysisBundle.message("scope.option.module", this.myModule.getName());
            case 7 -> AnalysisBundle.message("scope.module.list", StringUtil.join(this.myModules, Module::getName, (String)", "), this.myModules.size());
            case 1 -> AnalysisBundle.message("scope.project", this.myProject.getName());
            case 3 -> AnalysisBundle.message("scope.file", this.getRelativePath());
            case 2 -> AnalysisBundle.message("scope.directory", this.getRelativePath());
            case 9 -> {
                int types = 0;
                for (VirtualFile var3_3 : this.myVFiles) {
                    if ((types |= var3_3.isDirectory() ? 2 : 1) == 3) break;
                }
                yield AnalysisBundle.message("scope.selected.files", types);
            }
            default -> "";
        };
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AnalysisScope.$$$reportNull$$$0(37);
        }
        return project;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public @Unmodifiable List<Module> getModules() {
        List<Object> list = this.myModules == null ? Collections.emptyList() : this.myModules;
        if (list == null) {
            AnalysisScope.$$$reportNull$$$0(38);
        }
        return list;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public @Unmodifiable Set<VirtualFile> getFiles() {
        Set<Object> set = this.myVFiles == null ? Collections.emptySet() : this.myVFiles;
        if (set == null) {
            AnalysisScope.$$$reportNull$$$0(39);
        }
        return set;
    }

    @NotNull
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement, this.myModule);
        if (relativePath.length() > 100) {
            String string = ((PsiFileSystemItem)this.myElement).getName();
            if (string == null) {
                AnalysisScope.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = relativePath;
        if (string == null) {
            AnalysisScope.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private static String pathToName(@NotNull String path) {
        if (path == null) {
            AnalysisScope.$$$reportNull$$$0(42);
        }
        File file = new File(path);
        String string = FileUtilRt.getNameWithoutExtension((String)file.getName());
        if (string == null) {
            AnalysisScope.$$$reportNull$$$0(43);
        }
        return string;
    }

    public int getFileCount() {
        return this.getFileSet().size();
    }

    public void invalidate() {
        if (this.myType == 9) {
            List valid = ContainerUtil.filter(this.myVFiles, virtualFile -> virtualFile != null && virtualFile.isValid());
            VirtualFileSet files = VfsUtilCore.createCompactVirtualFileSet((Collection)valid);
            files.freeze();
            this.myVFiles = files;
        }
        this.myFilesSet = null;
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            PsiElement psiElement = this.myElement;
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                directory = dir.getVirtualFile();
                if (index.isInSourceContent((VirtualFile)directory)) {
                    return isTest == TestSourcesFilter.isTestSources((VirtualFile)directory, (Project)this.myProject);
                }
            } else {
                PsiFile f;
                VirtualFile file;
                directory = this.myElement;
                if (directory instanceof PsiFile && (file = (f = (PsiFile)directory).getVirtualFile()) != null) {
                    return isTest == TestSourcesFilter.isTestSources((VirtualFile)file, (Project)this.myProject);
                }
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            AnalysisScope.$$$reportNull$$$0(44);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        return AnalysisScope.collectScopes(defaultProject, modules);
    }

    @NotNull
    protected static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull Set<? extends Module> modules) {
        if (defaultProject == null) {
            AnalysisScope.$$$reportNull$$$0(45);
        }
        if (modules == null) {
            AnalysisScope.$$$reportNull$$$0(46);
        }
        if (modules.isEmpty()) {
            return new AnalysisScope(defaultProject);
        }
        Module[] allModules = ModuleManager.getInstance((Project)defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        return new AnalysisScope(modulesToAnalyze.toArray(Module.EMPTY_ARRAY));
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, Module @NotNull [] allModules) {
        if (fromModule == null) {
            AnalysisScope.$$$reportNull$$$0(47);
        }
        if (allModules == null) {
            AnalysisScope.$$$reportNull$$$0(48);
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                ModuleOrderEntry moe;
                if (!(orderEntry instanceof ModuleOrderEntry) || !(moe = (ModuleOrderEntry)orderEntry).isExported() || fromModule != moe.getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module, Module @NotNull [] allModules) {
        if (module == null) {
            AnalysisScope.$$$reportNull$$$0(50);
        }
        if (allModules == null) {
            AnalysisScope.$$$reportNull$$$0(51);
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find((Object[])ModuleRootManager.getInstance((Module)dependency).getDependencies(), (Object)module) <= -1) continue;
            result.add(dependency);
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    @NotNull
    protected static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            AnalysisScope.$$$reportNull$$$0(53);
        }
        if (vFile == null) {
            AnalysisScope.$$$reportNull$$$0(54);
        }
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrary(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        HashSet<Module> hashSet = modules;
        if (hashSet == null) {
            AnalysisScope.$$$reportNull$$$0(55);
        }
        return hashSet;
    }

    @NotNull
    public SearchScope toSearchScope() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = switch (this.myType) {
            case 8 -> this.myScope;
            case 2 -> GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
            case 3 -> GlobalSearchScope.fileScope((PsiFile)((PsiFile)this.myElement));
            case 6 -> LocalSearchScope.EMPTY;
            case 4 -> {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope((Module)this.myModule);
                if (this.myIncludeTestSource) {
                    yield moduleScope;
                }
                yield GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
            }
            case 7 -> GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])this.myModules.stream().map(m -> GlobalSearchScope.moduleScope((Module)m)).toArray(GlobalSearchScope[]::new)));
            case 1 -> {
                if (this.myIncludeTestSource) {
                    yield GlobalSearchScope.projectScope((Project)this.myProject);
                }
                yield GlobalSearchScopesCore.projectProductionScope(this.myProject);
            }
            case 9 -> new GlobalSearchScope(){

                public boolean contains(@NotNull VirtualFile file) {
                    if (file == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return AnalysisScope.this.getFileSet().contains((Object)file);
                }

                public boolean isSearchInModuleContent(@NotNull Module aModule) {
                    if (aModule == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return false;
                }

                public boolean isSearchInLibraries() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aModule";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/analysis/AnalysisScope$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contains";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSearchInModuleContent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            default -> {
                LOG.error("invalid type " + this.myType);
                yield LocalSearchScope.EMPTY;
            }
        };
        if (object == null) {
            AnalysisScope.$$$reportNull$$$0(56);
        }
        return object;
    }

    public boolean isTotalScope() {
        return this.getScopeType() == 1 && this.isIncludeTestSource();
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public boolean isAnalyzeInjectedCode() {
        return this.myAnalyzeInjectedCode;
    }

    public void setFilter(@NotNull GlobalSearchScope filter) {
        if (filter == null) {
            AnalysisScope.$$$reportNull$$$0(57);
        }
        this.myFilter = filter;
    }

    @ApiStatus.Internal
    @Nullable
    public GlobalSearchScope getFilter() {
        return this.myFilter;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 16, 19, 24, 26, 37, 38, 39, 40, 41, 43, 49, 52, 55, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 31: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addTo";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/AnalysisScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 23: 
            case 25: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 27: 
            case 34: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProject";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModule";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModules";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/AnalysisScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileSearcher";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "displayProjectRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilesSet";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSet";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeIterator";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportBackwardDependencies";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectBackwardDependencies";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInterestingModules";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "toSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFileSearcher";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 49: 
            case 52: 
            case 55: 
            case 56: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFilteredOut";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "displayProjectRelativePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 20: 
            case 23: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "acceptIdempotentVisitor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "acceptImpl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createScopeIterator";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "containsModule";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doProcessFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "pathToName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedComplementaryScope";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectScopes";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getExportBackwardDependencies";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDirectBackwardDependencies";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getAllInterestingModules";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 16, 19, 24, 26, 37, 38, 39, 40, 41, 43, 49, 52, 55, 56 -> new IllegalStateException(string);
        };
    }

    public static @interface Type {
    }
}

