/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CharTailType
extends TailType {
    private final char myChar;
    private final boolean myOverwrite;

    public CharTailType(char aChar) {
        this(aChar, true);
    }

    public CharTailType(char aChar, boolean overwrite) {
        this.myChar = aChar;
        this.myOverwrite = overwrite;
    }

    @Override
    public boolean isApplicable(@NotNull InsertionContext context) {
        if (context == null) {
            CharTailType.$$$reportNull$$$0(0);
        }
        return !context.shouldAddCompletionChar() || context.getCompletionChar() != this.myChar;
    }

    @Override
    public int processTail(@NotNull Editor editor, int tailOffset) {
        if (editor == null) {
            CharTailType.$$$reportNull$$$0(1);
        }
        return CharTailType.insertChar(editor, tailOffset, this.myChar, this.myOverwrite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharTailType)) {
            return false;
        }
        CharTailType that = (CharTailType)o;
        return this.myChar == that.myChar;
    }

    public int hashCode() {
        return this.myChar;
    }

    @NonNls
    public String toString() {
        return "CharTailType:'" + this.myChar + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CharTailType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processTail";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

