/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributorEP;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionWithAny;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionContributor
implements PossiblyDumbAware {
    public static final ExtensionPointName<CompletionContributorEP> EP = new ExtensionPointName("com.intellij.completion.contributor");
    private final MultiMap<CompletionType, ProviderWithPattern> myMap = new MultiMap();
    private static final LanguageExtension<CompletionContributor> INSTANCE = new LanguageExtensionWithAny(EP.getName());

    public final void extend(@Nullable CompletionType type, @NotNull ElementPattern<? extends PsiElement> place, @NotNull CompletionProvider<CompletionParameters> provider) {
        if (place == null) {
            CompletionContributor.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            CompletionContributor.$$$reportNull$$$0(1);
        }
        this.myMap.putValue((Object)type, (Object)new ProviderWithPattern(place, provider));
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CompletionContributor.$$$reportNull$$$0(3);
        }
        Iterable<ProviderWithPattern> providers = this.getProviders(parameters);
        for (ProviderWithPattern provider : providers) {
            ProgressManager.checkCanceled();
            provider.processCandidates(parameters, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    @NotNull
    private Iterable<ProviderWithPattern> getProviders(@NotNull CompletionParameters parameters) {
        Iterable allProviders;
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(4);
        }
        Collection providers1 = this.myMap.get((Object)parameters.getCompletionType());
        Collection providers2 = this.myMap.get(null);
        Iterable iterable = allProviders = ContainerUtil.concat((Iterable)providers1, (Iterable)providers2);
        if (iterable == null) {
            CompletionContributor.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            CompletionContributor.$$$reportNull$$$0(6);
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NlsContexts.HintText
    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, @NotNull Editor editor) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            CompletionContributor.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        if (context == null) {
            CompletionContributor.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Deprecated
    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            CompletionContributor.$$$reportNull$$$0(11);
        }
        return false;
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            CompletionContributor.$$$reportNull$$$0(12);
        }
    }

    @NotNull
    public static List<CompletionContributor> forParameters(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionContributor.$$$reportNull$$$0(13);
        }
        List list = (List)ReadAction.compute(() -> {
            PsiElement position = parameters.getPosition();
            return CompletionContributor.forLanguageHonorDumbness(PsiUtilCore.getLanguageAtOffset((PsiFile)position.getContainingFile(), (int)parameters.getOffset()), position.getProject());
        });
        if (list == null) {
            CompletionContributor.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public static List<CompletionContributor> forLanguage(@NotNull Language language) {
        if (language == null) {
            CompletionContributor.$$$reportNull$$$0(15);
        }
        List list = INSTANCE.forKey((Object)language);
        if (list == null) {
            CompletionContributor.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static List<CompletionContributor> forLanguageHonorDumbness(@NotNull Language language, @NotNull Project project) {
        if (language == null) {
            CompletionContributor.$$$reportNull$$$0(17);
        }
        if (project == null) {
            CompletionContributor.$$$reportNull$$$0(18);
        }
        List list = DumbService.getInstance((Project)project).filterByDumbAwareness(CompletionContributor.forLanguage(language));
        if (list == null) {
            CompletionContributor.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 14, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionContributor";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguageHonorDumbness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extend";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 5: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "advertise";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleEmptyLookup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleAutoCompletionPossibility";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeAutoPopup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "duringCompletion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forParameters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "forLanguageHonorDumbness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 14, 16, 19 -> new IllegalStateException(string);
        };
    }

    private record ProviderWithPattern(@NotNull ElementPattern<? extends PsiElement> pattern, @NotNull CompletionProvider<CompletionParameters> provider) {
        @NotNull
        private final ElementPattern<? extends PsiElement> pattern;
        @NotNull
        private final CompletionProvider<CompletionParameters> provider;

        private ProviderWithPattern(@NotNull ElementPattern<? extends PsiElement> pattern, @NotNull CompletionProvider<CompletionParameters> provider) {
            if (pattern == null) {
                ProviderWithPattern.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                ProviderWithPattern.$$$reportNull$$$0(1);
            }
        }

        void processCandidates(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                ProviderWithPattern.$$$reportNull$$$0(2);
            }
            if (result == null) {
                ProviderWithPattern.$$$reportNull$$$0(3);
            }
            ProcessingContext context = new ProcessingContext();
            if (this.pattern.accepts((Object)parameters.getPosition(), context)) {
                this.provider.addCompletionVariants(parameters, context, result);
            }
        }

        @NotNull
        public ElementPattern<? extends PsiElement> pattern() {
            ElementPattern<? extends PsiElement> elementPattern = this.pattern;
            if (elementPattern == null) {
                ProviderWithPattern.$$$reportNull$$$0(4);
            }
            return elementPattern;
        }

        @NotNull
        public CompletionProvider<CompletionParameters> provider() {
            CompletionProvider<CompletionParameters> completionProvider = this.provider;
            if (completionProvider == null) {
                ProviderWithPattern.$$$reportNull$$$0(5);
            }
            return completionProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/CompletionContributor$ProviderWithPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/CompletionContributor$ProviderWithPattern";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processCandidates";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

