/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class OffsetMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance(OffsetMap.class);
    private final Document myDocument;
    private final Map<OffsetKey, RangeMarker> myMap;
    private final Set<OffsetKey> myModified;
    private volatile boolean myDisposed;

    public OffsetMap(@NotNull Document document) {
        if (document == null) {
            OffsetMap.$$$reportNull$$$0(0);
        }
        this.myMap = new HashMap<OffsetKey, RangeMarker>();
        this.myModified = new HashSet<OffsetKey>();
        this.myDocument = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffset(@NotNull OffsetKey key) {
        if (key == null) {
            OffsetMap.$$$reportNull$$$0(1);
        }
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            RangeMarker marker = this.myMap.get(key);
            if (marker == null) {
                throw new IllegalArgumentException("Offset " + String.valueOf(key) + " is not registered");
            }
            if (!marker.isValid()) {
                Object object;
                DocumentWindow window;
                this.removeOffset(key);
                String string = String.valueOf(key);
                String string2 = String.valueOf(marker);
                Document document = this.myDocument;
                boolean bl = !(document instanceof DocumentWindow) || (window = (DocumentWindow)document).isValid();
                document = this.myDocument;
                if (document instanceof DocumentWindow) {
                    DocumentWindow window2 = (DocumentWindow)document;
                    object = " (injected: " + Arrays.toString(window2.getHostRanges()) + ")";
                } else {
                    object = "";
                }
                throw new IllegalStateException("Offset " + string + " is invalid: " + string2 + ", document.valid=" + bl + (String)object);
            }
            int endOffset = marker.getEndOffset();
            if (marker.getStartOffset() != endOffset) {
                this.saveOffset(key, endOffset, false);
            }
            return endOffset;
        }
    }

    public boolean containsOffset(@NotNull OffsetKey key) {
        RangeMarker marker;
        if (key == null) {
            OffsetMap.$$$reportNull$$$0(2);
        }
        return (marker = this.myMap.get(key)) != null && marker.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOffset(@NotNull OffsetKey key, int offset) {
        if (key == null) {
            OffsetMap.$$$reportNull$$$0(3);
        }
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            if (offset < 0) {
                this.removeOffset(key);
                return;
            }
            this.saveOffset(key, offset, true);
        }
    }

    private void saveOffset(@NotNull OffsetKey key, int offset, boolean externally) {
        RangeMarker old;
        if (key == null) {
            OffsetMap.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.myDisposed);
        if (externally && this.myMap.containsKey(key)) {
            this.myModified.add(key);
        }
        if ((old = this.myMap.get(key)) != null) {
            old.dispose();
        }
        RangeMarker marker = this.myDocument.createRangeMarker(offset, offset);
        marker.setGreedyToRight(key.isMovableToRight());
        this.myMap.put(key, marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffset(@NotNull OffsetKey key) {
        if (key == null) {
            OffsetMap.$$$reportNull$$$0(5);
        }
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            ProgressManager.checkCanceled();
            LOG.assertTrue(!this.myDisposed);
            this.myModified.add(key);
            RangeMarker old = this.myMap.get(key);
            if (old != null) {
                old.dispose();
            }
            this.myMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Unmodifiable List<OffsetKey> getAllOffsets() {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            ProgressManager.checkCanceled();
            LOG.assertTrue(!this.myDisposed);
            return ContainerUtil.filter(this.myMap.keySet(), this::containsOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            StringBuilder builder = new StringBuilder("OffsetMap:");
            for (OffsetKey key : this.myMap.keySet()) {
                builder.append(key).append("->").append(this.myMap.get(key)).append(";");
            }
            return builder.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasModified(@NotNull OffsetKey key) {
        if (key == null) {
            OffsetMap.$$$reportNull$$$0(6);
        }
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            return this.myModified.contains(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<OffsetKey, RangeMarker> map = this.myMap;
        synchronized (map) {
            this.myDisposed = true;
            for (RangeMarker rangeMarker : this.myMap.values()) {
                rangeMarker.dispose();
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            OffsetMap.$$$reportNull$$$0(7);
        }
        return document;
    }

    @ApiStatus.Internal
    @NotNull
    public OffsetMap copyOffsets(@NotNull Document anotherDocument) {
        if (anotherDocument == null) {
            OffsetMap.$$$reportNull$$$0(8);
        }
        if (anotherDocument.getTextLength() != this.myDocument.getTextLength()) {
            LOG.error("Different document lengths: " + this.myDocument.getTextLength() + " for " + String.valueOf(this.myDocument) + " and " + anotherDocument.getTextLength() + " for " + String.valueOf(anotherDocument));
        }
        OffsetMap offsetMap = this.mapOffsets(anotherDocument, Function.identity());
        if (offsetMap == null) {
            OffsetMap.$$$reportNull$$$0(9);
        }
        return offsetMap;
    }

    @ApiStatus.Internal
    @NotNull
    public OffsetMap mapOffsets(@NotNull Document anotherDocument, @NotNull Function<? super Integer, Integer> mapping) {
        if (anotherDocument == null) {
            OffsetMap.$$$reportNull$$$0(10);
        }
        if (mapping == null) {
            OffsetMap.$$$reportNull$$$0(11);
        }
        OffsetMap result = new OffsetMap(anotherDocument);
        for (OffsetKey key : this.getAllOffsets()) {
            result.addOffset(key, mapping.apply((Integer)this.getOffset(key)));
        }
        OffsetMap offsetMap = result;
        if (offsetMap == null) {
            OffsetMap.$$$reportNull$$$0(12);
        }
        return offsetMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/OffsetMap";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherDocument";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/OffsetMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyOffsets";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsOffset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wasModified";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyOffsets";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapOffsets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 12 -> new IllegalStateException(string);
        };
    }
}

