/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionBean
extends CustomLoadingExtensionPointBean<CommonIntentionAction> {
    @Tag
    @RequiredElement
    public String className;
    @Tag
    public String language;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String category;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String categoryKey;
    @Tag
    public String bundleName;
    @Tag
    public String descriptionDirectoryName;
    @Tag
    public boolean skipBeforeAfter;

    @Nullable
    protected String getImplementationClassName() {
        return this.className;
    }

    public String @Nullable [] getCategories() {
        String baseName;
        if (this.categoryKey == null) {
            return this.category == null ? null : this.category.split("/");
        }
        String string = baseName = this.bundleName != null ? this.bundleName : this.getPluginDescriptor().getResourceBundleBaseName();
        if (baseName == null) {
            Logger.getInstance(IntentionActionBean.class).error("No resource bundle specified for " + String.valueOf(this.getPluginDescriptor()));
            return null;
        }
        ResourceBundle bundle = DynamicBundle.getResourceBundle((ClassLoader)this.getLoaderForClass(), (String)baseName);
        String[] keys = this.categoryKey.split("/");
        if (keys.length > 1) {
            String[] result = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                result[i] = AbstractBundle.message((ResourceBundle)bundle, (String)keys[i], (Object[])new Object[0]);
            }
            return result;
        }
        return AbstractBundle.message((ResourceBundle)bundle, (String)this.categoryKey, (Object[])new Object[0]).split("/");
    }

    public String getDescriptionDirectoryName() {
        return this.descriptionDirectoryName;
    }
}

