/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class ScratchFileService
implements VirtualFileEnumerationAware {
    private static final boolean useWorkspaceModel = SystemProperties.getBooleanProperty((String)"scratch.files.use.workspace.model", (boolean)true);
    private static final Supplier<ScratchFileService> ourInstance = CachedSingletonsRegistry.lazy(() -> (ScratchFileService)ApplicationManager.getApplication().getService(ScratchFileService.class));

    public static boolean isWorkspaceModelIntegrationEnabled() {
        return useWorkspaceModel;
    }

    public static ScratchFileService getInstance() {
        return ourInstance.get();
    }

    public abstract @SystemIndependent @NotNull String getRootPath(@NotNull RootType var1);

    @Nullable
    public VirtualFile getVirtualFile(@NotNull RootType rootType) {
        if (rootType == null) {
            ScratchFileService.$$$reportNull$$$0(0);
        }
        String path = this.getRootPath(rootType);
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    public abstract RootType getRootType(@Nullable VirtualFile var1);

    public abstract VirtualFile findFile(@NotNull RootType var1, @NotNull String var2, @NotNull Option var3) throws IOException;

    @NotNull
    public abstract PerFileMappings<Language> getScratchesMapping();

    @Nullable
    public static RootType findRootType(@Nullable VirtualFile file) {
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile parent = file.isDirectory() ? file : file.getParent();
        return ScratchFileService.getInstance().getRootType(parent);
    }

    @NotNull
    public static Set<VirtualFile> getAllRootPaths() {
        if (ScratchFileService.isWorkspaceModelIntegrationEnabled()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                ScratchFileService.$$$reportNull$$$0(1);
            }
            return set;
        }
        ScratchFileService instance = ScratchFileService.getInstance();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Set result = CollectionFactory.createSmallMemoryFootprintSet();
        for (RootType rootType : RootType.getAllRootTypes()) {
            if (rootType.isHidden()) continue;
            ContainerUtil.addIfNotNull((Collection)result, (Object)fileSystem.findFileByPath(instance.getRootPath(rootType)));
        }
        Set set = result;
        if (set == null) {
            ScratchFileService.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileService";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static enum Option {
        existing_only,
        create_if_missing,
        create_new_always;

    }
}

