/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcommand;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModNothing;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedModCommandAction<E extends PsiElement>
implements ModCommandAction {
    @Nullable
    private final SmartPsiElementPointer<E> myPointer;
    @Nullable
    private final Class<E> myClass;

    protected PsiBasedModCommandAction(@NotNull E element) {
        if (element == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(0);
        }
        this(element, null);
    }

    protected PsiBasedModCommandAction(@NotNull Class<E> elementClass) {
        if (elementClass == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(1);
        }
        this(null, elementClass);
    }

    @ApiStatus.Internal
    protected PsiBasedModCommandAction(@Nullable E element, @Nullable Class<E> elementClass) {
        assert (element != null || elementClass != null);
        this.myPointer = element != null ? SmartPointerManager.createPointer(element) : null;
        this.myClass = elementClass;
    }

    @Override
    @Nullable
    public final Presentation getPresentation(@NotNull ActionContext context) {
        E element;
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(2);
        }
        if ((element = this.getElement(context)) == null) {
            return null;
        }
        Presentation presentation = this.getPresentation(context, element);
        return this.addApplicableRange(presentation, context, element);
    }

    @Nullable
    private Presentation addApplicableRange(@Nullable Presentation presentation, @NotNull ActionContext context, @NotNull E element) {
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(4);
        }
        if (presentation == null) {
            return null;
        }
        if (context.file() != element.getContainingFile()) {
            return presentation;
        }
        ArrayList<Presentation.HighlightRange> ranges = new ArrayList<Presentation.HighlightRange>(presentation.rangesToHighlight());
        ranges.add(new Presentation.HighlightRange(element.getTextRange(), Presentation.HighlightingKind.APPLICABLE_TO_RANGE));
        return presentation.withHighlighting((Presentation.HighlightRange[])ranges.toArray(Presentation.HighlightRange[]::new));
    }

    @Nullable
    private E getElement(@NotNull ActionContext context) {
        E result;
        PsiElement left;
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(5);
        }
        if (this.myPointer != null) {
            PsiElement element = this.myPointer.getElement();
            if (element == null) {
                return null;
            }
            PsiFile file = element.getContainingFile();
            if (file != null && !this.isFileAllowed(file)) {
                return null;
            }
            return (E)element;
        }
        int offset = context.offset();
        PsiFile file = context.file();
        if (!this.isFileAllowed(file)) {
            return null;
        }
        if (context.element() != null && context.element().isValid()) {
            return this.getIfSatisfied(context.element(), context);
        }
        PsiElement right = file.findElementAt(offset);
        PsiElement psiElement = left = offset > 0 ? file.findElementAt(offset - 1) : right;
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            left = right;
        }
        if (right == null) {
            right = left;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        if (left != right) {
            while (right != commonParent) {
                result = this.getIfSatisfied(right, context);
                if (result != null) {
                    return result;
                }
                right = right.getParent();
            }
        }
        while (left != commonParent) {
            result = this.getIfSatisfied(left, context);
            if (result != null) {
                return result;
            }
            left = left.getParent();
        }
        while (commonParent != null) {
            E satisfied = this.getIfSatisfied(commonParent, context);
            if (satisfied != null) {
                return satisfied;
            }
            if (this.stopSearchAt(commonParent, context) || commonParent instanceof PsiFile) {
                return null;
            }
            commonParent = commonParent.getParent();
        }
        return null;
    }

    protected boolean isFileAllowed(@NotNull PsiFile file) {
        if (file == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(6);
        }
        return BaseIntentionAction.canModify((PsiElement)file);
    }

    private E getIfSatisfied(@NotNull PsiElement element, @NotNull ActionContext context) {
        Class<E> cls;
        if (element == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(8);
        }
        if (!(cls = Objects.requireNonNull(this.myClass)).isInstance(element)) {
            return null;
        }
        PsiElement e = (PsiElement)cls.cast(element);
        return (E)(this.isElementApplicable(e, context) ? e : null);
    }

    protected boolean stopSearchAt(@NotNull PsiElement element, @NotNull ActionContext context) {
        if (element == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(10);
        }
        return false;
    }

    protected boolean isElementApplicable(@NotNull E element, @NotNull ActionContext context) {
        if (element == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Override
    @NotNull
    public final ModCommand perform(@NotNull ActionContext context) {
        E element;
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(13);
        }
        if ((element = this.getElement(context)) == null) {
            ModNothing modNothing = ModNothing.NOTHING;
            if (modNothing == null) {
                PsiBasedModCommandAction.$$$reportNull$$$0(14);
            }
            return modNothing;
        }
        ModCommand modCommand = this.perform(context, element);
        if (modCommand == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(15);
        }
        return modCommand;
    }

    @Override
    @NotNull
    public final IntentionPreviewInfo generatePreview(@NotNull ActionContext context) {
        E element;
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(16);
        }
        if ((element = this.getElement(context)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PsiBasedModCommandAction.$$$reportNull$$$0(17);
            }
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = this.generatePreview(context, element);
        if (intentionPreviewInfo == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(18);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    protected IntentionPreviewInfo generatePreview(ActionContext context, E element) {
        ModCommand command = this.perform(context, element);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewUtils.getModCommandPreview(command, context);
        if (intentionPreviewInfo == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(19);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    protected abstract ModCommand perform(@NotNull ActionContext var1, @NotNull E var2);

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull E element) {
        if (context == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(20);
        }
        if (element == null) {
            PsiBasedModCommandAction.$$$reportNull$$$0(21);
        }
        return Presentation.of(this.getFamilyName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/modcommand/PsiBasedModCommandAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/modcommand/PsiBasedModCommandAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addApplicableRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileAllowed";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIfSatisfied";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stopSearchAt";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isElementApplicable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

