/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Injectable
implements Comparable<Injectable> {
    @NotNull
    public abstract String getId();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getDisplayName();

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getAdditionalDescription() {
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = EmptyIcon.ICON_16;
        if (icon == null) {
            Injectable.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    public int compareTo(@NotNull Injectable o) {
        if (o == null) {
            Injectable.$$$reportNull$$$0(1);
        }
        return this.getDisplayName().compareTo(o.getDisplayName());
    }

    @Nullable
    public abstract Language getLanguage();

    public Language toLanguage() {
        Language language = this.getLanguage();
        return language == null ? new Language(this.getId(), false){

            @NotNull
            public String getDisplayName() {
                String string = Injectable.this.getDisplayName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/injection/Injectable$1", "getDisplayName"));
            }
        } : language;
    }

    public static Injectable fromLanguage(final Language language) {
        return new Injectable(){

            @Override
            @NotNull
            public String getId() {
                String string = language.getID();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = language.getDisplayName();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nullable
            public String getAdditionalDescription() {
                LanguageFileType ft = language.getAssociatedFileType();
                return ft != null ? " (" + ft.getDescription() + ")" : null;
            }

            @Override
            @NotNull
            public Icon getIcon() {
                LanguageFileType ft = language.getAssociatedFileType();
                Icon icon = ft != null && ft.getIcon() != null ? ft.getIcon() : EmptyIcon.ICON_16;
                if (icon == null) {
                    2.$$$reportNull$$$0(2);
                }
                return icon;
            }

            @Override
            public Language getLanguage() {
                return language;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/injection/Injectable$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/injection/Injectable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/injection/Injectable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

