/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePatternPackageSet
extends PatternBasedPackageSet {
    private static final Logger LOG = Logger.getInstance(FilePatternPackageSet.class);
    @NonNls
    public static final String SCOPE_FILE = "file";
    @NonNls
    public static final String SCOPE_EXT = "ext";
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private final boolean myProjectFiles;

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        this(modulePattern, filePattern, true);
    }

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern, boolean projectFiles) {
        super(modulePattern);
        this.myPathPattern = filePattern;
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
        this.myProjectFiles = projectFiles;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        ProjectFileIndex fileIndex;
        if (file == null) {
            FilePatternPackageSet.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FilePatternPackageSet.$$$reportNull$$$0(1);
        }
        return this.fileMatcher(file, fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex(), holder != null ? holder.getProjectBaseDir() : project.getBaseDir()) && (this.myProjectFiles ? this.matchesModule(file, fileIndex) : FilePatternPackageSet.matchesLibrary(this.myModulePattern, file, fileIndex));
    }

    private boolean fileMatcher(@NotNull VirtualFile virtualFile, ProjectFileIndex fileIndex, VirtualFile projectBaseDir) {
        if (virtualFile == null) {
            FilePatternPackageSet.$$$reportNull$$$0(2);
        }
        if (virtualFile instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)virtualFile;
            virtualFile = window.getDelegate();
        }
        if (fileIndex.isInContent(virtualFile) != this.myProjectFiles) {
            return false;
        }
        Object relativePath = FilePatternPackageSet.getRelativePath(virtualFile, fileIndex, true, projectBaseDir);
        if (relativePath == null) {
            LOG.error("vFile: " + String.valueOf(virtualFile) + "; projectBaseDir: " + String.valueOf(projectBaseDir) + "; content File: " + String.valueOf(fileIndex.getContentRootForFile(virtualFile)));
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath) && !virtualFile.equals(projectBaseDir)) {
            return false;
        }
        if (virtualFile.isDirectory()) {
            relativePath = (String)relativePath + "/";
        }
        return this.myFilePattern.matcher((CharSequence)relativePath).matches();
    }

    public static String convertToRegexp(String aspectsntx, char separator) {
        StringBuilder buf = new StringBuilder(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\").append(separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\").append(separator).append("]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\").append(separator).append("(.*\\").append(separator).append(")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            if (curChar == '.') {
                buf.append("\\");
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\").append(separator).append("]*");
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern, this.myProjectFiles);
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getText() {
        @NonNls StringBuilder buf = new StringBuilder(this.myProjectFiles ? SCOPE_FILE : SCOPE_EXT);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        buf.append(':');
        buf.append(this.myPathPattern);
        String string = buf.toString();
        if (string == null) {
            FilePatternPackageSet.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getPattern() {
        return this.myPathPattern;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual((String)this.myPathPattern, (String)oldQName) || Comparing.strEqual((String)(oldQName + "//*"), (String)this.myPathPattern) || Comparing.strEqual((String)(oldQName + "/*"), (String)this.myPathPattern);
    }

    @Override
    @NotNull
    public PatternBasedPackageSet updatePattern(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(5);
        }
        return new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern.replace(oldName, newName), this.myProjectFiles);
    }

    @Override
    @NotNull
    public PatternBasedPackageSet updateModulePattern(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(7);
        }
        return new FilePatternPackageSet(this.myModulePatternText.replace(oldName, newName), this.myPathPattern, this.myProjectFiles);
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile virtualFile, @NotNull ProjectFileIndex index, boolean useFQName, VirtualFile projectBaseDir) {
        VirtualFile contentRootForFile;
        if (virtualFile == null) {
            FilePatternPackageSet.$$$reportNull$$$0(8);
        }
        if (index == null) {
            FilePatternPackageSet.$$$reportNull$$$0(9);
        }
        if ((contentRootForFile = index.getContentRootForFile(virtualFile)) != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRootForFile, (char)'/');
            if (relativePath != null) {
                return relativePath;
            }
            if (!virtualFile.getFileSystem().equals(contentRootForFile.getFileSystem())) {
                String relativeToParent;
                VirtualFile parent = virtualFile.getParent();
                String string = relativeToParent = parent != null ? VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)contentRootForFile, (char)'/') : null;
                if (relativeToParent != null) {
                    return relativeToParent + "/" + virtualFile.getName();
                }
            }
            return null;
        }
        Module module = index.getModuleForFile(virtualFile);
        if (module != null) {
            if (projectBaseDir != null && VfsUtilCore.isAncestor((VirtualFile)projectBaseDir, (VirtualFile)virtualFile, (boolean)false)) {
                String projectRelativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectBaseDir, (char)'/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile.getPath();
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile, ProjectFileIndex index) {
        ArrayList<String> path = new ArrayList<String>();
        for (VirtualFile directory = virtualFile; directory != null && index.isInLibrary(directory); directory = directory.getParent()) {
            path.add(directory.getName());
        }
        if (path.isEmpty()) {
            return "";
        }
        Collections.reverse(path);
        return StringUtil.join((String[])ArrayUtilRt.toStringArray(path), (int)1, (int)path.size(), (String)"/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCOPE_FILE;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileMatcher";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateModulePattern";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

