/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CompoundPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntersectionPackageSet
extends CompoundPackageSet {
    @NotNull
    public static PackageSet create(PackageSet ... sets) {
        if (sets == null) {
            IntersectionPackageSet.$$$reportNull$$$0(0);
        }
        if (sets.length == 0) {
            throw new IllegalArgumentException("empty arguments");
        }
        return sets.length == 1 ? sets[0] : new IntersectionPackageSet(sets);
    }

    private IntersectionPackageSet(PackageSet ... sets) {
        if (sets == null) {
            IntersectionPackageSet.$$$reportNull$$$0(1);
        }
        super(sets);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        if (file == null) {
            IntersectionPackageSet.$$$reportNull$$$0(2);
        }
        if (project == null) {
            IntersectionPackageSet.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = null;
        for (PackageSet set : this.mySets) {
            if (set instanceof PackageSetBase) {
                PackageSetBase base = (PackageSetBase)set;
                if (base.contains(file, project, holder)) continue;
                return false;
            }
            if (psiFile == null) {
                psiFile = IntersectionPackageSet.getPsiFile(file, project);
            }
            if (set.contains(psiFile, holder)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNodePriority() {
        return 2;
    }

    @Override
    public PackageSet map(@NotNull Function<? super PackageSet, ? extends PackageSet> transformation) {
        if (transformation == null) {
            IntersectionPackageSet.$$$reportNull$$$0(4);
        }
        return IntersectionPackageSet.create((PackageSet[])ContainerUtil.map((Object[])this.mySets, s -> (PackageSet)transformation.apply((PackageSet)s), (Object[])new PackageSet[this.mySets.length]));
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText == null) {
            this.myText = StringUtil.join((Object[])this.mySets, set -> {
                boolean needParen = set.getNodePriority() > this.getNodePriority();
                return (needParen ? "(" : "") + set.getText() + (needParen ? ")" : "");
            }, (String)"&&");
        }
        String string = this.myText;
        if (string == null) {
            IntersectionPackageSet.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/IntersectionPackageSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/IntersectionPackageSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

