/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevelColorIcon;
import com.intellij.codeHighlighting.HighlightDisplayLevelColorizedIcon;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\nJ\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0014\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "<init>", "(Lcom/intellij/lang/annotation/HighlightSeverity;)V", "icon", "Ljavax/swing/Icon;", "(Lcom/intellij/lang/annotation/HighlightSeverity;Ljavax/swing/Icon;)V", "outlineIcon", "(Lcom/intellij/lang/annotation/HighlightSeverity;Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "value", "getIcon", "()Ljavax/swing/Icon;", "getOutlineIcon", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "name", "getName", "()Ljava/lang/String;", "isNonSwitchable", "", "()Z", "Companion", "intellij.platform.analysis"})
public class HighlightDisplayLevel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HighlightSeverity severity;
    @NotNull
    private Icon icon;
    @NotNull
    private Icon outlineIcon;
    @NotNull
    private static final HashMap<HighlightSeverity, HighlightDisplayLevel> LEVEL_MAP = new HashMap();
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel ERROR;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel WARNING;
    @NotNull
    private static final TextAttributesKey DO_NOT_SHOW_KEY;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel DO_NOT_SHOW;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel CONSIDERATION_ATTRIBUTES;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel INFO;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel WEAK_WARNING;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR;
    @JvmField
    @NotNull
    public static final HighlightDisplayLevel NON_SWITCHABLE_WARNING;

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        this.severity = severity;
        Icon icon = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ICON_16");
        this.icon = icon;
        Icon icon2 = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ICON_16");
        this.outlineIcon = icon2;
    }

    @NotNull
    public final HighlightSeverity getSeverity() {
        return this.severity;
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this(severity, icon, icon);
    }

    private HighlightDisplayLevel(HighlightSeverity severity, Icon icon, Icon outlineIcon) {
        this(severity);
        this.icon = icon;
        this.outlineIcon = outlineIcon;
        LEVEL_MAP.put(this.severity, this);
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final Icon getOutlineIcon() {
        return this.outlineIcon;
    }

    @NotNull
    public String toString() {
        String string = this.severity.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getName() {
        String string = this.severity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean isNonSwitchable() {
        return false;
    }

    @JvmStatic
    @Nullable
    public static final HighlightDisplayLevel find(@Nullable String name) {
        return Companion.find(name);
    }

    @JvmStatic
    @Nullable
    public static final HighlightDisplayLevel find(@NotNull HighlightSeverity severity) {
        return Companion.find(severity);
    }

    @JvmStatic
    public static final void registerSeverity(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey key, @Nullable Icon icon) {
        Companion.registerSeverity(severity, key, icon);
    }

    public static final int getEmptyIconDim() {
        return Companion.getEmptyIconDim();
    }

    @JvmStatic
    @NotNull
    public static final Icon createIconByMask(@NotNull Color renderColor) {
        return Companion.createIconByMask(renderColor);
    }

    public /* synthetic */ HighlightDisplayLevel(HighlightSeverity severity, Icon icon, Icon outlineIcon, DefaultConstructorMarker $constructor_marker) {
        this(severity, icon, outlineIcon);
    }

    static {
        HighlightSeverity highlightSeverity = HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"GENERIC_SERVER_ERROR_OR_WARNING");
        TextAttributesKey textAttributesKey = CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"GENERIC_SERVER_ERROR_OR_WARNING");
        Icon icon = AllIcons.General.InspectionsWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InspectionsWarning");
        Icon icon2 = AllIcons.General.InspectionsWarningEmpty;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InspectionsWarningEmpty");
        GENERIC_SERVER_ERROR_OR_WARNING = HighlightDisplayLevel.Companion.createHighlightDisplayLevel(highlightSeverity, textAttributesKey, icon, icon2);
        HighlightSeverity highlightSeverity2 = HighlightSeverity.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity2, (String)"ERROR");
        TextAttributesKey textAttributesKey2 = CodeInsightColors.ERRORS_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"ERRORS_ATTRIBUTES");
        Icon icon3 = AllIcons.General.InspectionsError;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"InspectionsError");
        Icon icon4 = AllIcons.General.InspectionsErrorEmpty;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"InspectionsErrorEmpty");
        ERROR = HighlightDisplayLevel.Companion.createHighlightDisplayLevel(highlightSeverity2, textAttributesKey2, icon3, icon4);
        HighlightSeverity highlightSeverity3 = HighlightSeverity.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity3, (String)"WARNING");
        TextAttributesKey textAttributesKey3 = CodeInsightColors.WARNINGS_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"WARNINGS_ATTRIBUTES");
        Icon icon5 = AllIcons.General.InspectionsWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"InspectionsWarning");
        Icon icon6 = AllIcons.General.InspectionsWarningEmpty;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"InspectionsWarningEmpty");
        WARNING = HighlightDisplayLevel.Companion.createHighlightDisplayLevel(highlightSeverity3, textAttributesKey3, icon5, icon6);
        TextAttributesKey textAttributesKey4 = TextAttributesKey.createTextAttributesKey((String)"DO_NOT_SHOW");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"createTextAttributesKey(...)");
        DO_NOT_SHOW_KEY = textAttributesKey4;
        HighlightSeverity highlightSeverity4 = HighlightSeverity.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity4, (String)"INFORMATION");
        Icon icon7 = EmptyIcon.ICON_0;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"ICON_0");
        DO_NOT_SHOW = new HighlightDisplayLevel(highlightSeverity4, icon7);
        HighlightSeverity highlightSeverity5 = HighlightSeverity.TEXT_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity5, (String)"TEXT_ATTRIBUTES");
        Icon icon8 = EmptyIcon.ICON_0;
        Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"ICON_0");
        CONSIDERATION_ATTRIBUTES = new HighlightDisplayLevel(highlightSeverity5, icon8);
        HighlightSeverity highlightSeverity6 = HighlightSeverity.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity6, (String)"INFO");
        Icon icon9 = AllIcons.General.InspectionsWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"InspectionsWarning");
        Icon icon10 = AllIcons.General.InspectionsWarningEmpty;
        Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"InspectionsWarningEmpty");
        INFO = HighlightDisplayLevel.Companion.createHighlightDisplayLevel(highlightSeverity6, HighlightDisplayLevel.DO_NOT_SHOW_KEY, icon9, icon10);
        HighlightSeverity highlightSeverity7 = HighlightSeverity.WEAK_WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity7, (String)"WEAK_WARNING");
        TextAttributesKey textAttributesKey5 = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"WEAK_WARNING_ATTRIBUTES");
        Icon icon11 = AllIcons.General.InspectionsWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"InspectionsWarning");
        Icon icon12 = AllIcons.General.InspectionsWarningEmpty;
        Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"InspectionsWarningEmpty");
        WEAK_WARNING = HighlightDisplayLevel.Companion.createHighlightDisplayLevel(highlightSeverity7, textAttributesKey5, icon11, icon12);
        HighlightSeverity highlightSeverity8 = HighlightSeverity.ERROR;
        NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(highlightSeverity8){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public boolean isNonSwitchable() {
                return true;
            }
        };
        highlightSeverity8 = HighlightSeverity.WARNING;
        NON_SWITCHABLE_WARNING = new HighlightDisplayLevel(highlightSeverity8){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public boolean isNonSwitchable() {
                return true;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0006H\u0007J\"\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0007R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\f\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0003R\u0010\u0010\u0019\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u0003\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lcom/intellij/codeHighlighting/HighlightDisplayLevel$Companion;", "", "<init>", "()V", "LEVEL_MAP", "Ljava/util/HashMap;", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "Lkotlin/collections/HashMap;", "createHighlightDisplayLevel", "severity", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "icon", "Ljavax/swing/Icon;", "outlineIcon", "GENERIC_SERVER_ERROR_OR_WARNING", "ERROR", "WARNING", "DO_NOT_SHOW_KEY", "Lorg/jetbrains/annotations/NotNull;", "DO_NOT_SHOW", "CONSIDERATION_ATTRIBUTES", "INFO", "getINFO$annotations", "WEAK_WARNING", "NON_SWITCHABLE_ERROR", "NON_SWITCHABLE_WARNING", "find", "name", "", "registerSeverity", "", "emptyIconDim", "", "getEmptyIconDim$annotations", "getEmptyIconDim", "()I", "createIconByMask", "renderColor", "Ljava/awt/Color;", "intellij.platform.analysis"})
    public static final class Companion {
        private Companion() {
        }

        private final HighlightDisplayLevel createHighlightDisplayLevel(HighlightSeverity severity, TextAttributesKey key, Icon icon, Icon outlineIcon) {
            return new HighlightDisplayLevel(severity, new HighlightDisplayLevelColorizedIcon(key, icon), new HighlightDisplayLevelColorizedIcon(key, outlineIcon), null);
        }

        @Deprecated(message="use {@link #WEAK_WARNING} instead")
        public static /* synthetic */ void getINFO$annotations() {
        }

        @JvmStatic
        @Nullable
        public final HighlightDisplayLevel find(@Nullable String name) {
            HighlightDisplayLevel highlightDisplayLevel;
            String string = name;
            if (Intrinsics.areEqual((Object)string, (Object)"NON_SWITCHABLE_ERROR")) {
                highlightDisplayLevel = NON_SWITCHABLE_ERROR;
            } else if (Intrinsics.areEqual((Object)string, (Object)"NON_SWITCHABLE_WARNING")) {
                highlightDisplayLevel = NON_SWITCHABLE_WARNING;
            } else {
                for (Map.Entry entry : ((Map)LEVEL_MAP).entrySet()) {
                    HighlightSeverity severity = (HighlightSeverity)entry.getKey();
                    HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)entry.getValue();
                    if (!Intrinsics.areEqual((Object)severity.getName(), (Object)name)) continue;
                    return displayLevel;
                }
                highlightDisplayLevel = null;
            }
            return highlightDisplayLevel;
        }

        @JvmStatic
        @Nullable
        public final HighlightDisplayLevel find(@NotNull HighlightSeverity severity) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            return (HighlightDisplayLevel)LEVEL_MAP.get(severity);
        }

        @JvmStatic
        public final void registerSeverity(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey key, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Icon effectiveIcon = null;
            Icon outlineIcon = null;
            if (icon == null) {
                String string = key.getExternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
                if (StringsKt.contains((CharSequence)string, (CharSequence)"error", (boolean)true)) {
                    Icon icon2 = AllIcons.General.InspectionsError;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InspectionsError");
                    effectiveIcon = new HighlightDisplayLevelColorizedIcon(key, icon2);
                    Icon icon3 = AllIcons.General.InspectionsErrorEmpty;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"InspectionsErrorEmpty");
                    outlineIcon = new HighlightDisplayLevelColorizedIcon(key, icon3);
                } else {
                    Icon icon4 = AllIcons.General.InspectionsWarning;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"InspectionsWarning");
                    effectiveIcon = new HighlightDisplayLevelColorizedIcon(key, icon4);
                    Icon icon5 = AllIcons.General.InspectionsWarningEmpty;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"InspectionsWarningEmpty");
                    outlineIcon = new HighlightDisplayLevelColorizedIcon(key, icon5);
                }
            } else {
                effectiveIcon = icon;
                outlineIcon = icon;
            }
            HighlightDisplayLevel level = (HighlightDisplayLevel)LEVEL_MAP.get(severity);
            if (level == null) {
                v5 = new HighlightDisplayLevel(severity, effectiveIcon, outlineIcon, null);
            } else {
                level.icon = effectiveIcon;
                level.outlineIcon = outlineIcon;
                v5 = Unit.INSTANCE;
            }
        }

        public final int getEmptyIconDim() {
            return JBUIScale.scale((int)14);
        }

        @JvmStatic
        public static /* synthetic */ void getEmptyIconDim$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Icon createIconByMask(@NotNull Color renderColor) {
            Intrinsics.checkNotNullParameter((Object)renderColor, (String)"renderColor");
            return new HighlightDisplayLevelColorIcon(this.getEmptyIconDim(), renderColor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

