/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class LookupElement
extends UserDataHolderBase {
    public static final LookupElement[] EMPTY_ARRAY = new LookupElement[0];
    public static final Key<Long> LOOKUP_ELEMENT_SHOW_TIMESTAMP_MILLIS = Key.create((String)"lookup element shown timestamp");

    @NotNull
    public abstract String getLookupString();

    public @Unmodifiable @NotNull Set<String> getAllLookupStrings() {
        Set<String> set = Collections.singleton(this.getLookupString());
        if (set == null) {
            LookupElement.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Object getObject() {
        LookupElement lookupElement = this;
        if (lookupElement == null) {
            LookupElement.$$$reportNull$$$0(1);
        }
        return lookupElement;
    }

    @Nullable
    public PsiElement getPsiElement() {
        Object o = this.getObject();
        if (o instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)o;
            return psiElement;
        }
        if (o instanceof ResolveResult) {
            ResolveResult resolveResult = (ResolveResult)o;
            return resolveResult.getElement();
        }
        if (o instanceof PsiElementNavigationItem) {
            PsiElementNavigationItem navigationItem = (PsiElementNavigationItem)o;
            return navigationItem.getTargetElement();
        }
        if (o instanceof SmartPsiElementPointer) {
            SmartPsiElementPointer pointer = (SmartPsiElementPointer)o;
            return pointer.getElement();
        }
        return null;
    }

    public boolean isValid() {
        Object object = this.getObject();
        if (object instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)object;
            return psiElement.isValid();
        }
        return true;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            LookupElement.$$$reportNull$$$0(2);
        }
    }

    public boolean requiresCommittedDocuments() {
        return true;
    }

    @NotNull
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        AutoCompletionPolicy autoCompletionPolicy = AutoCompletionPolicy.SETTINGS_DEPENDENT;
        if (autoCompletionPolicy == null) {
            LookupElement.$$$reportNull$$$0(3);
        }
        return autoCompletionPolicy;
    }

    public String toString() {
        return this.getLookupString();
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            LookupElement.$$$reportNull$$$0(4);
        }
        presentation.setItemText(this.getLookupString());
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return null;
    }

    @Nullable
    public <T> T as(@NotNull ClassConditionKey<T> conditionKey) {
        if (conditionKey == null) {
            LookupElement.$$$reportNull$$$0(5);
        }
        return (T)((Object)(conditionKey.isInstance((Object)this) ? this : null));
    }

    @Nullable
    public <T> T as(@NotNull Class<T> clazz) {
        if (clazz == null) {
            LookupElement.$$$reportNull$$$0(6);
        }
        return (T)((Object)(clazz.isInstance((Object)this) ? this : null));
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isWorthShowingInAutoPopup() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        this.renderElement(presentation);
        return !presentation.getTailFragments().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoCompletionPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "as";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

