/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class ManagingFS
implements FileSystemInterface {
    private static ManagingFS ourInstance;

    public static ManagingFS getInstance() {
        ManagingFS instance = ourInstance;
        if (instance == null) {
            ourInstance = instance = (ManagingFS)ApplicationManager.getApplication().getService(ManagingFS.class);
        }
        return instance;
    }

    public static ManagingFS getInstanceOrNull() {
        return ourInstance;
    }

    @Nullable
    public abstract AttributeInputStream readAttribute(@NotNull VirtualFile var1, @NotNull FileAttribute var2);

    @NotNull
    public abstract AttributeOutputStream writeAttribute(@NotNull VirtualFile var1, @NotNull FileAttribute var2);

    @Deprecated(forRemoval=true)
    public abstract int getModificationCount(@NotNull VirtualFile var1);

    public abstract int getStructureModificationCount();

    @TestOnly
    public abstract int getFilesystemModificationCount();

    public abstract long getCreationTimestamp();

    public abstract boolean areChildrenLoaded(@NotNull VirtualFile var1);

    public abstract boolean wereChildrenAccessed(@NotNull VirtualFile var1);

    @Nullable
    public abstract NewVirtualFile findRoot(@NotNull String var1, @NotNull NewVirtualFileSystem var2);

    public abstract VirtualFile @NotNull [] getRoots();

    public abstract VirtualFile @NotNull [] getRoots(@NotNull NewVirtualFileSystem var1);

    public abstract VirtualFile @NotNull [] getLocalRoots();

    @Nullable
    public abstract VirtualFile findFileById(int var1);

    @ApiStatus.Internal
    @NotNull
    protected abstract <P, R> Function<P, R> accessDiskWithCheckCanceled(Function<? super P, ? extends R> var1);

    static {
        ApplicationManager.registerCleaner(() -> {
            ourInstance = null;
        });
    }
}

