/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.actions.BookmarkTypeChooser;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/bookmark/actions/NodeChooseTypeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.bookmarks"})
public final class NodeChooseTypeAction
extends DumbAwareAction {
    public NodeChooseTypeAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabledAndVisible(false);
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        AbstractTreeNode abstractTreeNode = ExtensionsKt.getBookmarkNodes(event);
        Object object = abstractTreeNode != null && (abstractTreeNode = (AbstractTreeNode)CollectionsKt.singleOrNull(abstractTreeNode)) != null ? abstractTreeNode.getValue() : null;
        Bookmark bookmark = object instanceof Bookmark ? (Bookmark)object : null;
        if (bookmark == null) {
            return;
        }
        Bookmark bookmark2 = bookmark;
        BookmarkType bookmarkType = manager.getType(bookmark2);
        if (bookmarkType == null) {
            return;
        }
        BookmarkType type = bookmarkType;
        if (type == BookmarkType.DEFAULT) {
            event.getPresentation().setText(BookmarkBundle.message("mnemonic.chooser.mnemonic.assign.action.text", new Object[0]));
        }
        event.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        AbstractTreeNode abstractTreeNode = ExtensionsKt.getBookmarkNodes(event);
        Object object = abstractTreeNode != null && (abstractTreeNode = (AbstractTreeNode)CollectionsKt.singleOrNull(abstractTreeNode)) != null ? abstractTreeNode.getValue() : null;
        Bookmark bookmark = object instanceof Bookmark ? (Bookmark)object : null;
        if (bookmark == null) {
            return;
        }
        Bookmark bookmark2 = bookmark;
        BookmarkType bookmarkType = manager.getType(bookmark2);
        if (bookmarkType == null) {
            return;
        }
        BookmarkType type = bookmarkType;
        Set set = manager.getAssignedTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAssignedTypes(...)");
        BookmarkGroup bookmarkGroup = ExtensionsKt.getFirstGroupWithDescription(bookmark2);
        BookmarkTypeChooser chooser = new BookmarkTypeChooser(type, set, bookmarkGroup != null ? bookmarkGroup.getDescription(bookmark2) : null);
        String string = WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1 ? BookmarkBundle.message("mnemonic.chooser.mnemonic.assign.popup.title", new Object[0]) : BookmarkBundle.message("mnemonic.chooser.mnemonic.change.popup.title", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String title = string;
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)chooser.getContent(), (JComponent)chooser.getFirstButton()).setFocusable(true).setRequestFocus(true).setMovable(false).setResizable(false).setTitle(title).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        chooser.setOnChosen((Function2<? super BookmarkType, ? super String, Unit>)((Function2)(arg_0, arg_1) -> NodeChooseTypeAction.actionPerformed$lambda$0(popup, manager, bookmark2, arg_0, arg_1)));
        popup.showInBestPositionFor(event.getDataContext());
    }

    private static final Unit actionPerformed$lambda$0(JBPopup $popup, BookmarksManager $manager, Bookmark $bookmark, BookmarkType chosenType, String description) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)chosenType, (String)"chosenType");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            $popup.closeOk(null);
            $manager.setType($bookmark, chosenType);
            if (Intrinsics.areEqual((Object)description, (Object)"")) break block1;
            List list2 = $manager.getGroups($bookmark);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getGroups(...)");
            BookmarkGroup bookmarkGroup = (BookmarkGroup)CollectionsKt.firstOrNull((List)list2);
            if (bookmarkGroup != null) {
                bookmarkGroup.setDescription($bookmark, description);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookmarkType.values().length];
            try {
                nArray[BookmarkType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

