/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.bookmark.ui.tree.FolderNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ide/bookmark/providers/FileBookmarkImpl;", "Lcom/intellij/ide/bookmark/FileBookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProvider", "()Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "hashCode", "", "equals", "other", "", "toString", "intellij.platform.bookmarks"})
public final class FileBookmarkImpl
implements FileBookmark {
    @NotNull
    private final LineBookmarkProvider provider;
    @NotNull
    private final OpenFileDescriptor descriptor;

    public FileBookmarkImpl(@NotNull LineBookmarkProvider provider, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.provider = provider;
        this.descriptor = new OpenFileDescriptor(this.getProvider().getProject(), file);
    }

    @NotNull
    public LineBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final OpenFileDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.descriptor.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"url", (Object)this.getFile().getUrl()));
    }

    @ApiStatus.Internal
    @NotNull
    public BookmarkNode<FileBookmark> createNode() {
        return this.getFile().isDirectory() ? (BookmarkNode)new FolderNode(this.getProvider().getProject(), this) : (BookmarkNode)new FileNode(this.getProvider().getProject(), this);
    }

    public boolean canNavigate() {
        return !this.getProvider().getProject().isDisposed() && this.descriptor.canNavigate();
    }

    public boolean canNavigateToSource() {
        return !this.getFile().isDirectory() && this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        this.descriptor.navigate(requestFocus);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.getFile()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof FileBookmarkImpl && Intrinsics.areEqual((Object)((FileBookmarkImpl)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((FileBookmarkImpl)other).getFile(), (Object)this.getFile());
    }

    @NotNull
    public String toString() {
        return "FileBookmarkImpl(file=" + this.getFile() + ",provider=" + this.getProvider() + ")";
    }
}

