/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.providers.UrlNode;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/bookmark/providers/InvalidBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "url", "", "line", "", "<init>", "(Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;Ljava/lang/String;I)V", "getProvider", "()Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "getUrl", "()Ljava/lang/String;", "getLine", "()I", "attributes", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/ide/bookmark/providers/UrlNode;", "hashCode", "equals", "", "other", "", "toString", "intellij.platform.bookmarks"})
public final class InvalidBookmark
implements Bookmark {
    @NotNull
    private final LineBookmarkProvider provider;
    @NotNull
    private final String url;
    private final int line;

    public InvalidBookmark(@NotNull LineBookmarkProvider provider, @NotNull String url, int line) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.provider = provider;
        this.url = url;
        this.line = line;
    }

    @NotNull
    public LineBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final int getLine() {
        return this.line;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)this.url), TuplesKt.to((Object)"line", (Object)String.valueOf(this.line))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public UrlNode createNode() {
        return new UrlNode(this.getProvider().getProject(), this);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.url, this.line};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof InvalidBookmark && Intrinsics.areEqual((Object)((InvalidBookmark)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((InvalidBookmark)other).url, (Object)this.url) && ((InvalidBookmark)other).line == this.line;
    }

    @NotNull
    public String toString() {
        return "InvalidBookmark(line=" + this.line + ",url=" + this.url + ",provider=" + this.getProvider() + ")";
    }
}

